/*
 * Decompiled with CFR 0.152.
 */
package lorentz;

import edu.davidson.graphics.Border;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import lorentz.SizedButton;
import lorentz.VarScrollBar;
import lorentz.XYCanvas;
import lorentz.YZCanvas;

public class Lorentz
extends SApplet
implements SStepable {
    private String button_start = "Start";
    private String button_stop = "Stop";
    private String label_efield = "E Field";
    private String label_bfield = "B Field";
    private String label_both = "Both";
    String label_xyfield = "XY Field";
    String label_yzfield = "YZ Field";
    private String label_speed = "v =";
    private VarScrollBar speedBar;
    private XYCanvas cXY;
    private YZCanvas cYZ;
    private Checkbox electric;
    private Checkbox magnetic;
    private Checkbox both;
    private SizedButton runBtn;
    private double m_speed = 0.5;
    private boolean showControls = true;

    public boolean action(Event event, Object object) {
        if (event.target.equals(this.electric)) {
            this.cXY.setShowTypes(true, false);
            this.cYZ.setShowTypes(true, false);
        } else if (event.target.equals(this.magnetic)) {
            this.cXY.setShowTypes(false, true);
            this.cYZ.setShowTypes(false, true);
        } else if (event.target.equals(this.both)) {
            this.cXY.setShowTypes(true, true);
            this.cYZ.setShowTypes(true, true);
        } else if (event.target.equals(this.runBtn)) {
            if (!this.clock.isRunning()) {
                this.runBtn.setLabel(this.button_stop);
                this.m_speed = this.speedBar.getValue();
                this.cXY.newReference = true;
                this.cXY.setBeta(this.m_speed);
                this.cYZ.newReference = true;
                this.cYZ.setBeta(this.m_speed);
                this.clock.startClock();
            } else {
                this.clock.stopClock();
                this.runBtn.setLabel(this.button_start);
                this.cXY.setPosition(0.0);
                this.cYZ.setPosition(0.0);
                this.cXY.repaint();
                this.cYZ.repaint();
            }
        } else {
            return false;
        }
        return true;
    }

    public void foward() {
        this.startAnimate();
    }

    public void startAnimate() {
        this.clock.startClock();
        this.runBtn.setLabel(this.button_stop);
        this.m_speed = this.speedBar.getValue();
        this.cXY.newReference = true;
        this.cXY.setBeta(this.m_speed);
        this.cYZ.newReference = true;
        this.cYZ.setBeta(this.m_speed);
    }

    public void pause() {
        this.stopAnimate();
    }

    public void stopAnimate() {
        this.clock.stopClock();
        this.runBtn.setLabel(this.button_start);
        this.cXY.setPosition(0.0);
        this.cYZ.setPosition(0.0);
        this.cXY.repaint();
        this.cYZ.repaint();
    }

    public void setSpeed(double d) {
        boolean bl = this.clock.isRunning();
        this.clock.stopClock();
        if (d != this.m_speed) {
            this.m_speed = d;
            if (this.cXY == null || this.cYZ == null) {
                return;
            }
            this.speedBar.setValue(this.m_speed);
            this.cXY.newReference = true;
            this.cXY.setBeta(this.m_speed);
            this.cYZ.newReference = true;
            this.cYZ.setBeta(this.m_speed);
        }
        if (bl) {
            this.clock.startClock();
        }
    }

    public boolean handleEvent(Event event) {
        if (event.target.equals(this.speedBar)) {
            if (this.cXY == null || this.cYZ == null) {
                return true;
            }
            if (this.m_speed == this.speedBar.getValue()) {
                return true;
            }
            this.m_speed = this.speedBar.getValue();
            this.cXY.newReference = true;
            this.cXY.setBeta(this.m_speed);
            this.cYZ.newReference = true;
            this.cYZ.setBeta(this.m_speed);
            return true;
        }
        return super.handleEvent(event);
    }

    public String getAppletInfo() {
        return "Name: Lorentz Ver 1.2\r\nAuthor: Wolfgang Christian\r\nEmail: wochristian@davidson.edu\r\n";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Speed", "double", "Reference frame"}};
        return stringArray;
    }

    protected void setResources() {
        this.button_start = this.localProperties.getProperty("button.start", this.button_start);
        this.button_stop = this.localProperties.getProperty("button.stop", this.button_stop);
        this.label_efield = this.localProperties.getProperty("label.efield", this.label_efield);
        this.label_bfield = this.localProperties.getProperty("label.bfield", this.label_bfield);
        this.label_both = this.localProperties.getProperty("label.both", this.label_both);
        this.label_xyfield = this.localProperties.getProperty("label.xyfield", this.label_xyfield);
        this.label_yzfield = this.localProperties.getProperty("label.yzfield", this.label_yzfield);
        this.label_speed = this.localProperties.getProperty("label.speed", this.label_speed);
    }

    public void init() {
        this.initResources(null);
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.m_speed = Double.valueOf(this.getParameter("Speed", "0.5"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 10;
        try {
            n = Integer.parseInt(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((Applet)((Object)this)).resize(400, 300);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Component)((Object)this)).setBackground(Color.lightGray);
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        panel.setLayout(new BorderLayout());
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        Panel panel2 = new Panel();
        panel2.setBackground(Color.lightGray);
        panel2.setLayout(new FlowLayout(1));
        this.electric = new Checkbox(this.label_efield, checkboxGroup, false);
        panel2.add(this.electric);
        this.magnetic = new Checkbox(this.label_bfield, checkboxGroup, false);
        panel2.add(this.magnetic);
        this.both = new Checkbox(this.label_both, checkboxGroup, true);
        panel2.add(this.both);
        panel.add("North", panel2);
        this.speedBar = new VarScrollBar(String.valueOf(String.valueOf(this.label_speed)).concat("  "), this.m_speed, 0.0, 0.99);
        panel.add("Center", (Component)new EtchedBorder((Component)this.speedBar));
        this.runBtn = new SizedButton(this.button_start);
        panel.add("West", this.runBtn);
        if (this.showControls) {
            ((Container)((Object)this)).add("South", panel);
        }
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 2));
        this.cXY = new XYCanvas(this);
        this.cXY.setBackground(Color.white);
        panel3.add(this.cXY);
        this.cYZ = new YZCanvas(this);
        this.cYZ.setBackground(Color.white);
        panel3.add(this.cYZ);
        ((Container)((Object)this)).add("Center", (Component)new Border((Component)panel3));
        this.cXY.setBeta(this.m_speed);
        this.cYZ.setBeta(this.m_speed);
        this.m_speed = 0.1;
        this.clock.setFPS((double)n);
        this.clock.addClockListener((SStepable)this);
    }

    public void destroy() {
        this.destroyed = true;
        this.clock.stopClock();
        super.destroy();
    }

    public void step(double d, double d2) {
        this.cXY.incPosition();
    }
}

