/*
 * Decompiled with CFR 0.152.
 */
package lorentz;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import lorentz.Lorentz;

class XYCanvas
extends Canvas {
    Lorentz applet;
    Image buff_image = null;
    int buff_width = 0;
    int buff_height = 0;
    private double beta = 0.0;
    boolean newReference = true;
    double position = 0.0;
    int pixPos = 0;
    private boolean showMagnetic = true;
    private boolean showElectric = true;

    XYCanvas(Lorentz lorentz) {
        this.applet = lorentz;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final void setPosition(double d) {
        this.position = d;
    }

    public synchronized void incPosition() {
        if (this.beta == 0.0) {
            return;
        }
        this.position += this.beta;
        if (this.position > (double)10) {
            this.position = -10.0;
        }
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.dispose();
    }

    public void setShowTypes(boolean bl, boolean bl2) {
        this.showElectric = bl;
        this.showMagnetic = bl2;
        this.newReference = true;
        this.repaint();
    }

    public synchronized void setBeta(double d) {
        this.beta = d;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 0.99) {
            d = 0.99;
        }
        this.repaint();
    }

    public synchronized void paint(Graphics graphics) {
        if (this.applet.destroyed) {
            return;
        }
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.beta < 0.0) {
            this.beta = 0.0;
        }
        if (this.beta > 0.99) {
            this.beta = 0.99;
        }
        double d = 1.0 / Math.sqrt(1.0 - this.beta * this.beta);
        int n3 = n / 2;
        int n4 = n2 / 2;
        if (n != this.buff_width || n2 != this.buff_height) {
            this.newReference = true;
            this.buff_width = n;
            this.buff_height = n2;
            this.buff_image = this.createImage(this.buff_width, this.buff_height);
        }
        if (this.newReference) {
            int n5;
            int n6;
            int n7;
            double d2;
            int n8;
            int n9;
            int n10;
            int n11;
            this.newReference = false;
            Graphics graphics2 = this.buff_image.getGraphics();
            graphics2.clearRect(0, 0, this.buff_width, this.buff_height);
            if (this.showMagnetic) {
                for (n11 = n3 % 10 - 10; n11 <= this.buff_width + 10; n11 += 10) {
                    for (n10 = n4 % 10 - 10; n10 <= this.buff_height + 10; n10 += 10) {
                        n9 = n11 - n3;
                        n8 = n10 - n4;
                        d2 = d * d * (double)n9 * (double)n9 + (double)(n8 * n8);
                        if (!(d2 >= 1.0)) continue;
                        double d3 = (double)(30000 * n8) * d * this.beta / d2 / Math.sqrt(d2);
                        boolean bl = !(d3 > 0.0);
                        if ((d3 = Math.sqrt(Math.abs(d3))) > (double)7) {
                            n7 = bl ? 255 : 0;
                            n6 = 0;
                            n5 = 255;
                            graphics2.setColor(new Color(n7, n5, n6));
                            d3 = 7.0;
                        } else {
                            n7 = bl ? 255 : (int)((double)255 * (1.0 - d3 / (double)7));
                            n5 = 255;
                            n6 = (int)((double)255 * (1.0 - d3 / (double)7));
                            graphics2.setColor(new Color(n7, n5, n6));
                        }
                        graphics2.fillRect(n11 - 5, n10 - 5, n11 + 5, n10 + 5);
                    }
                }
            }
            graphics2.setColor(Color.blue);
            if (this.showElectric) {
                for (n11 = n3 % 10; n11 < this.buff_width; n11 += 10) {
                    for (n10 = n4 % 10; n10 < this.buff_height; n10 += 10) {
                        double d4;
                        n9 = n11 - n3;
                        n8 = n10 - n4;
                        d2 = d * d * (double)n9 * (double)n9 + (double)(n8 * n8);
                        if (!(d2 >= 1.0)) continue;
                        double d5 = (double)(30000 * n9) * d / d2 / Math.sqrt(d2);
                        double d6 = Math.sqrt(d5 * d5 + (d4 = (double)(30000 * n8) * d / d2 / Math.sqrt(d2)) * d4);
                        if (d6 > (double)7) {
                            n7 = (int)((double)255 * (1.0 - Math.sqrt((double)7 / d6)));
                            n5 = 0;
                            n6 = (int)((double)255 * Math.sqrt((double)7 / d6));
                            graphics2.setColor(new Color(n7, n5, n6));
                            d5 = (double)7 * d5 / d6;
                            d4 = (double)7 * d4 / d6;
                        } else {
                            n7 = (int)((double)255 * (1.0 - d6 / (double)7));
                            n5 = (int)((double)255 * (1.0 - d6 / (double)7));
                            n6 = 255;
                            graphics2.setColor(new Color(n7, n5, n6));
                        }
                        graphics2.drawLine(n11, n10, (int)((double)n11 + d5), (int)((double)n10 + d4));
                    }
                }
            }
            graphics2.setColor(Color.black);
            graphics2.setColor(Color.red);
            graphics2.fillOval(n3 - 5, n4 - 5, 10, 10);
            graphics2.dispose();
        }
        if (this.position >= 0.0) {
            this.pixPos = (int)((this.position - 20.0) * (double)n / 20.0);
            graphics.drawImage(this.buff_image, this.pixPos, 0, this);
            this.pixPos = (int)(this.position * (double)n / 20.0);
            graphics.drawImage(this.buff_image, this.pixPos, 0, this);
        } else {
            this.pixPos = (int)(this.position * (double)n / 20.0);
            graphics.drawImage(this.buff_image, this.pixPos, 0, this);
            this.pixPos = (int)((this.position + 20.0) * (double)n / 20.0);
            graphics.drawImage(this.buff_image, this.pixPos, 0, this);
        }
        this.paintXYTitle(graphics);
        graphics.drawRect(0, 0, n, n2);
    }

    void paintXYTitle(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        graphics.setColor(Color.yellow);
        int n3 = 15 + fontMetrics.stringWidth(this.applet.label_xyfield);
        graphics.fillRect(0, 0, n3, 15);
        graphics.setColor(Color.black);
        graphics.drawString(this.applet.label_xyfield, 2, 12);
        graphics.drawRect(0, 0, n3, 15);
    }
}

