/*
 * Decompiled with CFR 0.152.
 */
package lorentz;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import lorentz.Lorentz;

class YZCanvas
extends Canvas {
    Lorentz applet;
    Image buff_image = null;
    int buff_width = 0;
    int buff_height = 0;
    private double beta = 0.0;
    private double position = 0.0;
    boolean newReference = true;
    private boolean showMagnetic = true;
    private boolean showElectric = true;

    YZCanvas(Lorentz lorentz) {
        this.applet = lorentz;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void setBeta(double d) {
        this.beta = d;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 0.99) {
            d = 0.99;
        }
        this.repaint();
    }

    public final void setPosition(double d) {
        this.position = d;
    }

    public void setShowTypes(boolean bl, boolean bl2) {
        this.showElectric = bl;
        this.showMagnetic = bl2;
        this.newReference = true;
        this.repaint();
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        double d;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.applet.destroyed) {
            return;
        }
        Dimension dimension = this.getSize();
        int n8 = dimension.width;
        int n9 = dimension.height;
        if (this.beta < 0.0) {
            this.beta = 0.0;
        }
        if (this.beta > 0.99) {
            this.beta = 0.99;
        }
        double d2 = 1.0 / Math.sqrt(1.0 - this.beta * this.beta);
        int n10 = n8 / 2;
        int n11 = n9 / 2;
        if (n8 != this.buff_width || n9 != this.buff_height) {
            this.newReference = true;
            this.buff_width = n8;
            this.buff_height = n9;
            this.buff_image = this.createImage(this.buff_width, this.buff_height);
        }
        if (!this.newReference) {
            // empty if block
        }
        this.newReference = false;
        Graphics graphics2 = this.buff_image.getGraphics();
        graphics2.clearRect(0, 0, this.buff_width, this.buff_height);
        graphics2.setColor(Color.green);
        if (this.showMagnetic) {
            for (n7 = n10 % 10; n7 < this.buff_width; n7 += 10) {
                for (n6 = n11 % 10; n6 < this.buff_height; n6 += 10) {
                    double d3;
                    n5 = n7 - n10;
                    n4 = n6 - n11;
                    d = n5 * n5 + n4 * n4;
                    if (!(d >= 1.0)) continue;
                    double d4 = (double)(30000 * n4) * d2 * this.beta / d / Math.sqrt(d);
                    double d5 = Math.sqrt(d4 * d4 + (d3 = -((double)(30000 * n5) * d2 * this.beta / d / Math.sqrt(d))) * d3);
                    if (d5 > (double)7) {
                        n3 = 0;
                        n2 = (int)((double)255 * Math.sqrt((double)7 / d5));
                        n = 0;
                        graphics2.setColor(new Color(n3, n2, n));
                        d4 = (double)7 * d4 / d5;
                        d3 = (double)7 * d3 / d5;
                    } else {
                        n3 = (int)((double)255 * (1.0 - d5 / (double)7));
                        n = (int)((double)255 * (1.0 - d5 / (double)7));
                        n2 = 255;
                        graphics2.setColor(new Color(n3, n2, n));
                    }
                    graphics2.drawLine((int)((double)n7 - d4 / (double)2), (int)((double)n6 - d3 / (double)2), (int)((double)n7 + d4 / (double)2), (int)((double)n6 + d3 / (double)2));
                }
            }
        }
        graphics2.setColor(Color.blue);
        if (this.showElectric) {
            for (n7 = n10 % 10; n7 < this.buff_width; n7 += 10) {
                for (n6 = n11 % 10; n6 < this.buff_height; n6 += 10) {
                    double d6;
                    n5 = n7 - n10;
                    n4 = n6 - n11;
                    d = n5 * n5 + n4 * n4;
                    if (!(d >= 1.0)) continue;
                    double d7 = (double)(30000 * n5) * d2 / d / Math.sqrt(d);
                    double d8 = Math.sqrt(d7 * d7 + (d6 = (double)(30000 * n4) * d2 / d / Math.sqrt(d)) * d6);
                    if (d8 > (double)7) {
                        n3 = (int)((double)255 * (1.0 - Math.sqrt((double)7 / d8)));
                        n2 = 0;
                        n = (int)((double)255 * Math.sqrt((double)7 / d8));
                        graphics2.setColor(new Color(n3, n2, n));
                        d7 = (double)7 * d7 / d8;
                        d6 = (double)7 * d6 / d8;
                    } else {
                        n3 = (int)((double)255 * (1.0 - d8 / (double)7));
                        n2 = (int)((double)255 * (1.0 - d8 / (double)7));
                        n = 255;
                        graphics2.setColor(new Color(n3, n2, n));
                    }
                    graphics2.drawLine(n7, n6, (int)((double)n7 + d7), (int)((double)n6 + d6));
                }
            }
        }
        graphics2.setColor(Color.black);
        this.paintYZTitle(graphics2);
        graphics2.setColor(Color.red);
        graphics2.fillOval(n10 - 5, n11 - 5, 10, 10);
        graphics2.dispose();
        graphics.drawImage(this.buff_image, 0, 0, this);
        graphics.drawRect(0, 0, n8, n9);
    }

    void paintYZTitle(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        graphics.setColor(Color.yellow);
        int n3 = 15 + fontMetrics.stringWidth(this.applet.label_yzfield);
        graphics.fillRect(0, 0, n3, 15);
        graphics.setColor(Color.black);
        graphics.drawString(this.applet.label_yzfield, 2, 12);
        graphics.drawRect(0, 0, n3, 15);
    }
}

