/*
 * Decompiled with CFR 0.152.
 */
package qTime;

import edu.davidson.graphics.Box;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import qTime.QTimeGraph;
import qTime.QTimeHelp;
import qTime.TabbedPanel;

public class QTime
extends SApplet
implements SStepable {
    private String button_start = "Run";
    private String button_stop = "Stop";
    private String button_reset = "Reset";
    private String button_submit = "Submit Functions";
    String label_qtime = "QTime";
    String label_qm = "QM";
    String label_help = "Help";
    String label_wavefunction = "Wavefunction";
    String label_time = "Time:";
    String label_energy = "Energy";
    String label_real = "Real";
    String label_imaginary = "Imaginary";
    String label_potential = "Potential";
    String label_new = "New System";
    String label_magnitude = "|Psi|";
    String label_phase = "alpha:";
    private double t = 0.0;
    private double m_dt = 0.1;
    Button runBtn = new Button("Run");
    Button resetBtn = new Button("Reset");
    Button parseBtn = new Button("Submit Functions");
    TextField potInput = new TextField(30);
    TextField reInput = new TextField(30);
    TextField imInput = new TextField(30);
    QTimeGraph graph;
    boolean m_fStandAlone = false;
    private String m_potential = "20*(step(1+x)-step(x-1))";
    private String m_real = "cos(2*pi*x)*exp(-(x+4)*(x+4))";
    private String m_imaginary = "sin(2*pi*x)*exp(-(x+4)*(x+4))";
    private int m_numPts = 256;
    private double m_minX = -10.0;
    private double m_maxX = 10.0;
    private boolean m_showControls = true;
    private int m_FPS = 10;
    private final String PARAM_FPS = "FPS";
    private final String PARAM_dt = "dt";
    private final String PARAM_potential = "potential";
    private final String PARAM_real = "real";
    private final String PARAM_imaginary = "imaginary";
    private final String PARAM_numPts = "numPts";
    private final String PARAM_minX = "minX";
    private final String PARAM_maxX = "maxX";
    private final String PARAM_showControls = "showControls";

    String GetParameter(String string, String[] stringArray) {
        if (stringArray == null) {
            return ((Applet)((Object)this)).getParameter(string);
        }
        String string2 = String.valueOf(String.valueOf(string)).concat("=");
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equalsIgnoreCase(stringArray[i].substring(0, string2.length())) || !(string3 = stringArray[i].substring(string2.length())).startsWith("\"") || !(string3 = string3.substring(1)).endsWith("\"")) continue;
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3;
    }

    void GetParameters(String[] stringArray) {
        String string = this.GetParameter("potential", stringArray);
        if (string != null) {
            this.m_potential = string;
        }
        if ((string = this.GetParameter("real", stringArray)) != null) {
            this.m_real = string;
        }
        if ((string = this.GetParameter("imaginary", stringArray)) != null) {
            this.m_imaginary = string;
        }
        if ((string = this.GetParameter("FPS", stringArray)) != null) {
            this.m_FPS = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("numPts", stringArray)) != null) {
            this.m_numPts = Integer.parseInt(string);
        }
        if ((string = this.GetParameter("minX", stringArray)) != null) {
            this.m_minX = Double.valueOf(string);
        }
        if ((string = this.GetParameter("maxX", stringArray)) != null) {
            this.m_maxX = Double.valueOf(string);
        }
        if ((string = this.GetParameter("showControls", stringArray)) != null) {
            this.m_showControls = Boolean.valueOf(string);
        }
        if ((string = this.GetParameter("dt", stringArray)) != null) {
            this.m_dt = Double.valueOf(string);
        }
    }

    public String getAppletInfo() {
        return "Name: QTime Ver 1.2\r\nAuthor: Wolfgang Christian\r\nEMail: wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"potential", "String", "Potential"}, {"real", "String", "Real part of wavefunction"}, {"imaginary", "String", "Imaginary part of wavefunction"}, {"FPS", "int", "Frames per second."}, {"dt", "double", "Time step per frame."}, {"numPts", "int", "Number of points to plot"}, {"minX", "double", "Minimum x value"}, {"maxX", "double", "Maximum x value"}, {"showControls", "boolean", "Show controls on screen"}};
        return stringArray;
    }

    protected void setResources() {
        this.button_start = this.localProperties.getProperty("button.start", this.button_start);
        this.button_stop = this.localProperties.getProperty("button.stop", this.button_stop);
        this.button_reset = this.localProperties.getProperty("button.reset", this.button_reset);
        this.button_submit = this.localProperties.getProperty("button.submit", this.button_submit);
        this.label_wavefunction = this.localProperties.getProperty("label.wavefunction", this.label_wavefunction);
        this.label_qtime = this.localProperties.getProperty("label.qtime", this.label_qtime);
        this.label_qm = this.localProperties.getProperty("label.qm", this.label_qm);
        this.label_help = this.localProperties.getProperty("label.help", this.label_help);
        this.label_time = this.localProperties.getProperty("label.time", this.label_time);
        this.label_energy = this.localProperties.getProperty("label.energy", this.label_energy);
        this.label_real = this.localProperties.getProperty("label.real", this.label_real);
        this.label_imaginary = this.localProperties.getProperty("label.imaginary", this.label_imaginary);
        this.label_potential = this.localProperties.getProperty("label.potential", this.label_potential);
        this.label_new = this.localProperties.getProperty("label.new", this.label_new);
        this.label_magnitude = this.localProperties.getProperty("label.magnitude", this.label_magnitude);
        this.label_phase = this.localProperties.getProperty("label.phase", this.label_phase);
    }

    public void init() {
        this.initResources(null);
        this.runBtn.setLabel(String.valueOf(String.valueOf(this.button_start)).concat(" "));
        this.resetBtn.setLabel(this.button_reset);
        this.parseBtn.setLabel(this.button_submit);
        if (!this.m_fStandAlone) {
            this.GetParameters(null);
        }
        ((Applet)((Object)this)).resize(400, 400);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this.graph = new QTimeGraph(this, this.m_numPts);
        if (!this.graph.setPotential(this.m_potential)) {
            System.out.println("Failed to parse potential!");
        }
        if (!this.graph.setReal(this.m_real)) {
            System.out.println("Failed to real psi!");
        }
        if (!this.graph.setImaginary(this.m_imaginary)) {
            System.out.println("Failed to parse imaginary psi!");
        }
        this.graph.setXMinMax(this.m_minX, this.m_maxX);
        panel.add("Center", (Component)((Object)this.graph));
        this.potInput.setText(this.m_potential);
        this.reInput.setText(this.m_real);
        this.imInput.setText(this.m_imaginary);
        if (this.m_showControls) {
            TabbedPanel tabbedPanel = new TabbedPanel();
            ((Container)((Object)this)).add("Center", tabbedPanel);
            Panel panel2 = new Panel();
            panel2.setLayout(new GridLayout(1, 2));
            panel2.add(this.runBtn);
            panel2.add(this.resetBtn);
            panel.add("South", panel2);
            tabbedPanel.addItem(this.label_wavefunction, panel);
            Panel panel3 = new Panel();
            panel3.setBackground(Color.lightGray);
            panel3.setLayout(new GridLayout(4, 1, 10, 30));
            panel3.add((Component)new Box((Component)this.reInput, this.label_real));
            panel3.add((Component)new Box((Component)this.imInput, this.label_imaginary));
            panel3.add((Component)new Box((Component)this.potInput, this.label_potential));
            panel3.add((Component)new Box((Component)this.parseBtn, this.label_new));
            tabbedPanel.addItem(this.label_qm, panel3);
            QTimeHelp qTimeHelp = new QTimeHelp(this);
            tabbedPanel.addItem(this.label_help, qTimeHelp);
        } else {
            ((Container)((Object)this)).add("Center", panel);
        }
        this.reset();
        this.clock.setDt(this.m_dt);
        this.clock.setFPS((double)this.m_FPS);
        this.clock.addClockListener((SStepable)this);
    }

    public void destroy() {
        super.destroy();
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public synchronized void start() {
        super.start();
        if (this.firstTime) {
            this.firstTime = false;
            this.runBtn.setLabel(this.button_stop);
            this.clock.startClock();
        }
    }

    public void forward() {
        this.runBtn.setLabel(this.button_stop);
        this.clock.startClock();
    }

    public void pause() {
        this.runBtn.setLabel(String.valueOf(String.valueOf(this.button_start)).concat(" "));
        if (this.clock.isRunning()) {
            this.clock.stopClock();
        }
    }

    public void step(double d, double d2) {
        this.t += this.m_dt;
        this.graph.stepState(this.m_dt);
        this.updateDataConnections();
    }

    public void stepForward() {
        if (this.clock.isRunning()) {
            this.pause();
            return;
        }
        boolean bl = false;
        if (this.clock.getDt() < 0.0) {
            bl = true;
        }
        this.clock.setDt(Math.abs(this.clock.getDt()));
        this.clock.doStep();
        if (bl) {
            this.clock.setDt(-Math.abs(this.clock.getDt()));
        }
    }

    public void stepTimeBack() {
        if (this.clock.isRunning()) {
            this.pause();
            return;
        }
        boolean bl = false;
        if (this.clock.getDt() < 0.0) {
            bl = true;
        }
        this.clock.setDt(-Math.abs(this.clock.getDt()));
        this.clock.doStep();
        if (!bl) {
            this.clock.setDt(Math.abs(this.clock.getDt()));
        }
    }

    public boolean action(Event event, Object object) {
        if (event.target.equals(this.runBtn)) {
            if (this.clock.isRunning()) {
                this.runBtn.setLabel(String.valueOf(String.valueOf(this.button_start)).concat(" "));
                this.clock.stopClock();
            } else {
                this.runBtn.setLabel(this.button_stop);
                this.clock.startClock();
            }
            return true;
        }
        if (event.target.equals(this.resetBtn)) {
            this.reset();
            return true;
        }
        if (event.target.equals(this.parseBtn)) {
            String string = this.potInput.getText();
            this.setPotential(string);
            string = this.reInput.getText();
            this.setReal(string);
            string = this.imInput.getText();
            this.setImaginary(string);
            this.reset();
            return true;
        }
        return false;
    }

    public void reset() {
        this.runBtn.setLabel(String.valueOf(String.valueOf(this.button_start)).concat(" "));
        this.clock.stopClock();
        this.clock.setTime(0.0);
        this.graph.reset();
        this.t = 0.0;
        ((Component)((Object)this.graph)).repaint();
        this.updateDataConnections();
    }

    public synchronized void setPotential(String string) {
        this.m_potential = string;
        this.potInput.setText(this.m_potential);
        if (!this.graph.setPotential(this.m_potential)) {
            this.potInput.setBackground(Color.red);
            System.out.println("Failed to parse potential!");
        } else {
            this.potInput.setBackground(Color.white);
        }
        this.potInput.setText(this.m_potential);
    }

    public synchronized void setReal(String string) {
        this.m_real = string;
        this.reInput.setText(this.m_real);
        if (!this.graph.setReal(this.m_real)) {
            this.reInput.setBackground(Color.red);
            System.out.println("Failed to parse real!");
        } else {
            this.reInput.setBackground(Color.white);
        }
        this.reInput.setText(this.m_real);
    }

    public synchronized void setImaginary(String string) {
        this.m_imaginary = string;
        this.imInput.setText(this.m_imaginary);
        if (!this.graph.setImaginary(this.m_imaginary)) {
            this.imInput.setBackground(Color.red);
            System.out.println("Failed to parse imaginary!");
        } else {
            this.imInput.setBackground(Color.white);
        }
        this.imInput.setText(this.m_imaginary);
    }

    public void setEnergyOffset(boolean bl) {
        this.graph.offsetFunction = bl;
        ((Component)((Object)this.graph)).repaint();
    }

    public synchronized void setShowAxes(boolean bl) {
        if (this.graph.isShowAxis() == bl) {
            return;
        }
        if (bl) {
            this.graph.setGutters(20, 20, 20, 20);
            this.graph.drawgrid = true;
        } else {
            this.graph.setGutters(0, 0, 0, 0);
            this.graph.drawgrid = false;
        }
        this.graph.setShowAxis(bl);
        ((Component)((Object)this.graph)).repaint();
    }

    public int getWavefunctionID() {
        return this.graph.getState().getID();
    }

    public synchronized void setShowPotential(boolean bl) {
        if (this.graph.showPotential == bl) {
            return;
        }
        this.graph.showPotential = bl;
        this.graph.parsePotential();
        ((Component)((Object)this.graph)).repaint();
    }

    public void setRGBColor(int n, int n2, int n3) {
        this.graph.setRGBColor(n, n2, n3);
    }

    public synchronized void setYMinMax(double d, double d2) {
        this.graph.setYMinMax(d, d2);
        this.reset();
    }

    public synchronized void setYAutoscaleOn() {
        this.graph.setYManualRange(false);
    }

    public synchronized void setYAutoscaleOff() {
        this.graph.setYManualRange(true);
    }

    public synchronized void setXMinMax(double d, double d2) {
        this.m_minX = d;
        this.m_maxX = d2;
        this.graph.setXMinMax(d, d2);
    }

    public void setCaption(String string) {
        this.graph.setCaption(string);
    }

    public void setXTitle(String string) {
        this.graph.setXTitle(string);
    }

    public void setYTitle(String string) {
        this.graph.setYTitle(string);
    }
}

