/*
 * Decompiled with CFR 0.152.
 */
package qTime;

import edu.davidson.display.Format;
import edu.davidson.graph.Axis;
import edu.davidson.graph.DataSet;
import edu.davidson.graph.Graph2D;
import edu.davidson.numerics.Parser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.image.ImageObserver;
import qTime.QTime;
import qTime.QTimeState;

public final class QTimeGraph
extends Graph2D {
    private boolean probability = true;
    boolean offsetFunction = true;
    boolean showPotential = true;
    Font f = new Font("Helvetica", 1, 14);
    Graphics g_drag = null;
    String caption = "QTime";
    int numPts;
    int count = 0;
    Image osi2 = null;
    Image osi = null;
    QTimeState state;
    QTime owner;
    boolean tempStopped = false;
    Parser parser = null;
    int iwidth = 0;
    int iheight = 0;
    int[] xpts;
    int[] ypts;
    double maxX = 10.0;
    double minX = -10.0;
    double maxY = 10.0;
    double minY = -10.0;
    Format format = new Format("%7.3g");
    Format formatAngle = new Format("%3i");
    Polygon polyline = new Polygon();
    DataSet data = new DataSet();
    Axis yaxis;
    Axis xaxis;
    Color currentColor = Color.black;
    protected boolean drag = false;
    String potentialStr;
    String realStr;
    String imaginaryStr;

    public QTimeGraph(QTime qTime, int n) {
        this.owner = qTime;
        this.caption = this.owner.label_qtime;
        this.parser = new Parser(1);
        this.parser.defineVariable(1, "x");
        ((Component)((Object)this)).setBackground(Color.white);
        this.numPts = n;
        this.state = new QTimeState(this.minX, this.maxX, this.numPts, qTime);
        this.borderTop = 18;
        this.borderBottom = 15;
        this.xaxis = this.createAxis(5);
        this.xaxis.setTitleText("X");
        this.xaxis.setLabelFont(new Font("Helvetica", 0, 10));
        this.xaxis.setTitleFont(new Font("TimesRoman", 0, 12));
        this.xaxis.setManualRange(true, this.minX, this.maxX);
        this.xaxis.maximum = this.maxX;
        this.xaxis.minimum = this.minX;
        this.yaxis = this.createAxis(2);
        this.yaxis.setTitleText(this.owner.label_energy);
        this.yaxis.setLabelFont(new Font("Helvetica", 0, 10));
        this.yaxis.setTitleFont(new Font("TimesRoman", 0, 12));
        this.data = new DataSet();
        this.data.linecolor = this.currentColor;
        this.xaxis.attachDataSet(this.data);
        this.yaxis.attachDataSet(this.data);
        this.attachDataSet(this.data);
    }

    public void paint(Graphics graphics) {
        if (((Component)((Object)this)).getSize().width == 0 || ((Component)((Object)this)).getSize().height == 0) {
            return;
        }
        if (this.osi == null || this.iwidth != ((Component)((Object)this)).getSize().width || this.iheight != ((Component)((Object)this)).getSize().height) {
            this.iwidth = ((Component)((Object)this)).getSize().width;
            this.iheight = ((Component)((Object)this)).getSize().height;
            this.osi = ((Component)((Object)this)).createImage(this.iwidth, this.iheight);
            this.osi2 = ((Component)((Object)this)).createImage(this.iwidth, this.iheight);
        }
        Graphics graphics2 = this.osi.getGraphics();
        graphics2.setColor(((Component)((Object)this)).getBackground());
        graphics2.fillRect(0, 0, this.iwidth, this.iheight);
        graphics2.setColor(graphics.getColor());
        graphics2.clipRect(0, 0, this.iwidth, this.iheight);
        super.paint(graphics2);
        graphics2.setColor(Color.black);
        graphics2.setFont(this.f);
        FontMetrics fontMetrics = graphics2.getFontMetrics(this.f);
        if (this.isShowAxis()) {
            graphics2.drawString(this.caption, (this.iwidth - fontMetrics.stringWidth(this.caption)) / 2, 10);
        } else {
            graphics2.drawString(this.caption, (this.iwidth - fontMetrics.stringWidth(this.caption)) / 2, 30);
        }
        graphics2.dispose();
        graphics.drawImage(this.osi, 0, 0, (ImageObserver)((Object)this));
        graphics.setColor(Color.black);
        String string = this.format.form(this.state.time);
        graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.owner.label_time))).append(" ").append(string))), 10, this.iheight - 15);
        if (this.polyline.npoints != this.iwidth + 1) {
            this.xpts = new int[this.iwidth + 1];
            this.ypts = new int[this.iwidth + 1];
            for (int i = 0; i <= this.iwidth; ++i) {
                this.xpts[i] = i;
                this.ypts[i] = this.iheight / 2;
            }
            this.polyline = new Polygon(this.xpts, this.ypts, this.iwidth + 1);
        }
        this.paintPsi(graphics);
        graphics.setColor(Color.black);
    }

    public void stepState(double d) {
        this.state.step(d);
        if (this.osi == null) {
            return;
        }
        if (this.polyline.npoints == 0) {
            return;
        }
        Graphics graphics = this.osi2.getGraphics();
        graphics.drawImage(this.osi, 0, 0, (ImageObserver)((Object)this));
        graphics.setColor(Color.black);
        String string = this.format.form(this.state.time);
        graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.owner.label_time))).append(" ").append(string))), 10, this.iheight - 15);
        this.paintPsi(graphics);
        graphics.dispose();
        graphics = ((Component)((Object)this)).getGraphics();
        graphics.drawImage(this.osi2, 0, 0, (ImageObserver)((Object)this));
        graphics.setColor(Color.black);
        graphics.dispose();
    }

    protected void paintPsi(Graphics graphics) {
        if (this.polyline.npoints == 0) {
            return;
        }
        int n = this.xaxis.getInteger(this.minX);
        int n2 = this.xaxis.getInteger(this.maxX) - n;
        graphics.clipRect(n, 0, n2, this.iheight);
        this.state.setXScale(n, n + n2);
        if (this.probability) {
            int n3 = this.iheight / 2;
            if (this.offsetFunction) {
                n3 = this.yaxis.getInteger(this.state.getEnergy());
            }
            this.state.fillPolyProb(this.iheight, n3, this.polyline, graphics);
        } else {
            this.state.setPolyProb(this.iheight, this.iheight / 2, this.polyline);
            graphics.setColor(Color.black);
            graphics.drawPolygon(this.polyline);
            this.state.setPolyProbNeg(this.iheight, this.iheight / 2, this.polyline);
            graphics.drawPolygon(this.polyline);
            this.state.setPolyReal(this.iheight, this.iheight / 2, this.polyline);
            graphics.setColor(Color.red);
            graphics.drawPolygon(this.polyline);
            this.state.setPolyImaginary(this.iheight, this.iheight / 2, this.polyline);
            graphics.setColor(Color.green);
            graphics.drawPolygon(this.polyline);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setGutters(int n, int n2, int n3, int n4) {
        this.borderLeft = n;
        this.borderTop = n2;
        this.borderRight = n3;
        this.borderBottom = n4;
    }

    public void setCaption(String string) {
        this.caption = string;
        ((Component)((Object)this)).repaint();
    }

    public void setXTitle(String string) {
        this.xaxis.setTitleText(string);
    }

    public void setYTitle(String string) {
        this.yaxis.setTitleText(string);
    }

    public boolean setPotential(String string) {
        this.parser.define(string);
        this.parser.parse();
        if (this.parser.getErrorCode() != 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parser.getErrorString()).append(" at function potential, position ").append(this.parser.getErrorPosition()))));
            return false;
        }
        this.potentialStr = string;
        this.parsePotential();
        return true;
    }

    public boolean setReal(String string) {
        this.parser.define(string);
        this.parser.parse();
        if (this.parser.getErrorCode() != 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parser.getErrorString()).append(" at function real, position ").append(this.parser.getErrorPosition()))));
            return false;
        }
        this.realStr = string;
        this.state.setReal(this.realStr);
        return true;
    }

    public boolean setImaginary(String string) {
        this.parser.define(string);
        this.parser.parse();
        if (this.parser.getErrorCode() != 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parser.getErrorString()).append(" at function imaginary, position ").append(this.parser.getErrorPosition()))));
            return false;
        }
        this.imaginaryStr = string;
        this.state.setImaginary(this.imaginaryStr);
        return true;
    }

    public void parsePotential() {
        double d = this.maxX;
        double d2 = this.minX;
        int n = 0;
        boolean bl = false;
        this.parser.define(this.potentialStr);
        this.parser.parse();
        if (this.parser.getErrorCode() != 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parser.getErrorString()).append(" at function potential, position ").append(this.parser.getErrorPosition()))));
            return;
        }
        double[] dArray = new double[2 * this.numPts];
        for (int i = 0; i < this.numPts; ++i) {
            double d3;
            dArray[n] = d3 = d2 + (double)i * (d - d2) / (double)(this.numPts - 1);
            try {
                double d4 = this.parser.evaluate(d3);
                if (d4 == d4) {
                    dArray[n + 1] = d4;
                } else {
                    System.out.println("Divide by zero!");
                    d4 = this.parser.evaluate(d3 + 1.0E-32);
                    dArray[n + 1] = d4 == d4 ? d4 : 0.0;
                }
                n += 2;
                continue;
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        if (n <= 2) {
            System.out.println("Error NO POINTS to PLOT!");
            return;
        }
        if (bl) {
            System.out.println("Error while calculating points!");
        }
        this.data.deleteData();
        if (this.showPotential) {
            try {
                this.data.append(dArray, n / 2);
            }
            catch (Exception exception) {
                System.out.println("Error while appending data!");
                return;
            }
        }
        this.state.setPotential(this.potentialStr);
        double d5 = this.state.getMaxV() - this.state.getMinV();
        if (d5 < 1.0E-9) {
            d5 = 1.0;
        }
        this.setYMinMax(this.state.getMinV() - 0.25 * d5, this.state.getMaxV() + 0.25 * d5);
        ((Component)((Object)this)).repaint();
    }

    public void setRGBColor(int n, int n2, int n3) {
        this.currentColor = new Color(n, n2, n3);
        ((Component)((Object)this)).repaint();
    }

    public void setYMinMax(double d, double d2) {
        this.minY = d;
        this.maxY = d2;
        this.yaxis.minimum = d;
        this.yaxis.maximum = d2;
        if (this.yaxis.isManualRange()) {
            this.yaxis.setManualRange(true, d, d2);
        }
        ((Component)((Object)this)).repaint();
    }

    public void setXMinMax(double d, double d2) {
        if (this.minX != d || this.maxX != d2) {
            if (d < d2) {
                this.minX = d;
                this.maxX = d2;
            } else {
                this.minX = d2;
                this.maxX = d;
            }
            this.xaxis.setManualRange(true, this.minX, this.maxX);
            this.state.setSpace(d, d2);
            this.parsePotential();
            this.state.setReal(this.realStr);
            this.state.setImaginary(this.imaginaryStr);
        }
    }

    public void reset() {
        double d;
        this.state.reset();
        if (this.yaxis.isManualRange()) {
            return;
        }
        double d2 = this.state.getMinV();
        double d3 = this.state.getMaxV();
        double d4 = this.state.getEnergy();
        if (d4 > d3) {
            d3 = d4;
        }
        if (d4 < d2) {
            d2 = d4;
        }
        if ((d = d3 - d2) < 1.0E-9) {
            d = 1.0;
        }
        if (d4 + d / (double)2 > d3) {
            d3 = d4 + d / (double)2;
        }
        if (d4 - d / (double)2 < d2) {
            d2 = d4 - d / (double)2;
        }
        this.setYMinMax(d2, d3);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.osi == null) {
            return false;
        }
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        ((Component)((Object)this)).requestFocus();
        if (this.g_drag != null) {
            this.g_drag.dispose();
        }
        this.tempStopped = this.owner.clock.isRunning();
        this.owner.clock.stopClock();
        this.g_drag = ((Component)((Object)this)).getGraphics();
        Graphics graphics = this.osi.getGraphics();
        this.paintPsi(graphics);
        graphics.dispose();
        this.drawCoord(n, n2);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.osi == null) {
            return false;
        }
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        this.g_drag.dispose();
        this.g_drag = null;
        this.polyline = new Polygon(this.xpts, this.ypts, this.iwidth + 1);
        ((Component)((Object)this)).repaint();
        if (this.tempStopped) {
            this.owner.clock.startClock();
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if ((event.modifiers & 4) != 0 || (event.modifiers & 8) != 0) {
            return false;
        }
        if (this.osi == null) {
            return false;
        }
        if (this.xaxis == null || this.yaxis == null) {
            return false;
        }
        this.drawCoord(n, n2);
        return true;
    }

    public void setYManualRange(boolean bl) {
        if (bl == this.yaxis.isManualRange()) {
            return;
        }
        if (!this.yaxis.isManualRange()) {
            this.minY = this.yaxis.minimum;
            this.maxY = this.yaxis.maximum;
        }
        this.yaxis.setManualRange(bl, this.minY, this.maxY);
        ((Component)((Object)this)).repaint();
    }

    public void drawCoord(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (this.osi != null) {
            this.g_drag.drawImage(this.osi, 0, 0, (ImageObserver)((Object)this));
        }
        this.g_drag.setColor(Color.black);
        this.g_drag.setFont(this.f);
        if (n < 3 * this.iwidth / 4) {
            this.g_drag.drawString("  X  : ".concat(String.valueOf(String.valueOf(this.format.form(this.xaxis.getDouble(n3))))), n3 + 20, n4 - 10);
            this.g_drag.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.owner.label_magnitude))).append(" ").append(this.format.form(this.getPsiFromPix(n3))))), n3 + 20, n4 + 10);
            this.g_drag.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.owner.label_phase))).append(" ").append(this.formatAngle.form((long)this.getAngleFromPix(n3))))), n3 + 20, n4 + 30);
        } else {
            this.g_drag.drawString("  X  : ".concat(String.valueOf(String.valueOf(this.format.form(this.xaxis.getDouble(n3))))), n3 - 80, n4 - 10);
            this.g_drag.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.owner.label_magnitude))).append(" ").append(this.format.form(this.getPsiFromPix(n3))))), n3 - 80, n4 + 10);
            this.g_drag.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.owner.label_phase))).append(" ").append(this.formatAngle.form((long)this.getAngleFromPix(n3))))), n3 - 80, n4 + 30);
        }
        this.g_drag.drawLine(n3 - 10, n4, n3 + 10, n4);
        this.g_drag.drawLine(n3, n4 - 10, n3, n4 + 10);
    }

    public double getPsiFromPix(int n) {
        return this.state.getPsiAtX(this.xaxis.getDouble(n));
    }

    public int getAngleFromPix(int n) {
        return this.state.getAngleAtX(this.xaxis.getDouble(n));
    }

    public QTimeState getState() {
        return this.state;
    }
}

