/*
 * Decompiled with CFR 0.152.
 */
package qTime;

import edu.davidson.numerics.Parser;
import edu.davidson.numerics.Util;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

public final class QTimeState
implements SDataSource {
    String[] varStrings = new String[]{"x", "v", "re", "im", "dre", "dim"};
    double[][] ds = new double[1][6];
    Parser parser;
    private double norm = 1.0;
    private double energy = 0.0;
    private double[] x;
    private double[] v;
    private double[] re;
    private double[] im;
    private double[] dre;
    private double[] dim;
    private double[] rei;
    private double[] imi;
    private Color[] colors = new Color[101];
    private int numPts;
    private double minV = 0.0;
    private double maxV = 0.0;
    double time = 0.0;
    double x0;
    double x1;
    int startPix;
    int endPix;
    double dx = 1.0;
    double dt = 1.0;
    double gamma = 1.0;
    double courant = 0.35;
    SApplet owner;

    public QTimeState(double d, double d2, int n, SApplet sApplet) {
        this.owner = sApplet;
        this.parser = new Parser(1);
        this.parser.defineVariable(1, "x");
        this.initColors();
        this.numPts = n;
        this.x = new double[this.numPts];
        this.v = new double[this.numPts];
        this.re = new double[this.numPts];
        this.im = new double[this.numPts];
        this.dre = new double[this.numPts];
        this.dim = new double[this.numPts];
        this.rei = new double[this.numPts];
        this.imi = new double[this.numPts];
        this.ds = new double[this.numPts][6];
        this.x0 = d;
        this.x1 = d2;
        this.dx = (this.x1 - this.x0) / (double)(this.numPts - 1);
        this.dt = this.dx * this.dx * this.courant;
        this.gamma = this.dt / (double)2 / this.dx / this.dx;
        for (int i = 0; i < this.numPts; ++i) {
            this.rei[i] = 0.0;
            this.imi[i] = 0.0;
            this.re[i] = 0.0;
            this.im[i] = 0.0;
            this.x[i] = this.x0 + this.dx * (double)i;
            this.v[i] = 0.0;
        }
        this.minV = 0.0;
        this.maxV = 0.0;
        SApplet.addDataSource((Object)this);
    }

    public final void step(double d) {
        double d2 = 0.0;
        double d3 = this.dt;
        for (int i = 0; d2 < d && i < 1000; d2 += d3, ++i) {
            if (d - d2 - d3 < 0.0) {
                d3 = d - d2;
            }
            this.stepRe(d3);
            this.stepIm(d3);
            this.setBoundary();
        }
        this.time += d2;
    }

    private final void stepRe(double d) {
        for (int i = 1; i < this.numPts - 1; ++i) {
            this.re[i] = this.re[i] - this.gamma * (this.im[i + 1] + this.im[i - 1] - (double)2 * this.im[i]) + d * this.v[i] * this.im[i];
        }
    }

    private final void stepIm(double d) {
        for (int i = 1; i < this.numPts - 1; ++i) {
            this.im[i] = this.im[i] + this.gamma * (this.re[i + 1] + this.re[i - 1] - (double)2 * this.re[i]) - d * this.v[i] * this.re[i];
        }
    }

    private void setBoundary() {
        this.re[0] = 0.0;
        this.im[0] = 0.0;
        this.re[this.numPts - 1] = 0.0;
        this.im[this.numPts - 1] = 0.0;
    }

    public void reset() {
        this.time = 0.0;
        this.calcNorm();
        this.calcEnergy();
        for (int i = 0; i < this.numPts; ++i) {
            this.re[i] = this.rei[i];
            this.im[i] = this.imi[i];
        }
    }

    public void setSpace(double d, double d2) {
        this.x0 = d;
        this.x1 = d2;
        this.dx = (this.x1 - this.x0) / (double)(this.numPts - 1);
        this.dt = this.dx * this.dx * this.courant;
        this.gamma = this.dt / (double)2 / this.dx / this.dx;
        for (int i = 0; i < this.numPts; ++i) {
            this.rei[i] = 0.0;
            this.imi[i] = 0.0;
            this.re[i] = 0.0;
            this.im[i] = 0.0;
            this.x[i] = this.x0 + this.dx * (double)i;
            this.v[i] = 0.0;
        }
    }

    public boolean setPotential(String string) {
        int n;
        double d = 0.0;
        boolean bl = false;
        this.parser.define(string);
        this.parser.parse();
        for (n = 0; n < this.numPts; ++n) {
            try {
                d = this.parser.evaluate(this.x[n]);
                if (d == d) {
                    this.v[n] = d;
                } else {
                    System.out.println("Divide by zero!");
                    d = this.parser.evaluate(this.x[n] + 1.0E-32);
                    this.v[n] = d == d ? d : 0.0;
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            this.v[n] = this.v[n];
            if (n == 0) {
                this.minV = this.v[0];
                this.maxV = this.v[0];
                continue;
            }
            if (this.v[n] < this.minV) {
                this.minV = this.v[n];
            }
            if (!(this.v[n] > this.maxV)) continue;
            this.maxV = this.v[n];
        }
        this.dt = this.dx * this.dx;
        for (n = 0; n < this.numPts; ++n) {
            if (!(this.v[n] > 0.0) || !(this.dt > 1.0 / (this.v[n] / (double)2 + 1.0 / this.dx / this.dx))) continue;
            this.dt = 1.0 / (this.v[n] / (double)2 + 1.0 / this.dx / this.dx);
        }
        for (n = 0; n < this.numPts; ++n) {
            if (!(this.v[n] < 0.0) || !(this.dt > (double)-2 / this.v[n])) continue;
            this.dt = (double)-2 / this.v[n];
        }
        this.dt *= this.courant;
        this.gamma = this.dt / (double)2 / this.dx / this.dx;
        this.reset();
        return bl;
    }

    public final double getMinV() {
        return this.minV;
    }

    public final double getMaxV() {
        return this.maxV;
    }

    public boolean setReal(String string) {
        double d = 0.0;
        boolean bl = false;
        this.parser.define(string);
        this.parser.parse();
        for (int i = 0; i < this.numPts; ++i) {
            try {
                d = this.parser.evaluate(this.x[i]);
                if (d == d) {
                    this.rei[i] = d;
                    continue;
                }
                System.out.println("Divide by zero!");
                d = this.parser.evaluate(this.x[i] + 1.0E-32);
                if (d == d) {
                    this.rei[i] = d;
                    continue;
                }
                this.rei[i] = 0.0;
                continue;
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        this.reset();
        return bl;
    }

    public boolean setImaginary(String string) {
        double d = 0.0;
        boolean bl = false;
        this.parser.define(string);
        this.parser.parse();
        for (int i = 0; i < this.numPts; ++i) {
            try {
                d = this.parser.evaluate(this.x[i]);
                if (d == d) {
                    this.imi[i] = d;
                    continue;
                }
                System.out.println("Divide by zero!");
                d = this.parser.evaluate(this.x[i] + 1.0E-32);
                if (d == d) {
                    this.imi[i] = d;
                    continue;
                }
                this.imi[i] = 0.0;
                continue;
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        this.reset();
        return bl;
    }

    public void setXScale(int n, int n2) {
        this.startPix = n;
        this.endPix = n2;
    }

    public void setPolyReal(int n, int n2, Polygon polygon) {
        if (this.numPts == 0) {
            return;
        }
        if (polygon.npoints == 0) {
            return;
        }
        for (int i = this.startPix; i <= this.endPix; ++i) {
            int n3 = (this.numPts - 1) * (i - this.startPix) / (this.endPix - this.startPix);
            polygon.ypoints[i] = (int)((double)n2 + this.re[n3] * (double)n / (double)2);
        }
    }

    public void setPolyImaginary(int n, int n2, Polygon polygon) {
        if (this.numPts == 0) {
            return;
        }
        for (int i = this.startPix; i <= this.endPix; ++i) {
            int n3 = (this.numPts - 1) * (i - this.startPix) / (this.endPix - this.startPix);
            polygon.ypoints[i] = (int)((double)n2 + this.im[n3] * (double)n / (double)2);
        }
    }

    public void setPolyProb(int n, int n2, Polygon polygon) {
        if (this.numPts == 0) {
            return;
        }
        if (polygon.npoints == 0) {
            return;
        }
        for (int i = this.startPix; i <= this.endPix; ++i) {
            int n3 = (this.numPts - 1) * (i - this.startPix) / (this.endPix - this.startPix);
            double d = -Math.sqrt(this.re[n3] * this.re[n3] + this.im[n3] * this.im[n3]);
            polygon.ypoints[i] = (int)((double)n2 + d * (double)n / (double)2);
        }
    }

    public void setPolyProbNeg(int n, int n2, Polygon polygon) {
        if (this.numPts == 0) {
            return;
        }
        if (polygon.npoints == 0) {
            return;
        }
        for (int i = this.startPix; i <= this.endPix; ++i) {
            int n3 = (this.numPts - 1) * (i - this.startPix) / (this.endPix - this.startPix);
            double d = Math.sqrt(this.re[n3] * this.re[n3] + this.im[n3] * this.im[n3]);
            polygon.ypoints[i] = (int)((double)n2 + d * (double)n / (double)2);
        }
    }

    public void fillPolyProb(int n, int n2, Polygon polygon, Graphics graphics) {
        if (this.numPts == 0) {
            return;
        }
        if (polygon.npoints == 0) {
            return;
        }
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        Polygon polygon2 = new Polygon(nArray, nArray2, 5);
        int n3 = 0;
        double d = Math.sqrt(this.re[0] * this.re[0] + this.im[0] * this.im[0]) / (double)2;
        int n4 = polygon.xpoints[this.startPix];
        int n5 = (int)((double)n2 + d * (double)n / (double)2);
        int n6 = (int)((double)n2 - d * (double)n / (double)2);
        for (int i = this.startPix + 1; i < this.endPix; ++i) {
            n3 = (this.numPts - 1) * (i - this.startPix) / (this.endPix - this.startPix);
            d = Math.sqrt(this.re[n3] * this.re[n3] + this.im[n3] * this.im[n3]) / (double)2;
            int n7 = polygon.xpoints[i];
            int n8 = (int)((double)n2 + d * (double)n / (double)2);
            int n9 = (int)((double)n2 - d * (double)n / (double)2);
            polygon2.xpoints[0] = n4;
            polygon2.ypoints[0] = n5;
            polygon2.xpoints[1] = n7;
            polygon2.ypoints[1] = n8;
            polygon2.xpoints[2] = n7;
            polygon2.ypoints[2] = n9;
            polygon2.xpoints[3] = n4;
            polygon2.ypoints[3] = n6;
            polygon2.xpoints[4] = n4;
            polygon2.ypoints[4] = n5;
            graphics.setColor(this.colorFromPhase(Math.atan2(this.im[n3], this.re[n3])));
            graphics.fillPolygon(polygon2);
            n4 = n7;
            n5 = n8;
            n6 = n9;
        }
    }

    private void calcNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numPts; ++i) {
            d += this.re[i] * this.re[i] + this.im[i] * this.im[i];
        }
        this.norm = d > 0.0 ? Math.sqrt(d * this.dx) : 1.0;
    }

    private void calcEnergy() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 1; i < this.numPts - 1; ++i) {
            d = -(this.re[i + 1] + this.re[i - 1] - (double)2 * this.re[i]) / (double)2 / this.dx / this.dx + this.v[i] * this.re[i];
            d2 = -(this.im[i + 1] + this.im[i - 1] - (double)2 * this.im[i]) / (double)2 / this.dx / this.dx + this.v[i] * this.im[i];
            d3 += this.re[i] * d;
            d4 += this.im[i] * d2;
            d5 += this.im[i] * d;
            d6 += this.re[i] * d2;
        }
        this.energy = (d3 + d4) * this.dx / this.norm / this.norm;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getPsiAtX(double d) {
        int n = 0;
        if (d < this.x[0] || d > this.x[this.numPts - 1]) {
            return 0.0;
        }
        while (d > this.x[n]) {
            ++n;
        }
        return Math.sqrt(this.re[n] * this.re[n] + this.im[n] * this.im[n]) / this.norm;
    }

    public int getAngleAtX(double d) {
        int n = 0;
        if (d < this.x[0] || d > this.x[this.numPts - 1]) {
            return 0;
        }
        while (d > this.x[n]) {
            ++n;
        }
        if (this.im[n] == 0.0 && this.re[n] == 0.0) {
            return 0;
        }
        return (int)((double)180 * Math.atan2(this.im[n], this.re[n]) / Math.PI);
    }

    private Color colorFromPhase(double d) {
        int n = (int)((double)50 + (double)50 * d / Math.PI);
        return this.colors[n];
    }

    private void initColors() {
        double d = Math.PI;
        for (int i = 0; i < 101; ++i) {
            int n = (int)((double)255 * Math.sin(d * (double)i / (double)100) * Math.sin(d * (double)i / (double)100));
            int n2 = (int)((double)255 * Math.sin(d * (double)i / (double)100 + d / (double)3) * Math.sin(d * (double)i / (double)100 + d / (double)3));
            int n3 = (int)((double)255 * Math.sin(d * (double)i / (double)100 + (double)2 * d / (double)3) * Math.sin(d * (double)i / (double)100 + (double)2 * d / (double)3));
            this.colors[i] = new Color(n3, n2, n);
        }
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public int getID() {
        return this.hashCode();
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this.owner;
    }

    public double[][] getVariables() {
        Util.numericDerivative((double)this.dx, (double[])this.re, (double[])this.dre);
        Util.numericDerivative((double)this.dx, (double[])this.im, (double[])this.dim);
        for (int i = 0; i < this.numPts; ++i) {
            this.ds[i][0] = this.x[i];
            this.ds[i][1] = this.v[i];
            this.ds[i][2] = this.re[i] / this.norm;
            this.ds[i][3] = this.im[i] / this.norm;
            this.ds[i][4] = this.dre[i] / this.norm;
            this.ds[i][5] = this.dim[i] / this.norm;
        }
        return this.ds;
    }
}

