/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.awt.Color;
import java.awt.Graphics;
import molecular.EnsemblePanel;
import molecular.MFEnsemble;
import molecular.MFLEnsemble;
import molecular.MFREnsemble;

public class MFEnsemblePanel
extends EnsemblePanel
implements SStepable {
    boolean flows = false;
    double iflCounter = 0.0;
    double oflCounter = 0.0;
    double ifrCounter = 0.0;
    double ofrCounter = 0.0;
    int midHeight = 15;
    int midLength = 20;
    int lwidth = 70;
    boolean lwSet = false;
    double top;
    double bottom;
    int nCollidingW = 0;
    int nCollidingE = 1;
    double time = 0.0;
    double mint = 10000.0;
    double temptime = 10000.0;
    double weight = 100.0;
    double wVel = 0.0;
    MFLEnsemble ensemble1 = null;
    MFREnsemble ensemble2 = null;
    MFEnsemble ensemble3 = null;
    double iFLeft = 100000.0;
    double iFRight = 100000.0;
    double oFLeft = 100000.0;
    double oFRight = 100000.0;
    double oRRate = 0.0;
    double oLRate = 0.0;
    double iLRate = 0.0;
    double iRRate = 0.0;
    double wwidth = 1.3;
    boolean partInt = true;

    public MFEnsemblePanel(SApplet sApplet) {
        super(sApplet);
        this.ensemble1 = new MFLEnsemble(this);
        this.ensemble2 = new MFREnsemble(this);
        this.ensemble3 = new MFEnsemble(this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void step(double d, double d2) {
        double d3 = d;
        this.ensemble1.clearPressureCounters();
        this.ensemble2.clearPressureCounters();
        this.ensemble3.clearPressureCounters();
        do {
            if (d3 < this.mint) {
                this.mint -= d3;
                d3 -= this.advanceDT(d3);
                continue;
            }
            d3 -= this.advanceDT(this.mint);
            this.updateTimes(this.temptime);
            switch (this.nCollidingW) {
                case 0: {
                    this.collideParticles();
                    break;
                }
                case 1: {
                    this.collideTW();
                    break;
                }
                case 2: {
                    this.collideRW();
                    break;
                }
                case 3: {
                    this.collideBW();
                    break;
                }
                case 4: {
                    this.collideLW();
                }
            }
            this.findMinColTime();
        } while (d3 > 0.0);
        if (this.flows) {
            this.owner.clock.stopClock();
            if (this.iflCounter <= 0.0) {
                this.ensemble1.iflowPart();
                this.iflCounter = this.iFLeft;
            } else {
                this.iflCounter -= d;
            }
            if (this.ifrCounter <= 0.0) {
                this.ensemble2.iflowPart();
                this.ifrCounter = this.iFRight;
            } else {
                this.ifrCounter -= d;
            }
            if (this.oflCounter <= 0.0) {
                this.ensemble1.oflowPart();
                this.oflCounter = this.oFLeft;
            } else {
                this.oflCounter -= d;
            }
            if (this.ofrCounter <= 0.0) {
                this.ensemble2.oflowPart();
                this.ofrCounter = this.oFRight;
            } else {
                this.ofrCounter -= d;
            }
            this.owner.clock.startClock();
        }
        this.paintOSI();
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.dispose();
        this.time = d2 + d;
        this.ensemble1.adjustPressureCounters(d);
        this.ensemble2.adjustPressureCounters(d);
        this.ensemble3.adjustPressureCounters(d);
        if (this.ensemble1.histogram != null) {
            this.owner.clearData(this.ensemble1.histogram.hashCode());
        }
        if (this.ensemble2.histogram != null) {
            this.owner.clearData(this.ensemble2.histogram.hashCode());
        }
        if (this.ensemble3.histogram != null) {
            this.owner.clearData(this.ensemble2.histogram.hashCode());
        }
        if (this.owner != null) {
            this.owner.updateDataConnections();
        }
    }

    public void collideParticles() {
        if (!this.partInt) {
            return;
        }
        if (this.nCollidingE == 1) {
            this.ensemble1.collideParticles(this.ensemble1.nColliding1, this.ensemble1.nColliding2);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideParticles(this.ensemble2.nColliding1, this.ensemble2.nColliding2);
        } else if (this.nCollidingE == 3) {
            this.ensemble3.collideParticles(this.ensemble3.nColliding1, this.ensemble3.nColliding2);
        }
    }

    public void collideTW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideTW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideTW(this.ensemble2.nColliding1);
        } else if (this.nCollidingE == 3) {
            this.ensemble3.collideTW(this.ensemble3.nColliding1);
        }
    }

    public void collideRW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideRW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideRW(this.ensemble2.nColliding1);
        } else if (this.nCollidingE == 3) {
            this.ensemble3.collideRW(this.ensemble3.nColliding1);
        }
    }

    public void collideBW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideBW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideBW(this.ensemble2.nColliding1);
        } else if (this.nCollidingE == 3) {
            this.ensemble3.collideBW(this.ensemble3.nColliding1);
        }
    }

    public void collideLW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideLW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideLW(this.ensemble2.nColliding1);
        } else if (this.nCollidingE == 3) {
            this.ensemble3.collideLW(this.ensemble3.nColliding1);
        }
    }

    public double advanceDT(double d) {
        this.ensemble1.advanceDT(d);
        this.ensemble2.advanceDT(d);
        this.ensemble3.advanceDT(d);
        return d;
    }

    public void updateTimes(double d) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
            if (this.ensemble1.empty[n2]) continue;
            int n3 = n2;
            this.ensemble1.rwColTimes[n3] = this.ensemble1.rwColTimes[n3] - d;
            int n4 = n2;
            this.ensemble1.lwColTimes[n4] = this.ensemble1.lwColTimes[n4] - d;
            int n5 = n2;
            this.ensemble1.twColTimes[n5] = this.ensemble1.twColTimes[n5] - d;
            int n6 = n2;
            this.ensemble1.bwColTimes[n6] = this.ensemble1.bwColTimes[n6] - d;
        }
        if (this.partInt) {
            for (n2 = 1; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
                for (n = 0; n < n2; ++n) {
                    if (this.ensemble1.empty[n2] || this.ensemble1.empty[n]) continue;
                    double[] dArray = this.ensemble1.colTimes[n2];
                    int n7 = n;
                    dArray[n7] = dArray[n7] - d;
                }
            }
        }
        for (n2 = 0; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
            if (this.ensemble2.empty[n2]) continue;
            int n8 = n2;
            this.ensemble2.rwColTimes[n8] = this.ensemble2.rwColTimes[n8] - d;
            int n9 = n2;
            this.ensemble2.lwColTimes[n9] = this.ensemble2.lwColTimes[n9] - d;
            int n10 = n2;
            this.ensemble2.twColTimes[n10] = this.ensemble2.twColTimes[n10] - d;
            int n11 = n2;
            this.ensemble2.bwColTimes[n11] = this.ensemble2.bwColTimes[n11] - d;
        }
        if (this.partInt) {
            for (n2 = 1; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
                for (n = 0; n < n2; ++n) {
                    if (this.ensemble2.empty[n2] || this.ensemble2.empty[n]) continue;
                    double[] dArray = this.ensemble2.colTimes[n2];
                    int n12 = n;
                    dArray[n12] = dArray[n12] - d;
                }
            }
        }
        for (n2 = 0; n2 < this.ensemble3.lastpartnum + 1; ++n2) {
            if (this.ensemble3.empty[n2]) continue;
            int n13 = n2;
            this.ensemble3.rwColTimes[n13] = this.ensemble3.rwColTimes[n13] - d;
            int n14 = n2;
            this.ensemble3.lwColTimes[n14] = this.ensemble3.lwColTimes[n14] - d;
            int n15 = n2;
            this.ensemble3.twColTimes[n15] = this.ensemble3.twColTimes[n15] - d;
            int n16 = n2;
            this.ensemble3.bwColTimes[n16] = this.ensemble3.bwColTimes[n16] - d;
        }
        if (this.partInt) {
            for (n2 = 1; n2 < this.ensemble3.lastpartnum + 1; ++n2) {
                for (n = 0; n < n2; ++n) {
                    if (this.ensemble3.empty[n2] || this.ensemble3.empty[n]) continue;
                    double[] dArray = this.ensemble3.colTimes[n2];
                    int n17 = n;
                    dArray[n17] = dArray[n17] - d;
                }
            }
        }
    }

    public double findMinColTime() {
        this.ensemble1.findMinColTime();
        this.ensemble2.findMinColTime();
        this.ensemble3.findMinColTime();
        double d = this.ensemble1.mint;
        double d2 = this.ensemble2.mint;
        double d3 = this.ensemble3.mint;
        if (d <= d2 && d <= d3) {
            this.nCollidingE = 1;
            this.nCollidingW = this.ensemble1.nCollidingW;
            this.temptime = this.mint = d;
            return d;
        }
        if (d2 <= d && d2 <= d3) {
            this.nCollidingE = 2;
            this.nCollidingW = this.ensemble2.nCollidingW;
            this.temptime = this.mint = d2;
            return d2;
        }
        if (d3 <= d && d3 <= d2) {
            this.nCollidingE = 3;
            this.nCollidingW = this.ensemble3.nCollidingW;
            this.temptime = this.mint = d3;
            return d3;
        }
        System.out.println("DEnsemblePanel: findMinColTime");
        return 10000.0;
    }

    public void repaint() {
        this.paintOSI();
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.dispose();
    }

    public void paintOSI() {
        if (this.osi == null) {
            return;
        }
        Graphics graphics = this.osi.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.currentw, this.currenth);
        this.ensemble3.paintOSI();
        this.ensemble1.paintOSI();
        this.ensemble2.paintOSI();
        graphics.setColor(Color.black);
        if (this.showTitle) {
            this.paintCaption(graphics);
        }
        graphics.dispose();
    }

    public void setDefault() {
        this.wVel = 0.0;
        this.ensemble1.setDefault();
        this.ensemble2.setDefault();
        this.ensemble3.setDefault();
    }

    public void setPartInteractions(boolean bl) {
        if (this.owner.clock.isRunning()) {
            this.ensemble1.pause();
        }
        this.partInt = bl;
        this.osi = null;
        this.ensemble1.xPos = null;
        this.ensemble2.xPos = null;
        this.ensemble3.xPos = null;
        if (bl && this.ensemble1.maxp > 250) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Warning: Max Particles= ").append(this.ensemble1.maxp).append(" ").append("and PartInteractions=true uses a lot of memory!"))));
        }
    }

    public void setTubeWidth(int n) {
        if (n >= 5) {
            this.midHeight = n;
        }
        this.osi = null;
    }

    public void setTubeLength(int n) {
        if (n >= 5) {
            this.midLength = n;
        }
        this.osi = null;
    }

    public void setLeftWidth(int n, boolean bl) {
        if (n > 9 && n < 190) {
            this.lwidth = n;
        }
        this.lwSet = bl;
        if (bl) {
            this.osi = null;
        }
    }

    void setHeights(int n, double d, double d2) {
        this.top = d;
        this.bottom = d2;
        this.ensemble1.midHeight = n;
        this.ensemble2.midHeight = n;
        this.ensemble3.midHeight = n;
        this.ensemble1.top = d;
        this.ensemble2.top = d;
        this.ensemble3.top = d;
        this.ensemble1.bottom = d2;
        this.ensemble2.bottom = d2;
        this.ensemble3.bottom = d2;
        this.midHeight = n;
    }

    public void setBounds() {
        if (this.lwSet) {
            this.setBounds2();
            return;
        }
        this.currentw = this.getSize().width;
        this.currenth = this.getSize().height;
        double d = (double)this.currentw / (double)this.ppu;
        double d2 = (double)this.midLength / (double)this.ppu;
        d2 = Math.min(d2, 0.7 * d);
        d2 = Math.max(d2, 0.1 * d);
        this.lcwpos = ((double)this.currentw / (double)this.ppu - d2) / (double)2;
        this.ensemble1.setRWPos(this.lcwpos);
        this.ensemble1.setLWPos(0.0);
        this.ensemble1.setTWPos((double)this.currenth / (double)this.ppu);
        this.ensemble1.setBWPos(0.0);
        this.ensemble1.xOrigin = (this.lcwpos + this.ensemble1.lwpos) / (double)2;
        this.ensemble1.yOrigin = (this.ensemble1.twpos + this.ensemble1.bwpos) / (double)2;
        this.rcwpos = d2 + this.lcwpos;
        this.ensemble1.setPeriodicV(false);
        if (this.ensemble1.periodicv) {
            this.ensemble1.setNeighbor(1, this.ensemble1, 0.0, this.ensemble1.twpos);
            this.ensemble1.setNeighbor(5, this.ensemble1, 0.0, -this.ensemble1.twpos);
        }
        this.ensemble1.setPeriodicH(false);
        this.setHeights(this.midHeight, this.ensemble1.twpos, this.ensemble1.bwpos);
        double d3 = (double)this.midHeight / (double)this.ppu;
        d3 = Math.min(d3, 0.9 * (this.top - this.bottom));
        this.ensemble3.setLWPos(this.lcwpos);
        this.ensemble3.setRWPos(this.rcwpos);
        this.ensemble3.setTWPos((this.ensemble1.twpos + this.ensemble1.bwpos + d3) / (double)2);
        this.ensemble3.setBWPos(this.ensemble3.twpos - d3);
        this.ensemble3.xOrigin = (this.rcwpos + this.lcwpos) / (double)2;
        this.ensemble3.yOrigin = (this.ensemble3.twpos + this.ensemble3.bwpos) / (double)2;
        this.ensemble3.setPeriodicV(false);
        this.ensemble3.setPeriodicH(false);
        this.ensemble2.setLWPos(this.rcwpos);
        this.ensemble2.setRWPos((double)this.currentw / (double)this.ppu);
        this.ensemble2.setTWPos((double)this.currenth / (double)this.ppu);
        this.ensemble2.setBWPos(0.0);
        this.ensemble2.xOrigin = (this.ensemble2.rwpos + this.rcwpos) / (double)2;
        this.ensemble2.yOrigin = (this.ensemble2.twpos + this.ensemble2.bwpos) / (double)2;
        this.ensemble2.setPeriodicV(false);
        if (this.ensemble2.periodicv) {
            this.ensemble2.setNeighbor(1, this.ensemble2, 0.0, this.ensemble2.twpos);
            this.ensemble2.setNeighbor(5, this.ensemble2, 0.0, -this.ensemble2.twpos);
        }
        this.ensemble2.setPeriodicH(false);
        this.setHorizontalNeighbors();
        this.makeImage();
    }

    public void setBounds2() {
        this.currentw = this.getSize().width;
        this.currenth = this.getSize().height;
        double d = (double)this.lwidth / (double)this.ppu;
        double d2 = (double)this.currentw / (double)this.ppu;
        this.lcwpos = d > 0.049 * d2 && d < 0.8 * d2 ? d : d2 / (double)4;
        double d3 = (double)this.midLength / (double)this.ppu;
        d3 = Math.min(d3, 0.8 * (d2 - this.lcwpos));
        d3 = Math.max(d3, 0.1 * d2);
        this.ensemble1.setRWPos(this.lcwpos);
        this.ensemble1.setLWPos(0.0);
        this.ensemble1.setTWPos((double)this.currenth / (double)this.ppu);
        this.ensemble1.setBWPos(0.0);
        this.ensemble1.xOrigin = (this.lcwpos + this.ensemble1.lwpos) / (double)2;
        this.ensemble1.yOrigin = (this.ensemble1.twpos + this.ensemble1.bwpos) / (double)2;
        this.rcwpos = d3 + this.lcwpos;
        if (this.ensemble1.periodicv) {
            this.ensemble1.setNeighbor(1, this.ensemble1, 0.0, this.ensemble1.twpos);
            this.ensemble1.setNeighbor(5, this.ensemble1, 0.0, -this.ensemble1.twpos);
        }
        this.ensemble1.setPeriodicH(false);
        this.setHeights(this.midHeight, this.ensemble1.twpos, this.ensemble1.bwpos);
        double d4 = (double)this.midHeight / (double)this.ppu;
        d4 = Math.min(d4, 0.9 * (this.top - this.bottom));
        this.ensemble3.setLWPos(this.lcwpos);
        this.ensemble3.setRWPos(this.rcwpos);
        this.ensemble3.setTWPos((this.ensemble1.twpos + this.ensemble1.bwpos + d4) / (double)2);
        this.ensemble3.setBWPos(this.ensemble3.twpos - d4);
        this.ensemble3.xOrigin = (this.rcwpos + this.lcwpos) / (double)2;
        this.ensemble3.yOrigin = (this.ensemble3.twpos + this.ensemble3.bwpos) / (double)2;
        this.ensemble3.setPeriodicV(false);
        this.ensemble3.setPeriodicH(false);
        this.ensemble2.setLWPos(this.rcwpos);
        this.ensemble2.setRWPos((double)this.currentw / (double)this.ppu);
        this.ensemble2.setTWPos((double)this.currenth / (double)this.ppu);
        this.ensemble2.setBWPos(0.0);
        this.ensemble2.xOrigin = (this.ensemble2.rwpos + this.rcwpos) / (double)2;
        this.ensemble2.yOrigin = (this.ensemble2.twpos + this.ensemble2.bwpos) / (double)2;
        if (this.ensemble2.periodicv) {
            this.ensemble2.setNeighbor(1, this.ensemble2, 0.0, this.ensemble2.twpos);
            this.ensemble2.setNeighbor(5, this.ensemble2, 0.0, -this.ensemble2.twpos);
        }
        this.ensemble2.setPeriodicH(false);
        this.setHorizontalNeighbors();
        this.makeImage();
    }

    void setHorizontalNeighbors() {
        this.ensemble1.periodich = false;
        this.ensemble2.periodich = false;
        this.ensemble3.periodich = false;
        this.ensemble1.neighbor[0] = null;
        this.ensemble1.neighbor[6] = null;
        this.ensemble1.neighbor[7] = null;
        this.ensemble1.setNeighbor(3, this.ensemble3, 0.0, 0.0);
        this.ensemble3.setNeighbor(7, this.ensemble1, 0.0, 0.0);
        this.ensemble3.setNeighbor(3, this.ensemble2, 0.0, 0.0);
        this.ensemble2.setNeighbor(7, this.ensemble3, 0.0, 0.0);
    }

    public void setInflowLeft(double d) {
        this.iFLeft = d < 0.005 ? 100000.0 : 1.0 / d;
        this.iflCounter = this.iFLeft;
        this.iLRate = d;
    }

    public void setOFProbLeft(double d) {
        this.ensemble1.oLProb = d;
    }

    public void setOutflowLeft(double d) {
        this.oFLeft = d < 5.0E-4 ? 100000.0 : 1.0 / d;
        this.oflCounter = this.oFLeft;
        this.oLRate = d;
    }

    public void setInflowRight(double d) {
        this.iFRight = d < 5.0E-4 ? 100000.0 : 1.0 / d;
        this.ifrCounter = this.iFRight;
        this.iRRate = d;
    }

    public void setOFProbRight(double d) {
        this.ensemble2.oRProb = d;
    }

    public void setOutflowRight(double d) {
        this.oFRight = d < 5.0E-4 ? 100000.0 : 1.0 / d;
        this.ofrCounter = this.oFRight;
        this.oRRate = d;
    }

    public void setEnableFlow(boolean bl) {
        boolean bl2 = false;
        if (this.owner.clock.isRunning()) {
            this.ensemble1.pause();
            bl2 = true;
        }
        this.flows = bl;
        if (bl) {
            this.setOutflowRight(this.oRRate);
            this.setInflowRight(this.iRRate);
            this.setOutflowLeft(this.oLRate);
            this.setInflowLeft(this.iLRate);
        }
        if (bl2) {
            this.ensemble1.forward();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint(Graphics graphics) {
        if (this.osi == null || this.currentw != this.getSize().width || this.currenth != this.getSize().height) {
            if (this.getSize().width <= 2) return;
            boolean bl = this.owner.clock.isRunning();
            this.owner.clock.stopClock();
            this.setBounds();
            graphics.drawImage(this.osi, 0, 0, this.currentw, this.currenth, this);
            if (bl) {
                this.owner.clock.startClock();
            }
        } else {
            graphics.drawImage(this.osi, 0, 0, this.currentw, this.currenth, this);
        }
        if (this.ensemble1.mouseDown) {
            this.ensemble1.paintCoords(graphics);
        }
        if (this.ensemble2.mouseDown) {
            this.ensemble2.paintCoords(graphics);
        }
        if (!this.ensemble3.mouseDown) return;
        this.ensemble3.paintCoords(graphics);
    }

    public MFLEnsemble getEnsemble1() {
        return this.ensemble1;
    }

    public MFREnsemble getEnsemble2() {
        return this.ensemble2;
    }

    public MFEnsemble getEnsemble3() {
        return this.ensemble3;
    }

    public MFEnsemblePanel() {
    }

    public void recalculateColTimes() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
            if (this.ensemble1.empty[n2]) continue;
            n = n2;
            this.ensemble1.rwColTimes[n2] = this.ensemble1.calcColTimeRW(n2);
            this.ensemble1.lwColTimes[n2] = this.ensemble1.calcColTimeLW(n2);
            this.ensemble1.twColTimes[n2] = this.ensemble1.calcColTimeTW(n2);
            this.ensemble1.bwColTimes[n2] = this.ensemble1.calcColTimeBW(n2);
        }
        if (this.partInt) {
            for (n2 = 1; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
                for (n = 0; n < n2; ++n) {
                    if (this.ensemble1.empty[n] || this.ensemble1.empty[n2]) continue;
                    this.ensemble1.colTimes[n2][n] = this.ensemble1.calcColTime(n2, n);
                }
            }
        }
        for (n2 = 0; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
            if (this.ensemble2.empty[n2]) continue;
            n = n2;
            this.ensemble2.rwColTimes[n2] = this.ensemble2.calcColTimeRW(n2);
            this.ensemble2.lwColTimes[n2] = this.ensemble2.calcColTimeLW(n2);
            this.ensemble2.twColTimes[n2] = this.ensemble2.calcColTimeTW(n2);
            this.ensemble2.bwColTimes[n2] = this.ensemble2.calcColTimeBW(n2);
        }
        if (this.partInt) {
            for (n2 = 1; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
                for (n = 0; n < n2; ++n) {
                    if (this.ensemble2.empty[n] || this.ensemble2.empty[n2]) continue;
                    this.ensemble2.colTimes[n2][n] = this.ensemble2.calcColTime(n2, n);
                }
            }
        }
        for (n2 = 0; n2 < this.ensemble3.lastpartnum + 1; ++n2) {
            if (this.ensemble3.empty[n2]) continue;
            n = n2;
            this.ensemble3.rwColTimes[n2] = this.ensemble3.calcColTimeRW(n2);
            this.ensemble3.lwColTimes[n2] = this.ensemble3.calcColTimeLW(n2);
            this.ensemble3.twColTimes[n2] = this.ensemble3.calcColTimeTW(n2);
            this.ensemble3.bwColTimes[n2] = this.ensemble3.calcColTimeBW(n2);
        }
        if (this.partInt) {
            for (n2 = 1; n2 < this.ensemble3.lastpartnum + 1; ++n2) {
                for (n = 0; n < n2; ++n) {
                    if (this.ensemble3.empty[n] || this.ensemble3.empty[n2]) continue;
                    this.ensemble3.colTimes[n2][n] = this.ensemble3.calcColTime(n2, n);
                }
            }
        }
        this.findMinColTime();
    }
}

