/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import java.awt.Graphics;
import molecular.Ensemble;
import molecular.EnsemblePanel;
import molecular.MEnsemblePanel;

public class MLEnsemble
extends Ensemble {
    MEnsemblePanel towner = null;

    public MLEnsemble(EnsemblePanel ensemblePanel) {
        super(ensemblePanel);
        this.towner = (MEnsemblePanel)ensemblePanel;
    }

    public double calcColTimeRW(int n) {
        if (this.empty[n]) {
            System.out.println("calcColTimeRW empty particle:".concat(String.valueOf(String.valueOf(n))));
            return 10000.0;
        }
        if (this.xVel[n] > 0.0 && this.xPos[n] < this.rwpos) {
            return Math.abs((this.rwpos - this.xPos[n]) / this.xVel[n]);
        }
        return 10000.0;
    }

    public void findMinColTime() {
        double d = 10000.0;
        double d2 = 0.0;
        this.nCollidingW = 0;
        if (!this.empty[0]) {
            if (this.twColTimes[0] < d) {
                d = this.twColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 1;
            }
            if (this.rwColTimes[0] < d) {
                d = this.rwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 2;
            }
            if (this.bwColTimes[0] < d) {
                d = this.bwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 3;
            }
            if (this.lwColTimes[0] < d) {
                d = this.lwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 4;
            }
        }
        for (int i = 1; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            if (this.twColTimes[i] < d) {
                d = this.twColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 1;
                if (d <= 0.0) {
                    System.out.println("twColTime <= 0: Left");
                    this.pause();
                }
            }
            if (this.rwColTimes[i] < d) {
                d = this.rwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 2;
                if (d <= 0.0) {
                    System.out.println("rwColTime <= 0: Left");
                    this.pause();
                }
            }
            if (this.bwColTimes[i] < d) {
                d = this.bwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 3;
                if (d <= 0.0) {
                    System.out.println("bwColTime <= 0: Left");
                    this.pause();
                }
            }
            if (this.lwColTimes[i] < d) {
                d = this.lwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 4;
                if (d <= 0.0) {
                    System.out.println("lwColTime <= 0: Left");
                    this.pause();
                }
            }
            for (int j = 0; j < i; ++j) {
                if (!(this.colTimes[i][j] < d)) continue;
                d = this.colTimes[i][j];
                this.nCollidingW = 0;
                this.nColliding1 = i;
                this.nColliding2 = j;
                if (!(d <= 0.0)) continue;
                System.out.println("PartColTime <= 0: Left");
                this.pause();
            }
        }
        if (d < 0.0) {
            System.out.println("negative Collide Time: Left");
            this.pause();
            d = 10000.0;
        }
        if (d == 0.0) {
            System.out.println("Collide Time = 0: Left");
            this.pause();
            d = 10000.0;
        }
        this.temptime = this.mint = d;
    }

    public void collideRW(int n) {
        if (this.empty[n]) {
            return;
        }
        double d = 0.0;
        this.pr += Math.abs((double)2 * this.xVel[n] * this.mass[n] / (this.twpos - this.bwpos));
        double d2 = Math.sqrt(this.xVel[n] * this.xVel[n] + this.yVel[n] * this.yVel[n]);
        d = this.towner.pparser.evaluate(this.mass[n], d2, this.applet.clock.getTime());
        if (d > Math.random()) {
            double d3 = this.yPos[n] - this.towner.ensemble2.yOrigin;
            double d4 = this.xVel[n];
            double d5 = this.yVel[n];
            double d6 = this.rad[n];
            double d7 = this.towner.ensemble2.xOrigin;
            double d8 = this.towner.ensemble2.lwpos - d7 + 1.0E-4;
            this.towner.ensemble2.setDefaultColor(this.colors[n].getRed(), this.colors[n].getGreen(), this.colors[n].getBlue());
            this.towner.ensemble2.setDefaultMass(this.mass[n]);
            int n2 = this.towner.ensemble2.addParticle(d8, d3, d4, d5, d6);
            this.removeParticle(n);
            this.towner.swapDataSourcesLR(n, n2);
        } else {
            int n3;
            this.xVel[n] = -this.xVel[n];
            this.bwColTimes[n] = this.calcColTimeBW(n);
            this.lwColTimes[n] = this.calcColTimeLW(n);
            this.rwColTimes[n] = this.calcColTimeRW(n);
            this.twColTimes[n] = this.calcColTimeTW(n);
            for (n3 = 0; n3 < n; ++n3) {
                this.colTimes[n][n3] = this.calcColTime(n, n3);
            }
            for (n3 = n + 1; n3 < this.lastpartnum + 1; ++n3) {
                this.colTimes[n3][n] = this.calcColTime(n3, n);
            }
        }
    }

    public void setBounds() {
        this.towner.setBounds();
    }

    public synchronized void paintOSI() {
        int n = (int)((this.rwpos - this.lwpos) * (double)this.ppu);
        int n2 = (int)((this.twpos - this.bwpos) * (double)this.ppu);
        if (this.towner.osi != null) {
            Graphics graphics = this.towner.osi.getGraphics();
            if (graphics == null) {
                return;
            }
            for (int i = 0; i < this.lastpartnum + 1; ++i) {
                if (this.empty[i]) continue;
                graphics.setColor(this.colors[i]);
                double d = this.rad[i];
                int n3 = Math.max(2, (int)((double)2 * d * (double)this.ppu));
                graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n2 - (int)((double)this.ppu * (this.yPos[i] + d)), n3, n3);
                if (this.yPos[i] + d > this.twpos) {
                    graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n2 - (int)((double)this.ppu * (this.yPos[i] + d - this.twpos)), n3, n3);
                }
                if (!(this.yPos[i] - d < this.bwpos)) continue;
                graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n2 - (int)((double)this.ppu * (this.yPos[i] + d + this.twpos)), n3, n3);
            }
            graphics.dispose();
        }
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (bl) {
            boolean bl2 = false;
            if (this.applet.clock.isRunning()) {
                bl2 = true;
                this.pause();
            }
            this.recalculateColTimes();
            this.paintOSI();
            this.owner.repaint();
            if (bl2) {
                this.forward();
            }
        }
    }

    public void recalculateColTimes() {
        this.towner.recalculateColTimes();
    }
}

