/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import edu.davidson.display.SInteger;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import molecular.MFEnsemble;
import molecular.MFEnsemblePanel;
import molecular.MFLEnsemble;
import molecular.MFREnsemble;

public class MolecularFlow
extends SApplet {
    String button_reset = "Reset";
    String button_start = "Start";
    String button_stop = "Pause";
    String button_forward = "Step";
    String label_newparticles = "New Particles:";
    boolean sc;
    boolean perh;
    boolean partInt;
    boolean per;
    boolean perv;
    int inp;
    int maxp;
    int fps;
    int ppu;
    int mode;
    String parseString = null;
    boolean bill = false;
    double dt = 0.1;
    double pm = 100.0;
    MFLEnsemble ensemble1 = null;
    MFREnsemble ensemble2 = null;
    MFEnsemble ensemble3 = null;
    MFEnsemblePanel ensemblePanel = new MFEnsemblePanel(this);
    EtchedBorder controlPanel = new EtchedBorder();
    EtchedBorder etchedBorder3 = new EtchedBorder();
    Button startbtn = new Button();
    Button resetbtn = new Button();
    Button stepbtn = new Button();
    Panel panel1 = new Panel();
    Label label1 = new Label();
    SInteger partfield = new SInteger();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();

    protected void setResources() {
        this.button_start = this.localProperties.getProperty("button.start", this.button_start);
        this.button_stop = this.localProperties.getProperty("button.stop", this.button_stop);
        this.button_reset = this.localProperties.getProperty("button.reset", this.button_reset);
        this.button_forward = this.localProperties.getProperty("button.forward", this.button_forward);
        this.label_newparticles = this.localProperties.getProperty("label.newparticles", this.label_newparticles);
    }

    public void init() {
        this.initResources(null);
        this.ensemble1 = this.ensemblePanel.getEnsemble1();
        this.ensemble2 = this.ensemblePanel.getEnsemble2();
        this.ensemble3 = this.ensemblePanel.getEnsemble3();
        try {
            this.sc = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.inp = Integer.parseInt(this.getParameter("InitialP", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fps = Integer.parseInt(this.getParameter("FPS", "50"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ppu = Integer.parseInt(this.getParameter("PixPer", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dt = Double.valueOf(this.getParameter("dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.perv = Boolean.valueOf(this.getParameter("PeriodicV", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.partInt = Boolean.valueOf(this.getParameter("PartInt", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.maxp = Integer.parseInt(this.getParameter("MaxParticles", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.parseString = String.valueOf(this.getParameter("Probability", "0.05"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clock.addClockListener((SStepable)this.ensemblePanel);
        this.setMaxParticles(this.maxp);
        this.setPartInteractions(this.partInt);
        this.setFPS(this.fps);
        this.setDt(this.dt);
        this.setPpu(this.ppu);
        this.setShowControls(this.sc);
        this.setPeriodicV(false);
        this.setDefaultSize(1.0);
        this.setRunningID();
        this.setBackgroundRGBR(190, 190, 190);
        this.setBackgroundRGBL(190, 190, 190);
        this.setBackgroundRGBM(190, 190, 190);
        ((Component)((Object)this)).setBackground(Color.gray);
        this.partfield.setValue(this.inp);
        this.ensemblePanel.ensemble1.setEnableMouse(true);
        this.ensemblePanel.ensemble2.setEnableMouse(true);
        this.ensemblePanel.ensemble3.setEnableMouse(true);
    }

    private void jbInit() throws Exception {
        this.startbtn.setLabel(this.button_start);
        this.startbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MolecularFlow.this.startbtn_actionPerformed(actionEvent);
            }
        });
        this.resetbtn.setLabel(this.button_reset);
        this.stepbtn.setLabel(this.button_forward);
        this.resetbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MolecularFlow.this.resetbtn_actionPerformed(actionEvent);
            }
        });
        this.panel1.setLayout(this.borderLayout1);
        this.label1.setAlignment(1);
        this.label1.setText(this.label_newparticles);
        this.partfield.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                MolecularFlow.this.partfield_textValueChanged(textEvent);
            }
        });
        ((Component)((Object)this)).setSize(new Dimension(392, 256));
        this.ensemblePanel.setLayout(this.borderLayout4);
        this.stepbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MolecularFlow.this.stepbtn_actionPerformed(actionEvent);
            }
        });
        this.etchedBorder3.setLayout(this.gridLayout1);
        this.controlPanel.setLayout(this.borderLayout2);
        ((Container)((Object)this)).setLayout(this.borderLayout3);
        ((Container)((Object)this)).add(this.ensemblePanel, "Center");
        ((Container)((Object)this)).add((Component)this.controlPanel, "South");
        this.controlPanel.add((Component)this.etchedBorder3, "Center");
        this.etchedBorder3.add((Component)this.startbtn, null);
        this.etchedBorder3.add((Component)this.resetbtn, null);
        this.etchedBorder3.add((Component)this.stepbtn, null);
        this.controlPanel.add((Component)this.panel1, "West");
        this.panel1.add((Component)this.label1, "Center");
        this.panel1.add((Component)this.partfield, "East");
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"ShowControls", "boolean", ""}, {"InitialP", "int", "number of particles"}, {"Mode", "String", ""}, {"Frames", "double", "frames per second"}, {"PixPer", "int", "pixels per unit"}, {"Delta", "double", "time step"}};
        return stringArray;
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        this.ensemblePanel.osi = null;
        if (this.firstTime) {
            this.firstTime = false;
        }
        ((Component)((Object)this)).repaint();
        super.start();
    }

    public void setTempL(double d) {
        this.ensemble1.setTemp(d);
    }

    public void setTemperatureL(double d, int n) {
        this.ensemble1.setTemperature(d, n);
    }

    public void setTempR(double d) {
        this.ensemble2.setTemp(d);
    }

    public void setTemperatureR(double d, int n) {
        this.ensemble2.setTemperature(d, n);
    }

    public void setShowControls(boolean bl) {
        this.controlPanel.setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void setMessage(String string) {
        this.ensemble2.setMessage(string);
    }

    public void setDisplayOffset(int n, int n2) {
        if (n >= 0) {
            this.ensemblePanel.txtxoff = n;
        }
        if (n2 >= 0) {
            this.ensemblePanel.txtyoff = n2;
        }
    }

    public void setRGB(int n, int n2, int n3) {
        this.ensemblePanel.txtcolor = new Color(n, n2, n3);
    }

    public void addCaption(String string) {
        this.ensemblePanel.addCaption(string);
    }

    void startbtn_actionPerformed(ActionEvent actionEvent) {
        if (!this.clock.isRunning()) {
            this.setDefault();
            this.setPartInteractions(true);
            this.setAutoRefresh(false);
            this.setTubeWidth(15);
            this.setTubeLength(150);
            this.setLeftWidth(60, false);
            this.setInflowLeft(2.0);
            this.setOFProbRight(1.0);
            this.setEnableFlow(true);
            this.setDefaultMass(1.0);
            this.setDefaultSize(0.2);
            this.setDefaultColorL(150, 0, 0);
            this.createParticlesL(5);
            this.setDefaultColorR(0, 150, 0);
            this.createParticlesR(5);
            this.setAutoRefresh(true);
            this.forward();
        } else {
            this.pause();
        }
    }

    public void setDefault() {
        this.clock.stopClock();
        this.ensemblePanel.setDefault();
        this.setPartInteractions(this.partInt);
        this.setDefaultMass(1.0);
        this.setDefaultSize(0.5);
        this.setDefaultColorL(50, 0, 170);
        this.setDefaultColorR(50, 0, 170);
        this.setTubeWidth(20);
        this.setTubeLength(70);
        this.setLeftWidth(100, false);
        this.ensemble2.showMessage = false;
        this.ensemblePanel.showTitle = false;
    }

    public void setPartInteractions(boolean bl) {
        this.ensemblePanel.setPartInteractions(bl);
    }

    public void setTubeWidth(int n) {
        this.ensemblePanel.setTubeWidth(n);
    }

    public void setTubeLength(int n) {
        this.ensemblePanel.setTubeLength(n);
    }

    public void setLeftWidth(int n, boolean bl) {
        this.ensemblePanel.setLeftWidth(n, bl);
    }

    public void setEnableFlow(boolean bl) {
        this.ensemblePanel.setEnableFlow(bl);
    }

    public void setInflowLeft(double d) {
        this.ensemblePanel.setInflowLeft(d);
    }

    public void setInflowRight(double d) {
        this.ensemblePanel.setInflowRight(d);
    }

    public void setOutflowRight(double d) {
        this.ensemblePanel.setOutflowRight(d);
    }

    public void setOutflowLeft(double d) {
        this.ensemblePanel.setOutflowLeft(d);
    }

    public void setOFProbLeft(double d) {
        this.ensemblePanel.setOFProbLeft(d);
    }

    public void setOFProbRight(double d) {
        this.ensemblePanel.setOFProbRight(d);
    }

    public void pause() {
        this.clock.stopClock();
        this.startbtn.setLabel(this.button_start);
    }

    public void forward() {
        this.setRunningID();
        this.startbtn.setLabel(this.button_stop);
        if (this.clock.isRunning()) {
            this.pause();
        }
        this.clock.startClock();
    }

    void partfield_textValueChanged(TextEvent textEvent) {
        this.pause();
        this.inp = this.partfield.getValue();
    }

    void resetbtn_actionPerformed(ActionEvent actionEvent) {
        this.ensemblePanel.setDefault();
    }

    void stepbtn_actionPerformed(ActionEvent actionEvent) {
        this.stepForward();
    }

    public void stepForward() {
        this.clock.doStep();
    }

    public int addParticleL(double d, double d2, double d3, double d4, double d5) {
        return this.ensemble1.addParticle(d, d2, d3, d4, d5);
    }

    public int addParticleR(double d, double d2, double d3, double d4, double d5) {
        return this.ensemble2.addParticle(d, d2, d3, d4, d5);
    }

    public int addParticleM(double d, double d2, double d3, double d4, double d5) {
        return this.ensemble3.addParticle(d, d2, d3, d4, d5);
    }

    public void createParticlesL(int n) {
        boolean bl = false;
        if (this.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        this.ensemble1.createParticles(n);
        if (bl) {
            bl = false;
            this.forward();
        }
    }

    public void createParticlesR(int n) {
        boolean bl = false;
        if (this.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        this.ensemble2.createParticles(n);
        if (bl) {
            bl = false;
            this.forward();
        }
    }

    public void createParticlesM(int n) {
        boolean bl = false;
        if (this.clock.isRunning()) {
            bl = true;
            this.pause();
        }
        this.ensemble3.createParticles(n);
        if (bl) {
            bl = false;
            this.forward();
        }
    }

    public void removeParticle(int n) {
        this.ensemble1.removeParticle(n);
    }

    public void setParticlesL(int n) {
        this.ensemble1.setParticles(n);
    }

    public void setParticlesR(int n) {
        this.ensemble2.setParticles(n);
    }

    public void setParticlesM(int n) {
        this.ensemble3.setParticles(n);
    }

    public void setMaxParticles(int n) {
        this.ensemble3.setMaxParticles(n);
        this.ensemble1.setMaxParticles(n);
        this.ensemble2.setMaxParticles(n);
    }

    public void setBackgroundRGBL(int n, int n2, int n3) {
        this.ensemble1.setBackgroundRGB(n, n2, n3);
    }

    public void setBackgroundRGBM(int n, int n2, int n3) {
        this.ensemble3.setBackgroundRGB(n, n2, n3);
    }

    public void setBackgroundRGBR(int n, int n2, int n3) {
        this.ensemble2.setBackgroundRGB(n, n2, n3);
    }

    public void setDefaultMass(double d) {
        this.ensemble3.setDefaultMass(d);
        this.ensemble1.setDefaultMass(d);
        this.ensemble2.setDefaultMass(d);
    }

    public void setDefaultSize(double d) {
        this.ensemble3.setDefaultSize(d);
        this.ensemble1.setDefaultSize(d);
        this.ensemble2.setDefaultSize(d);
    }

    public void setDefaultColorL(int n, int n2, int n3) {
        this.ensemble3.setDefaultColor(n, n2, n3);
        this.ensemble1.setDefaultColor(n, n2, n3);
    }

    public void setDefaultColorR(int n, int n2, int n3) {
        this.ensemble2.setDefaultColor(n, n2, n3);
    }

    public void setDefaultTemp(double d) {
        this.ensemble3.setDefaultTemp(d);
        this.ensemble1.setDefaultTemp(d);
        this.ensemble2.setDefaultTemp(d);
    }

    public void setParticleRGBR(int n, int n2, int n3, int n4) {
        this.ensemble2.setParticleRGB(n, n2, n3, n4);
    }

    public void setParticleRGBL(int n, int n2, int n3, int n4) {
        this.ensemble1.setParticleRGB(n, n2, n3, n4);
    }

    public void setParticleMassL(int n, double d) {
        this.ensemble1.setParticleMass(n, d);
    }

    public void setParticleMassR(int n, double d) {
        this.ensemble2.setParticleMass(n, d);
    }

    public void setParticleMassM(int n, double d) {
        this.ensemble3.setParticleMass(n, d);
    }

    public void setParticlePosL(int n, double d, double d2) {
        this.ensemble1.setParticlePos(n, d, d2);
    }

    public void setParticlePosR(int n, double d, double d2) {
        this.ensemble2.setParticlePos(n, d, d2);
    }

    public void setParticleVelL(int n, double d, double d2) {
        this.ensemble1.setParticleVel(n, d, d2);
    }

    public void setParticleVelR(int n, double d, double d2) {
        this.ensemble2.setParticleVel(n, d, d2);
    }

    public void setParticleSizeL(int n, double d) {
        this.ensemble1.setParticleSize(n, d);
    }

    public void setParticleSizeR(int n, double d) {
        this.ensemble2.setParticleSize(n, d);
    }

    public int addParticleDataSourceL(int n) {
        return this.ensemble1.addParticleDataSource(n);
    }

    public int addParticleDataSourceR(int n) {
        return this.ensemble2.addParticleDataSource(n);
    }

    public int addParticleDataSourceM(int n) {
        return this.ensemble3.addParticleDataSource(n);
    }

    public void setFPS(int n) {
        this.clock.setFPS((double)n);
    }

    public void setAutoRefresh(boolean bl) {
        this.ensemble1.setAutoRefresh(bl);
        this.ensemble2.setAutoRefresh(bl);
    }

    public void setDt(double d) {
        this.clock.setTimeStep(d);
    }

    public void setBoltzmann(double d) {
        this.ensemble1.setBoltzmann(d);
        this.ensemble2.setBoltzmann(d);
    }

    public void setWallTempR(String string, double d) {
        string.toLowerCase();
        string.trim();
        if (string.equals("top") || string.equals("north")) {
            this.ensemble2.setWallTemp(0, d);
        } else if (string.equals("right") || string.equals("east")) {
            this.ensemble2.setWallTemp(1, d);
        } else if (string.equals("bottom") || string.equals("south")) {
            this.ensemble2.setWallTemp(2, d);
        }
    }

    public void setWallTempL(String string, double d) {
        string.toLowerCase();
        string.trim();
        if (string.equals("top") || string.equals("north")) {
            this.ensemble1.setWallTemp(0, d);
        } else if (string.equals("bottom") || string.equals("south")) {
            this.ensemble1.setWallTemp(2, d);
        } else if (string.equals("left") || string.equals("west")) {
            this.ensemble1.setWallTemp(3, d);
        }
    }

    public void removeWallTempL(String string) {
        if (string.equals("top") || string.equals("north")) {
            this.ensemble1.removeWallTemp(0);
        } else if (string.equals("right") || string.equals("east")) {
            this.ensemble1.removeWallTemp(1);
        } else if (string.equals("bottom") || string.equals("south")) {
            this.ensemble1.removeWallTemp(2);
        } else if (string.equals("left") || string.equals("west")) {
            this.ensemble1.removeWallTemp(3);
        }
    }

    public void removeWallTempR(String string) {
        if (string.equals("top") || string.equals("north")) {
            this.ensemble2.removeWallTemp(0);
        } else if (string.equals("right") || string.equals("east")) {
            this.ensemble2.removeWallTemp(1);
        } else if (string.equals("bottom") || string.equals("south")) {
            this.ensemble2.removeWallTemp(2);
        } else if (string.equals("left") || string.equals("west")) {
            this.ensemble2.removeWallTemp(3);
        }
    }

    public void setPpu(int n) {
        this.ensemble1.setPpu(this.ppu);
        this.ensemble2.setPpu(this.ppu);
        this.ensemblePanel.ppu = n;
    }

    public void setPeriodicV(boolean bl) {
        this.pause();
        this.ensemble1.setPeriodicV(bl);
        this.ensemble2.setPeriodicV(bl);
    }

    public double getRWPos() {
        return this.ensemble2.getRWPos();
    }

    public double getLWPos() {
        return this.ensemble1.getLWPos();
    }

    public double getTWPos() {
        return this.ensemble1.getTWPos();
    }

    public double getBWPos() {
        return this.ensemble1.getBWPos();
    }

    public int getEnsembleLeftID() {
        return this.ensemble1.hashCode();
    }

    public int getEnsembleRightID() {
        return this.ensemble2.hashCode();
    }

    public int getEnsembleMiddleID() {
        return this.ensemble3.hashCode();
    }

    public int getHistogramLeftID(int n, double d, double d2) {
        return this.ensemble1.setHistogram(n, d, d2);
    }

    public int getHistogramRightID(int n, double d, double d2) {
        return this.ensemble2.setHistogram(n, d, d2);
    }

    public int getHistogramMiddleID(int n, double d, double d2) {
        return this.ensemble3.setHistogram(n, d, d2);
    }
}

