/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import edu.davidson.display.SInteger;
import edu.davidson.display.SNumber;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import molecular.PEnsemblePanel;
import molecular.PistonEnsemble;

public class MolecularPiston
extends SApplet {
    String button_reset = "Reset";
    String button_start = "Start";
    String button_stop = "Pause";
    String button_forward = "Step";
    String label_newparticles = "New Particles:";
    String orientation = "vertical";
    boolean sc;
    boolean perh;
    boolean perv;
    boolean dragable;
    double pm;
    double h;
    double g;
    int inp;
    int maxp;
    int fps;
    int ppu;
    int del;
    int bwidth;
    int pwidth;
    String parseString = null;
    boolean parsemode = true;
    double dt = 0.1;
    int mode;
    boolean bill = false;
    PistonEnsemble ensemble1 = null;
    PEnsemblePanel ensemblePanel = new PEnsemblePanel(this);
    EtchedBorder controlPanel = new EtchedBorder();
    EtchedBorder etchedBorder3 = new EtchedBorder();
    Button startbtn = new Button();
    Button resetbtn = new Button();
    Button stepbtn = new Button();
    Panel panel1 = new Panel();
    Label label1 = new Label();
    SInteger partfield = new SInteger();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    SNumber parsefield = new SNumber();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();

    protected void setResources() {
        this.button_start = this.localProperties.getProperty("button.start", this.button_start);
        this.button_stop = this.localProperties.getProperty("button.stop", this.button_stop);
        this.button_reset = this.localProperties.getProperty("button.reset", this.button_reset);
        this.button_forward = this.localProperties.getProperty("button.forward", this.button_forward);
        this.label_newparticles = this.localProperties.getProperty("label.newparticles", this.label_newparticles);
    }

    public void init() {
        this.initResources(null);
        this.ensemble1 = this.ensemblePanel.getPEnsemble();
        try {
            this.sc = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.inp = Integer.parseInt(this.getParameter("InitialP", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fps = Integer.parseInt(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ppu = Integer.parseInt(this.getParameter("PixPerUnit", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dt = Double.valueOf(this.getParameter("dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.pm = Double.valueOf(this.getParameter("PistonMass", "20"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.g = Double.valueOf(this.getParameter("Gravity", "-1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.h = Double.valueOf(this.getParameter("InitialPistonPos", "30"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.maxp = Integer.parseInt(this.getParameter("MaxParticles", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.parseString = String.valueOf(this.getParameter("ParseString", "10+5*sin(t)"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.orientation = String.valueOf(this.getParameter("Orientation", "vertical"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.parsemode = Boolean.valueOf(this.getParameter("ParseMode", "False"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dragable = Boolean.valueOf(this.getParameter("Dragable", "False"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.pwidth = Integer.parseInt(this.getParameter("PistonWidth", "5"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setOrientation(this.orientation);
        this.clock.addClockListener((SStepable)this.ensemble1);
        this.setInitialPistonPos(10.0);
        this.setPistonWidth(this.pwidth);
        this.setMaxParticles(this.maxp);
        this.setDragable(this.dragable);
        this.setFPS(this.fps);
        this.setDt(this.dt);
        this.setPpu(this.ppu);
        this.setShowControls(this.sc);
        this.setPeriodicH(this.perh);
        this.setPeriodicV(this.perv);
        this.setGravity(this.g);
        this.setPiston(this.parseString, this.parsemode);
        this.setDefaultSize(1.0);
        this.setRunningID();
        this.setBackgroundRGB(150, 150, 150);
        ((Component)((Object)this)).setBackground(Color.gray);
        this.setPistonMass(this.pm);
        this.partfield.setValue(this.inp);
        this.ensemblePanel.ensemble1.setEnableMouse(true);
    }

    private void jbInit() throws Exception {
        this.startbtn.setLabel(this.button_start);
        this.startbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MolecularPiston.this.startbtn_actionPerformed(actionEvent);
            }
        });
        this.resetbtn.setLabel(this.button_reset);
        this.stepbtn.setLabel(this.button_forward);
        this.resetbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MolecularPiston.this.resetbtn_actionPerformed(actionEvent);
            }
        });
        this.panel1.setLayout(this.borderLayout1);
        this.label1.setAlignment(1);
        this.label1.setText(this.label_newparticles);
        this.parsefield.setText("");
        this.parsefield.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                MolecularPiston.this.parsefield_textValueChanged(textEvent);
            }
        });
        this.partfield.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                MolecularPiston.this.partfield_textValueChanged(textEvent);
            }
        });
        ((Component)((Object)this)).setSize(new Dimension(300, 300));
        this.ensemblePanel.setLayout(this.borderLayout4);
        this.stepbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MolecularPiston.this.stepbtn_actionPerformed(actionEvent);
            }
        });
        this.etchedBorder3.setLayout(this.gridLayout1);
        this.controlPanel.setLayout(this.borderLayout2);
        ((Container)((Object)this)).setLayout(this.borderLayout3);
        ((Container)((Object)this)).add(this.ensemblePanel, "Center");
        ((Container)((Object)this)).add((Component)this.controlPanel, "South");
        this.controlPanel.add((Component)this.etchedBorder3, "Center");
        this.etchedBorder3.add((Component)this.startbtn, null);
        this.etchedBorder3.add((Component)this.resetbtn, null);
        this.etchedBorder3.add((Component)this.stepbtn, null);
        this.etchedBorder3.add((Component)this.parsefield, null);
        this.controlPanel.add((Component)this.panel1, "West");
        this.panel1.add((Component)this.label1, "Center");
        this.panel1.add((Component)this.partfield, "East");
    }

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        this.ensemblePanel.osi = null;
        if (this.firstTime) {
            this.firstTime = false;
            this.ensemble1.reset();
            if (this.sc) {
                this.createParticles(this.inp);
                this.forward();
            }
        }
        ((Component)((Object)this)).repaint();
        super.start();
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"ShowControls", "boolean", ""}, {"InitialP", "int", "number of particles"}, {"Mode", "String", ""}, {"Frames", "double", "frames per second"}, {"PixPer", "int", "pixels per unit"}, {"Delta", "double", "time step"}, {"Periodic", "boolean", "periodic boundaries"}, {"PistonMass", "double", "mass of piston"}, {"Gravity", "double", "gravitational constant"}};
        return stringArray;
    }

    public void setShowControls(boolean bl) {
        this.pause();
        this.controlPanel.setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    void startbtn_actionPerformed(ActionEvent actionEvent) {
        if (!this.clock.isRunning()) {
            this.createParticles(this.inp);
            this.forward();
        } else {
            this.pause();
        }
    }

    public void pause() {
        this.clock.stopClock();
        this.startbtn.setLabel(this.button_start);
    }

    public void forward() {
        this.setRunningID();
        this.startbtn.setLabel(this.button_stop);
        this.clock.startClock();
    }

    void partfield_textValueChanged(TextEvent textEvent) {
        this.pause();
        this.inp = this.partfield.getValue();
    }

    void resetbtn_actionPerformed(ActionEvent actionEvent) {
        this.ensemble1.reset();
    }

    void stepbtn_actionPerformed(ActionEvent actionEvent) {
        this.setConstrainIsothermal(true);
    }

    public void stepForward() {
        this.clock.doStep();
    }

    public int addParticle(double d, double d2, double d3, double d4, double d5) {
        return this.ensemble1.addParticle(d, d2, d3, d4, d5);
    }

    public void createParticles(int n) {
        this.pause();
        this.ensemble1.createParticles(n);
    }

    public int addParticleDataSource(int n) {
        return this.ensemble1.addParticleDataSource(n);
    }

    public void setParticleRGB(int n, int n2, int n3, int n4) {
        this.ensemble1.setParticleRGB(n, n2, n3, n4);
    }

    public void setParticleMass(int n, double d) {
        this.ensemble1.setParticleMass(n, d);
    }

    public void setDefault() {
        this.clock.stopClock();
        this.ensemble1.reset();
        this.setDefaultMass(1.0);
        this.setDefaultSize(1.0);
        this.setDefaultColor(50, 0, 170);
        this.setMinPistonHeight(5.0);
        this.ensemble1.showMessage = false;
        this.ensemblePanel.showTitle = false;
    }

    public void setMaxParticles(int n) {
        this.ensemble1.setMaxParticles(n);
    }

    public void setAutoRefresh(boolean bl) {
        this.ensemble1.setAutoRefresh(bl);
    }

    public void setBorderWidth(int n) {
        this.ensemble1.setBorderWidth(n);
    }

    public void setBackgroundRGB(int n, int n2, int n3) {
        this.ensemble1.setBackgroundRGB(n, n2, n3);
    }

    public void setBG2Color(int n, int n2, int n3) {
        this.setBG2Color(n, n2, n3);
    }

    public void setDefaultMass(double d) {
        this.ensemble1.setDefaultMass(d);
    }

    public void setDefaultSize(double d) {
        this.ensemble1.setDefaultSize(d);
    }

    public void setDefaultColor(int n, int n2, int n3) {
        this.ensemble1.setDefaultColor(n, n2, n3);
    }

    public void setDefaultPiston() {
        this.ensemble1.setDefaultPiston();
    }

    public void setDefaultTemp(double d) {
        this.ensemble1.setDefaultTemp(d);
    }

    public void setParticlePos(int n, double d, double d2) {
        this.ensemble1.setParticlePos(n, d, d2);
    }

    public void setParticleVel(int n, double d, double d2) {
        this.ensemble1.setParticleVel(n, d, d2);
    }

    public void setInitialPistonPos(double d) {
        this.ensemble1.setInitialPistonPos(d);
    }

    public void setBoltzmann(double d) {
        this.ensemble1.setBoltzmann(d);
    }

    public void setWallTemp(String string, double d) {
        string.toLowerCase();
        string.trim();
        if (string.equals("top") || string.equals("north")) {
            this.ensemble1.setWallTemp(0, d);
        } else if (string.equals("right") || string.equals("east")) {
            this.ensemble1.setWallTemp(1, d);
        } else if (string.equals("bottom") || string.equals("south")) {
            this.ensemble1.setWallTemp(2, d);
        } else if (string.equals("left") || string.equals("west")) {
            this.ensemble1.setWallTemp(3, d);
        }
    }

    public void removeWallTemp(String string) {
        string.toLowerCase();
        string.trim();
        if (string.equals("top") || string.equals("north")) {
            this.ensemble1.removeWallTemp(0);
        } else if (string.equals("right") || string.equals("east")) {
            this.ensemble1.removeWallTemp(1);
        } else if (string.equals("bottom") || string.equals("south")) {
            this.ensemble1.removeWallTemp(2);
        } else if (string.equals("left") || string.equals("west")) {
            this.ensemble1.removeWallTemp(3);
        }
    }

    public void setFPS(int n) {
        this.clock.setFPS((double)n);
    }

    public void setDt(double d) {
        this.clock.setDt(d);
    }

    public void setDelay(int n) {
        n = Math.max(n, 10);
        this.clock.setFPS(1000.0 / (double)n);
    }

    public void removeParticle(int n) {
        this.ensemble1.removeParticle(n);
    }

    public void setParticles(int n) {
        this.ensemble1.setParticles(n);
    }

    public void setTemp(double d) {
        this.ensemble1.setTemp(d);
    }

    public void setTemperature(double d, int n) {
        this.ensemble1.setTemperature(d, n);
    }

    public void setPpu(int n) {
        this.ensemble1.setPpu(this.ppu);
    }

    public void setPeriodicH(boolean bl) {
        this.ensemble1.setPeriodicH(bl);
    }

    public void setPeriodicV(boolean bl) {
        this.ensemble1.setPeriodicV(bl);
    }

    public void setKE(double d) {
        this.parsefield.setValue(d);
    }

    public void setOrientation(String string) {
        this.pause();
        string.toLowerCase().trim();
        this.orientation = string;
        this.ensemble1.setOrientation(string);
    }

    public void setVolume(double d, int n) {
        this.ensemble1.setVolume(d, n, false);
    }

    public void setVolumeIsothermal(double d, int n) {
        double d2 = this.ensemble1.getTemp();
        this.ensemble1.setVolume(d, n, true);
        this.ensemble1.setTemp(d2);
    }

    public void setConstrainIsothermal(boolean bl) {
        this.ensemble1.setConstrainIsothermal(bl);
    }

    public void setMessage(String string) {
        this.ensemble1.setMessage(string);
    }

    public void setDisplayOffset(int n, int n2) {
        if (n >= 0) {
            this.ensemblePanel.txtxoff = n;
        }
        if (n2 >= 0) {
            this.ensemblePanel.txtyoff = n2;
        }
    }

    public void setRGB(int n, int n2, int n3) {
        this.ensemblePanel.txtcolor = new Color(n, n2, n3);
    }

    public void addCaption(String string) {
        this.ensemblePanel.addCaption(string);
    }

    public void setDragable(boolean bl) {
        this.ensemble1.setDragable(bl);
    }

    public void setMinPistonHeight(double d) {
        this.ensemble1.setMinPistonHeight(d);
    }

    public void setPiston(String string, boolean bl) {
        boolean bl2 = false;
        double d = 0.0;
        if (this.clock.isRunning()) {
            bl2 = true;
            this.pause();
        }
        this.parsemode = bl;
        this.parsefield.setText(string);
        if (!this.ensemble1.setParse(string, bl)) {
            this.parsefield.setBackground(Color.red);
            return;
        }
        this.parsefield.setBackground(Color.white);
        d = this.ensemble1.orientation == 0 ? this.ensemble1.xOrigin + this.ensemble1.pparser.evaluate(this.clock.getTime()) : this.ensemble1.yOrigin + this.ensemble1.pparser.evaluate(this.clock.getTime());
        this.ensemble1.movePiston(d, 4, true);
        if (bl2) {
            this.forward();
        }
    }

    public double getPistonPos() {
        if (this.ensemble1.orientation == 0) {
            return this.ensemble1.rwpos;
        }
        return this.ensemble1.twpos;
    }

    public double getRWPos() {
        return this.ensemble1.getRWPos();
    }

    public double getLWPos() {
        return this.ensemble1.getLWPos();
    }

    public double getTWPos() {
        return this.ensemble1.getTWPos();
    }

    public double getBWPos() {
        return this.ensemble1.getBWPos();
    }

    public int getEnsembleID() {
        return this.ensemble1.hashCode();
    }

    public int getHistogramID(int n, double d, double d2) {
        return this.ensemble1.setHistogram(n, d, d2);
    }

    public int getParticleID(int n) {
        return this.ensemble1.addParticleDataSource(n);
    }

    public void setPistonMass(double d) {
        this.ensemble1.setPistonMass(d);
    }

    public void setPistonWidth(int n) {
        this.ensemble1.setPistonWidth(n);
    }

    public void setGravity(double d) {
        this.ensemble1.setGravity(d);
    }

    void parsefield_textValueChanged(TextEvent textEvent) {
        if (!this.ensemble1.setParse(this.parsefield.getText(), this.parsemode)) {
            this.parsefield.setBackground(Color.red);
        } else {
            this.parsefield.setBackground(Color.white);
        }
    }
}

