/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import edu.davidson.numerics.Parser;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import molecular.Ensemble;
import molecular.EnsemblePanel;

public class PistonEnsemble
extends Ensemble {
    Parser pparser = null;
    Color pColor = new Color(120, 120, 0);
    Color bg2Color = Color.white;
    double dt = 0.05;
    boolean dragable = false;
    boolean insidePiston = false;
    boolean parsemode = true;
    int orientation = 1;
    double pa = 0.0;
    double pv = 0.0;
    double ppos = 50.0;
    double dppos = 50.0;
    double twVel = 0.0;
    double rwVel = 0.0;
    double g = -0.8;
    double weight = 23.0;
    double top;
    double y1;
    double y2;
    double mph = 5.0;
    int pwidth = 20;
    int xold;
    int yold;
    double isoTemp = 5.0;
    boolean thermConstrain = false;
    boolean willUpdate = true;

    public PistonEnsemble(EnsemblePanel ensemblePanel) {
        super(ensemblePanel);
        this.periodicv = false;
    }

    public double calcColTimeTW(int n) {
        if (this.orientation == 0) {
            return super.calcColTimeTW(n);
        }
        double d = 10000.0;
        double d2 = this.twpos - this.yPos[n] - this.rad[n];
        double d3 = this.twVel - this.yVel[n];
        if (d2 < 0.0 && d3 < 0.0) {
            return 0.0;
        }
        if (this.twVel > 0.0 && this.yVel[n] < 0.0) {
            return 10000.0;
        }
        double d4 = this.g / (double)2;
        double d5 = d3 * d3 - (double)4 * d4 * d2;
        if (d4 == 0.0) {
            if (d3 > 0.0) {
                return 10000.0;
            }
            if (d2 == 0.0) {
                return 0.0;
            }
            if (d3 == 0.0) {
                return 1000.0;
            }
            double d6 = -d2 / d3;
            if (d6 > 0.0) {
                d = Math.min(d, d6);
            }
        } else if (d5 >= 0.0) {
            double d7 = (-d3 + Math.sqrt(d5)) / ((double)2 * d4);
            double d8 = (-d3 - Math.sqrt(d5)) / ((double)2 * d4);
            if (d7 > 0.0) {
                d = Math.min(d, d7);
            }
            if (d8 > 0.0) {
                d = Math.min(d, d8);
            }
        }
        return Math.max(0.0, d);
    }

    public double calcColTimeRW(int n) {
        if (this.orientation != 0) {
            return super.calcColTimeRW(n);
        }
        this.top = (double)this.owner.currentw / (double)this.ppu;
        double d = 10000.0;
        double d2 = this.rwpos - this.xPos[n] - this.rad[n];
        double d3 = this.rwVel - this.xVel[n];
        if (d2 < 0.0 && d3 < 0.0) {
            return 0.0;
        }
        if (this.rwVel > 0.0 && this.xVel[n] < 0.0) {
            return 10000.0;
        }
        double d4 = this.g / (double)2;
        double d5 = d3 * d3 - (double)4 * d4 * d2;
        if (d4 == 0.0) {
            if (d3 > 0.0) {
                return 10000.0;
            }
            if (d2 == 0.0) {
                return 0.0;
            }
            if (d3 == 0.0) {
                return 1000.0;
            }
            double d6 = -d2 / d3;
            if (d6 > 0.0) {
                d = Math.min(d, d6);
            }
        } else if (d5 >= 0.0) {
            double d7 = (-d3 + Math.sqrt(d5)) / ((double)2 * d4);
            double d8 = (-d3 - Math.sqrt(d5)) / ((double)2 * d4);
            if (d7 > 0.0) {
                d = Math.min(d, d7);
            }
            if (d8 > 0.0) {
                d = Math.min(d, d8);
            }
        }
        return Math.max(0.0, d);
    }

    public double advanceDT(double d) {
        for (int i = 0; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            int n = i;
            this.xPos[n] = this.xPos[n] + d * this.xVel[i];
            int n2 = i;
            this.yPos[n2] = this.yPos[n2] + d * this.yVel[i];
        }
        if (this.orientation == 0) {
            this.rwpos += this.rwVel * d + 0.5 * this.g * d * d;
            this.rwVel += this.g * d;
            this.time += d;
        } else {
            this.twpos += this.twVel * d + 0.5 * this.g * d * d;
            this.twVel += this.g * d;
            this.time += d;
        }
        return d;
    }

    public void collideTW(int n) {
        if (this.orientation == 0) {
            super.collideTW(n);
        } else {
            int n2;
            if (!this.parsemode) {
                double d = this.weight;
                double d2 = this.twVel;
                double d3 = this.mass[n];
                double d4 = this.yVel[n];
                double d5 = d * d2 + d3 * d4;
                double d6 = d * d2 * d2 + d3 * d4 * d4;
                double d7 = (double)-2 * d5 * d3 / d;
                double d8 = d3 + d3 * d3 / d;
                double d9 = d5 * d5 / d - (d * d2 * d2 + d3 * d4 * d4);
                double d10 = d7 * d7 - (double)4 * d8 * d9;
                if (d10 < 0.0) {
                    return;
                }
                double d11 = (-d7 + Math.sqrt(d10)) / ((double)2 * d8);
                double d12 = (-d7 - Math.sqrt(d10)) / ((double)2 * d8);
                d12 = Math.min(d11, d12);
                this.twVel = d11 = (d5 - d3 * d12) / d;
                this.yVel[n] = d12;
                if (this.rwpos > 0.0) {
                    this.pt += Math.abs((d4 - this.yVel[n]) * this.mass[n] / this.rwpos);
                }
                double d13 = d * d11 + d3 * d12;
                double d14 = d * d11 * d11 + d3 * d12 * d12;
            }
            if (this.parsemode) {
                this.y1 = this.yVel[n];
                this.yVel[n] = -this.y1 + (double)2 * this.twVel;
                if (this.rwpos > 0.0) {
                    this.pt += Math.abs((double)2 * this.y1 * this.mass[n] / this.rwpos);
                }
            }
            this.bwColTimes[n] = this.calcColTimeBW(n);
            this.lwColTimes[n] = this.calcColTimeLW(n);
            this.rwColTimes[n] = this.calcColTimeRW(n);
            for (n2 = 0; n2 < this.lastpartnum + 1; ++n2) {
                if (this.empty[n2]) continue;
                this.twColTimes[n2] = this.calcColTimeTW(n2);
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (this.empty[n2]) continue;
                this.colTimes[n][n2] = this.calcColTime(n, n2);
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                if (this.empty[n2]) continue;
                this.colTimes[n2][n] = this.calcColTime(n2, n);
            }
        }
    }

    public void collideRW(int n) {
        if (this.orientation != 0) {
            super.collideRW(n);
        } else {
            int n2;
            if (!this.parsemode) {
                double d = this.weight;
                double d2 = this.rwVel;
                double d3 = this.mass[n];
                double d4 = this.xVel[n];
                double d5 = d * d2 + d3 * d4;
                double d6 = d * d2 * d2 + d3 * d4 * d4;
                double d7 = (double)-2 * d5 * d3 / d;
                double d8 = d3 + d3 * d3 / d;
                double d9 = d5 * d5 / d - (d * d2 * d2 + d3 * d4 * d4);
                double d10 = d7 * d7 - (double)4 * d8 * d9;
                if (d10 < 0.0) {
                    return;
                }
                double d11 = (-d7 + Math.sqrt(d10)) / ((double)2 * d8);
                double d12 = (-d7 - Math.sqrt(d10)) / ((double)2 * d8);
                d12 = Math.min(d11, d12);
                this.rwVel = d11 = (d5 - d3 * d12) / d;
                this.xVel[n] = d12;
                if (this.twpos > 0.0) {
                    this.pr += Math.abs((d4 - this.xVel[n]) * this.mass[n] / this.twpos);
                }
                double d13 = d * d11 + d3 * d12;
                double d14 = d * d11 * d11 + d3 * d12 * d12;
            }
            if (this.parsemode) {
                this.y1 = this.xVel[n];
                this.xVel[n] = -this.y1 + (double)2 * this.rwVel;
                if (this.twpos > 0.0) {
                    this.pr += Math.abs((double)2 * this.y1 * this.mass[n] / this.rwpos);
                }
            }
            this.bwColTimes[n] = this.calcColTimeBW(n);
            this.lwColTimes[n] = this.calcColTimeLW(n);
            this.twColTimes[n] = this.calcColTimeTW(n);
            for (n2 = 0; n2 < this.lastpartnum + 1; ++n2) {
                if (this.empty[n2]) continue;
                this.rwColTimes[n2] = this.calcColTimeRW(n2);
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (this.empty[n2]) continue;
                this.colTimes[n][n2] = this.calcColTime(n, n2);
            }
            for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
                if (this.empty[n2]) continue;
                this.colTimes[n2][n] = this.calcColTime(n2, n);
            }
        }
    }

    void dragPiston(int n, int n2) {
        if (this.orientation == 0) {
            if (n > this.owner.currentw - 2 * this.bwidth) {
                return;
            }
            double d = (double)(n - this.xold) / (double)this.ppu;
            double d2 = Math.max(this.mph, d + this.rwpos);
            this.setParse(Double.toString(d2), true);
            this.movePiston(d2, 1, this.thermConstrain);
        } else {
            if (n2 < 2 * this.bwidth) {
                return;
            }
            double d = (double)(this.yold - n2) / (double)this.ppu;
            double d3 = Math.max(this.mph, d + this.twpos);
            this.setParse(Double.toString(d3), true);
            this.movePiston(d3, 1, this.thermConstrain);
        }
    }

    void movePiston(double d, int n, boolean bl) {
        boolean bl2 = false;
        if (this.applet.clock.isRunning()) {
            bl2 = true;
            this.pause();
        }
        double d2 = this.getTemp();
        double d3 = this.time;
        String string = this.pparser.getFunctionString();
        double d4 = 0.0;
        if (this.orientation == 0) {
            d4 = this.rwpos;
        } else if (this.orientation == 1) {
            d4 = this.twpos;
        }
        double d5 = (double)n * this.applet.clock.getDt();
        double d6 = (d - d4) / d5;
        this.setParse(String.valueOf(String.valueOf(new StringBuffer("").append(d4).append("+").append("(").append(d6).append("*t").append(")"))), this.parsemode);
        this.willUpdate = false;
        for (int i = 0; i < n; ++i) {
            this.step(d5 / (double)n, this.time - d5 / (double)n);
            if (bl) {
                this.setTemp(d2);
                this.thermalize(0.5);
            }
            if (this.histogram != null) {
                this.applet.clearData(this.histogram.hashCode());
            }
            if (this.applet != null) {
                this.applet.updateDataConnections();
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.willUpdate = true;
        this.setParse(string, this.parsemode);
        if (bl2) {
            this.forward();
        }
    }

    public void setOrientation(String string) {
        this.orientation = string.equals("horizontal") ? 0 : 1;
    }

    public boolean setParse(String string, boolean bl) {
        boolean bl2 = false;
        if (this.applet.clock.isRunning()) {
            bl2 = true;
            this.pause();
        }
        this.parsemode = bl;
        boolean bl3 = true;
        String string2 = string;
        string2.toLowerCase().trim();
        this.pparser = new Parser(1);
        this.pparser.define(string2);
        this.pparser.defineVariable(1, "t");
        this.pparser.parse();
        if (this.pparser.getErrorCode() != 0) {
            bl3 = false;
            System.out.println("Failed to parse f(t)): ".concat(String.valueOf(String.valueOf(string2))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error in MathFunction: ").append(this.pparser.getErrorString()).append(" at function 1, position ").append(this.pparser.getErrorPosition()))));
        }
        if (bl2) {
            this.forward();
        }
        return bl3;
    }

    void fitCurveToParse(double d) {
        if (this.pparser == null) {
            return;
        }
        d /= (double)2;
        if (this.orientation == 0) {
            double d2 = this.xOrigin + this.pparser.evaluate(this.time + d);
            double d3 = this.xOrigin + this.pparser.evaluate(this.time + (double)2 * d);
            double d4 = d2 - (this.xOrigin + this.pparser.evaluate(this.time));
            double d5 = d3 - (this.xOrigin + this.pparser.evaluate(this.time));
            double d6 = d * d / (double)2;
            double d7 = d;
            this.rwVel = ((double)4 * d6 * d4 - d6 * d5) / ((double)2 * d7 * d6);
            this.g = (d4 * (double)2 * d7 - d5 * d7) / ((double)2 * d7 * d6);
        } else {
            double d8 = this.yOrigin + this.pparser.evaluate(this.time + d);
            double d9 = this.yOrigin + this.pparser.evaluate(this.time + (double)2 * d);
            double d10 = d8 - (this.yOrigin + this.pparser.evaluate(this.time));
            double d11 = d9 - (this.yOrigin + this.pparser.evaluate(this.time));
            double d12 = d * d / (double)2;
            double d13 = d;
            this.twVel = ((double)4 * d12 * d10 - d12 * d11) / ((double)2 * d13 * d12);
            this.g = (d10 * (double)2 * d13 - d11 * d13) / ((double)2 * d13 * d12);
        }
    }

    public synchronized void paintOSI() {
        int n = 10;
        int n2 = 10;
        int n3 = this.owner.currentw;
        int n4 = this.owner.currenth;
        if (this.owner.osi != null) {
            int n5;
            if (this.periodich) {
                if (this.periodicv) {
                    n2 = 0;
                    n = 0;
                } else {
                    n2 = this.bwidth;
                }
                n = 0;
            } else if (this.periodicv) {
                n = this.bwidth;
                n2 = 0;
            } else {
                n = this.bwidth;
                n2 = this.bwidth;
            }
            Graphics graphics = this.owner.osi.getGraphics();
            if (graphics == null) {
                return;
            }
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n3, n4);
            graphics.setColor(this.bgColor);
            graphics.fillRect(n, n2, n3 - 2 * n, n4 - 2 * n2);
            graphics.setColor(this.bg2Color);
            if (this.orientation == 0) {
                graphics.fillRect(n + (int)(this.rwpos * (double)this.ppu), n2, 1 + (int)((double)(n3 - 2 * n) - this.rwpos * (double)this.ppu), n4 - 2 * n2);
                graphics.setColor(this.pColor);
                graphics.fillRect(n + (int)(this.rwpos * (double)this.ppu), n2, this.pwidth, n4 - 2 * n2);
            } else {
                graphics.fillRect(n, n2, n3 - 2 * n, (int)((double)(n4 - n2) - this.twpos * (double)this.ppu));
                graphics.setColor(this.pColor);
                graphics.fillRect(n, (int)((double)n4 - this.twpos * (double)this.ppu) - this.pwidth, n3 - 2 * n, this.pwidth);
            }
            for (n5 = 0; n5 < this.lastpartnum + 1; ++n5) {
                if (this.empty[n5]) continue;
                graphics.setColor(this.colors[n5]);
                double d = this.rad[n5];
                int n6 = Math.max(2, (int)((double)2 * d * (double)this.ppu));
                graphics.fillOval(n + (int)((double)this.ppu * (this.xPos[n5] - d)), n4 - n2 - (int)((double)this.ppu * (this.yPos[n5] + d)), n6, n6);
                if (this.xPos[n5] + d > this.rwpos) {
                    graphics.fillOval(n + (int)((double)this.ppu * (this.xPos[n5] - d - this.rwpos)), n4 - n2 - (int)((double)this.ppu * (this.yPos[n5] + d)), n6, n6);
                }
                if (!(this.xPos[n5] - d < this.lwpos)) continue;
                graphics.fillOval(n + (int)((double)this.ppu * (this.xPos[n5] - d + this.rwpos)), n4 - n2 - (int)((double)this.ppu * (this.yPos[n5] + d)), n6, n6);
            }
            if (this.orientation == 0) {
                if (this.therms[0]) {
                    graphics.setColor(Color.red);
                    for (n5 = this.bwidth + 1; n5 < n3 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(n5, this.bwidth, n5, this.bwidth + 5);
                    }
                    graphics.setColor(Color.blue);
                    for (n5 = this.bwidth + 3; n5 < n3 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(n5, this.bwidth, n5, this.bwidth + 5);
                    }
                }
                if (this.therms[2]) {
                    graphics.setColor(Color.red);
                    for (n5 = this.bwidth + 1; n5 < n3 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(n5, n4 - this.bwidth - 5, n5, n4 - this.bwidth);
                    }
                    graphics.setColor(Color.blue);
                    for (n5 = this.bwidth + 3; n5 < n3 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(n5, n4 - this.bwidth - 5, n5, n4 - this.bwidth);
                    }
                }
                if (this.therms[3]) {
                    graphics.setColor(Color.red);
                    for (n5 = this.bwidth + 1; n5 < n4 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(this.bwidth, n5, this.bwidth + 5, n5);
                    }
                    graphics.setColor(Color.blue);
                    for (n5 = this.bwidth + 3; n5 < n4 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(this.bwidth, n5, this.bwidth + 5, n5);
                    }
                }
            } else {
                if (this.therms[1]) {
                    graphics.setColor(Color.red);
                    for (n5 = this.bwidth + 1; n5 < n4 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(n3 - this.bwidth - 5, n5, n3 - this.bwidth, n5);
                    }
                    graphics.setColor(Color.blue);
                    for (n5 = this.bwidth + 3; n5 < n4 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(n3 - this.bwidth - 5, n5, n3 - this.bwidth, n5);
                    }
                }
                if (this.therms[2]) {
                    graphics.setColor(Color.red);
                    for (n5 = this.bwidth + 1; n5 < n3 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(n5, n4 - this.bwidth - 5, n5, n4 - this.bwidth);
                    }
                    graphics.setColor(Color.blue);
                    for (n5 = this.bwidth + 3; n5 < n3 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(n5, n4 - this.bwidth - 5, n5, n4 - this.bwidth);
                    }
                }
                if (this.therms[3]) {
                    graphics.setColor(Color.red);
                    for (n5 = this.bwidth + 1; n5 < n4 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(this.bwidth, n5, this.bwidth + 5, n5);
                    }
                    graphics.setColor(Color.blue);
                    for (n5 = this.bwidth + 3; n5 < n4 - this.bwidth - 1; n5 += 6) {
                        graphics.drawLine(this.bwidth, n5, this.bwidth + 5, n5);
                    }
                }
            }
            graphics.dispose();
        }
    }

    public void setPistonMass(double d) {
        this.weight = d;
        this.change = true;
    }

    public void setPistonWidth(int n) {
        if (n >= 1) {
            this.pwidth = Math.min(n, 80);
        }
        this.change = true;
    }

    public void setDragable(boolean bl) {
        this.dragable = bl;
        if (this.dragable) {
            this.setEnableMouse(true);
        }
    }

    public void setMinPistonHeight(double d) {
        if (d > 0.0) {
            this.mph = d;
        }
    }

    public void setConstrainIsothermal(boolean bl) {
        this.thermConstrain = bl;
    }

    public void setGravity(double d) {
        this.g = d;
        this.change = true;
    }

    boolean isInsidePiston(int n, int n2) {
        double d;
        double d2;
        this.insidePiston = this.orientation == 0 ? (d2 = this.lwpos + (double)(n - this.bwidth) / (double)this.ppu) >= this.rwpos && d2 <= this.rwpos + (double)this.pwidth / (double)this.ppu : (d = this.bwpos + (double)(this.owner.currenth - n2) / (double)this.ppu) >= this.twpos && d <= this.twpos + (double)this.pwidth / (double)this.ppu;
        return this.insidePiston;
    }

    public void this_mouseMoved(MouseEvent mouseEvent) {
        if (this.dragable && this.isInsidePiston(mouseEvent.getX(), mouseEvent.getY())) {
            this.owner.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.owner.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public void this_mouseDragged(MouseEvent mouseEvent) {
        if (this.dragable & this.insidePiston) {
            this.dragPiston(mouseEvent.getX(), mouseEvent.getY());
            this.xold = mouseEvent.getX();
            this.yold = mouseEvent.getY();
        }
    }

    public void this_mousePressed(MouseEvent mouseEvent) {
        if (this.dragable && this.insidePiston) {
            if (this.orientation == 0) {
                this.setParse(Double.toString(this.rwpos), true);
            } else {
                this.setParse(Double.toString(this.twpos), true);
            }
            this.xold = mouseEvent.getX();
            this.yold = mouseEvent.getY();
        }
    }

    public void setBounds() {
        for (int i = 0; i < 8; ++i) {
            this.neighbor[i] = null;
        }
        this.owner.currentw = this.owner.getSize().width;
        this.owner.currenth = this.owner.getSize().height;
        if (this.orientation == 0) {
            this.yOrigin = !this.periodicv ? (double)(this.owner.currenth - 2 * this.bwidth) / (double)this.ppu / (double)2 : (double)this.owner.currenth / (double)this.ppu / (double)2;
            this.xOrigin = (double)(this.owner.currentw - 2 * this.bwidth) / (double)this.ppu / (double)2;
            this.ppos = this.parsemode ? this.xOrigin + this.pparser.evaluate(this.time) : this.dppos + this.xOrigin;
            this.setRWPos(this.ppos);
            this.setLWPos(0.0);
            if (!this.periodicv) {
                this.setTWPos((double)(this.owner.currenth - 2 * this.bwidth) / (double)this.ppu);
            } else {
                this.setTWPos((double)this.owner.currenth / (double)this.ppu);
            }
            this.setBWPos(0.0);
            this.setPeriodicH(false);
            if (this.periodicv) {
                this.setNeighbor(1, this, this.rwpos, 0.0);
                this.setNeighbor(5, this, -this.rwpos, 0.0);
            }
        } else {
            this.xOrigin = !this.periodich ? (double)(this.owner.currentw - 2 * this.bwidth) / (double)this.ppu / (double)2 : (double)this.owner.currentw / (double)this.ppu / (double)2;
            this.yOrigin = (double)(this.owner.currenth - 2 * this.bwidth) / (double)this.ppu / (double)2;
            this.ppos = this.parsemode ? this.yOrigin + this.pparser.evaluate(this.time) : this.dppos + this.yOrigin;
            if (!this.periodich) {
                this.setRWPos((double)(this.owner.currentw - 2 * this.bwidth) / (double)this.ppu);
            } else {
                this.setRWPos((double)this.owner.currentw / (double)this.ppu);
            }
            this.setLWPos(0.0);
            this.setTWPos(this.ppos);
            this.setBWPos(0.0);
            this.setPeriodicV(false);
            if (this.periodich) {
                this.setNeighbor(3, this, this.rwpos, 0.0);
                this.setNeighbor(7, this, -this.rwpos, 0.0);
            }
        }
        this.owner.makeImage();
    }

    public void thermalize(double d) {
        double d2 = this.time;
        double d3 = this.twVel;
        double d4 = this.g;
        double d5 = this.pr;
        double d6 = this.pl;
        double d7 = this.pt;
        double d8 = this.pb;
        this.twVel = 0.0;
        this.g = 0.0;
        this.recalculateColTimes();
        int n = 200000;
        double d9 = d;
        do {
            if (d9 < this.mint) {
                this.mint -= d9;
                d9 -= this.advanceDT(d9);
                continue;
            }
            --n;
            d9 -= this.advanceDT(this.mint);
            int n2 = 0;
            while (n2 < this.lastpartnum + 1) {
                int n3 = n2;
                this.rwColTimes[n3] = this.rwColTimes[n3] - this.temptime;
                int n4 = n2;
                this.lwColTimes[n4] = this.lwColTimes[n4] - this.temptime;
                int n5 = n2;
                this.twColTimes[n5] = this.twColTimes[n5] - this.temptime;
                int n6 = n2++;
                this.bwColTimes[n6] = this.bwColTimes[n6] - this.temptime;
            }
            for (int i = 1; i < this.lastpartnum + 1; ++i) {
                int n7 = 0;
                while (n7 < i) {
                    double[] dArray = this.colTimes[i];
                    int n8 = n7++;
                    dArray[n8] = dArray[n8] - this.temptime;
                }
            }
            switch (this.nCollidingW) {
                case 0: {
                    this.collideParticles(this.nColliding1, this.nColliding2);
                    break;
                }
                case 1: {
                    this.collideTW(this.nColliding1);
                    break;
                }
                case 2: {
                    this.collideRW(this.nColliding1);
                    break;
                }
                case 3: {
                    this.collideBW(this.nColliding1);
                    break;
                }
                case 4: {
                    this.collideLW(this.nColliding1);
                }
            }
            this.findMinColTime();
        } while (d9 > 0.0 && n > 0);
        this.pr = d5;
        this.pl = d6;
        this.pt = d7;
        this.pb = d8;
        this.time = d2;
        d3 = this.twVel = d3;
        this.g = d4;
        this.recalculateColTimes();
        if (n <= 0) {
            System.out.println("Maximum number of time steps exceeded in thermalize.  Ensemble volume may be too small. NStep=200000");
            this.diagnostics();
            this.pause();
        }
    }

    void diagnostics() {
        System.out.println("p right=".concat(String.valueOf(String.valueOf(this.pr))));
        System.out.println("p left=".concat(String.valueOf(String.valueOf(this.pl))));
        System.out.println("p top=".concat(String.valueOf(String.valueOf(this.pt))));
        System.out.println("p bottom=".concat(String.valueOf(String.valueOf(this.pb))));
        for (int i = 0; i < this.lastpartnum + 1; ++i) {
            double d;
            double d2;
            if (this.empty[i]) continue;
            double d3 = this.rwpos - this.xPos[i] - this.rad[i];
            if (d3 <= 0.0) {
                System.out.println("right wall c<=0: particle: ".concat(String.valueOf(String.valueOf(i))));
            }
            if ((d3 = this.twpos - this.yPos[i] - this.rad[i]) == 0.0) {
                System.out.println("top wall c=0: particle: ".concat(String.valueOf(String.valueOf(i))));
            }
            if ((d2 = this.yVel[i]) - (d = this.twVel) == 0.0) {
                System.out.println("top wall v= yvel: ".concat(String.valueOf(String.valueOf(i))));
            }
            if ((d2 = this.xVel[i]) - (d = this.rwVel) != 0.0) continue;
            System.out.println("right wall v= xvel: ".concat(String.valueOf(String.valueOf(i))));
        }
    }

    public void step(double d, double d2) {
        double d3 = this.getVol();
        this.time = d2;
        this.qt = 0.0;
        this.qr = 0.0;
        this.qb = 0.0;
        this.ql = 0.0;
        this.pr = 0.0;
        this.pl = 0.0;
        this.pt = 0.0;
        this.pb = 0.0;
        if (this.parsemode) {
            this.fitCurveToParse(d);
            this.recalculateColTimes();
        }
        int n = 200000;
        double d4 = d;
        do {
            if (d4 < this.mint) {
                this.mint -= d4;
                d4 -= this.advanceDT(d4);
                continue;
            }
            --n;
            d4 -= this.advanceDT(this.mint);
            int n2 = 0;
            while (n2 < this.lastpartnum + 1) {
                int n3 = n2;
                this.rwColTimes[n3] = this.rwColTimes[n3] - this.temptime;
                int n4 = n2;
                this.lwColTimes[n4] = this.lwColTimes[n4] - this.temptime;
                int n5 = n2;
                this.twColTimes[n5] = this.twColTimes[n5] - this.temptime;
                int n6 = n2++;
                this.bwColTimes[n6] = this.bwColTimes[n6] - this.temptime;
            }
            for (int i = 1; i < this.lastpartnum + 1; ++i) {
                int n7 = 0;
                while (n7 < i) {
                    double[] dArray = this.colTimes[i];
                    int n8 = n7++;
                    dArray[n8] = dArray[n8] - this.temptime;
                }
            }
            switch (this.nCollidingW) {
                case 0: {
                    this.collideParticles(this.nColliding1, this.nColliding2);
                    break;
                }
                case 1: {
                    this.collideTW(this.nColliding1);
                    break;
                }
                case 2: {
                    this.collideRW(this.nColliding1);
                    break;
                }
                case 3: {
                    this.collideBW(this.nColliding1);
                    break;
                }
                case 4: {
                    this.collideLW(this.nColliding1);
                }
            }
            this.findMinColTime();
        } while (d4 > 0.0 && n > 0);
        if (n <= 0) {
            System.out.println("Maximum number of time steps exceeded.  Ensemble volume may be too small. NStep=100000");
            this.diagnostics();
            this.pause();
        }
        this.paintOSI();
        Graphics graphics = this.owner.getGraphics();
        this.owner.paint(graphics);
        graphics.dispose();
        this.pr /= d;
        this.pl /= d;
        this.pt /= d;
        this.pb /= d;
        this.dv = this.getVol() - d3;
        if (this.willUpdate) {
            if (this.histogram != null) {
                this.applet.clearData(this.histogram.hashCode());
            }
            if (this.applet != null) {
                this.applet.updateDataConnections();
            }
        }
    }

    public void recalculateTWColTimes() {
        for (int i = 0; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            this.twColTimes[i] = this.calcColTimeTW(i);
        }
    }

    public void recalculateRWColTimes() {
        for (int i = 0; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            this.rwColTimes[i] = this.calcColTimeRW(i);
        }
    }

    public void setVolume(double d, int n, boolean bl) {
        boolean bl2 = false;
        if (this.applet.clock.isRunning()) {
            bl2 = true;
            this.pause();
        }
        double d2 = (this.rwpos - this.lwpos) * (this.twpos - this.bwpos);
        if (this.orientation == 0) {
            double d3 = d / (this.twpos - this.bwpos);
            if (d3 < (double)3) {
                System.out.println("Volume too small");
                return;
            }
            double d4 = d3 - this.xOrigin;
            this.setParse(String.valueOf(String.valueOf(new StringBuffer("").append(d4).append(""))), true);
            this.movePiston(d3, n, bl);
        } else {
            double d5 = d / (this.rwpos - this.lwpos);
            if (d5 < (double)3) {
                System.out.println("Volume too small");
                return;
            }
            double d6 = d5 - this.yOrigin;
            this.setParse(String.valueOf(String.valueOf(new StringBuffer("").append(d6).append(""))), true);
            this.movePiston(d5, n, bl);
        }
        if (bl2) {
            this.forward();
        }
    }

    public void reset() {
        if (this.applet.clock.isRunning()) {
            this.pause();
        }
        if (this.orientation == 0) {
            this.rwVel = 0.0;
        } else {
            this.twVel = 0.0;
        }
        this.time = 0.0;
        this.setBounds();
        this.initializeArrays();
        this.recalculateColTimes();
        this.paintOSI();
        this.owner.repaint();
    }

    public void setBG2Color(int n, int n2, int n3) {
        this.bg2Color = new Color(n, n2, n3);
    }

    public synchronized void setInitialPistonPos(double d) {
        this.dppos = d;
        this.owner.osi = null;
        if (this.autoRefresh) {
            this.recalculateColTimes();
            this.owner.repaint();
        }
    }

    public synchronized void setDefaultPiston() {
        if (this.orientation == 0) {
            this.setParse("5*sin(2*t)+5", this.parsemode);
            this.dppos = (double)this.owner.getSize().width / ((double)4 * (double)this.ppu);
        } else {
            this.setParse("5*sin(2*t)+5", this.parsemode);
            this.dppos = (double)this.owner.getSize().height / ((double)4 * (double)this.ppu);
        }
    }
}

