/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import java.awt.Graphics;
import molecular.Ensemble;
import molecular.EnsemblePanel;
import molecular.TPEnsemblePanel;

public class REnsemble
extends Ensemble {
    TPEnsemblePanel towner = null;

    public REnsemble(EnsemblePanel ensemblePanel) {
        super(ensemblePanel);
        this.towner = (TPEnsemblePanel)ensemblePanel;
    }

    public void setBounds() {
        this.towner.setBounds();
    }

    public double calcColTimeLW(int n) {
        if (this.empty[n]) {
            return 10000.0;
        }
        double d = 10000.0;
        double d2 = this.xVel[n];
        double d3 = this.towner.wVel;
        if (d2 > d3 && d2 > 0.0) {
            return 10000.0;
        }
        if (d3 < d2 && d3 < 0.0) {
            return 10000.0;
        }
        if (this.neighbor[7] == null) {
            d = Math.abs((this.lwpos + this.rad[n] - this.xPos[n]) / (d2 - d3));
        } else if (this.xPos[n] > this.lwpos) {
            d = Math.abs((this.lwpos - this.xPos[n]) / (d2 - d3));
        }
        if (d <= 0.0) {
            System.out.println("Error in calcColTimeLW");
        }
        return d;
    }

    public void findMinColTime() {
        double d = 10000.0;
        double d2 = 0.0;
        this.nCollidingW = 0;
        if (!this.empty[0]) {
            if (this.twColTimes[0] < d) {
                d = this.twColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 1;
            }
            if (this.rwColTimes[0] < d) {
                d = this.rwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 2;
            }
            if (this.bwColTimes[0] < d) {
                d = this.bwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 3;
            }
            if (this.lwColTimes[0] < d) {
                d = this.lwColTimes[0];
                this.nColliding1 = 0;
                this.nCollidingW = 4;
            }
        }
        for (int i = 1; i < this.lastpartnum + 1; ++i) {
            if (this.empty[i]) continue;
            if (this.twColTimes[i] < d) {
                d = this.twColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 1;
                if (d <= 0.0) {
                    System.out.println("tWColTime <= 0: Right");
                    this.pause();
                }
            }
            if (this.rwColTimes[i] < d) {
                d = this.rwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 2;
                if (d <= 0.0) {
                    System.out.println("rWColTime <= 0: Right");
                    this.pause();
                }
            }
            if (this.bwColTimes[i] < d) {
                d = this.bwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 3;
                if (d <= 0.0) {
                    System.out.println("bWColTime <= 0: Right");
                    this.pause();
                }
            }
            if (this.lwColTimes[i] < d) {
                d = this.lwColTimes[i];
                this.nColliding1 = i;
                this.nCollidingW = 4;
                if (d <= 0.0) {
                    System.out.println("LWColTime <= 0: Right");
                    this.pause();
                }
            }
            for (int j = 0; j < i; ++j) {
                if (!(this.colTimes[i][j] < d)) continue;
                d = this.colTimes[i][j];
                this.nCollidingW = 0;
                this.nColliding1 = i;
                this.nColliding2 = j;
                if (!(d <= 0.0)) continue;
                System.out.println("PartColTime <= 0: Right");
                this.pause();
            }
        }
        if (d < 0.0) {
            System.out.println("negative Collide Time: Right");
            this.pause();
            d = 10000.0;
        }
        if (d == 0.0) {
            System.out.println("Collide Time = 0: Right");
            this.pause();
            d = 10000.0;
        }
        this.temptime = this.mint = d;
    }

    public void collideLW(int n) {
        int n2;
        if (this.empty[n]) {
            return;
        }
        if (this.neighbor[7] != null) {
            this.xPos[n] = this.rwpos;
        } else {
            double d = this.towner.weight;
            double d2 = this.towner.wVel;
            double d3 = this.mass[n];
            double d4 = this.xVel[n];
            double d5 = d * d2 + d3 * d4;
            double d6 = (double)-2 * d5 * d3 / d;
            double d7 = d3 + d3 * d3 / d;
            double d8 = d5 * d5 / d - (d * d2 * d2 + d3 * d4 * d4);
            double d9 = d6 * d6 - (double)4 * d7 * d8;
            if (d9 < 0.0) {
                return;
            }
            double d10 = (-d6 + Math.sqrt(d9)) / ((double)2 * d7);
            double d11 = (-d6 - Math.sqrt(d9)) / ((double)2 * d7);
            d11 = Math.max(d10, d11);
            this.towner.wVel = d10 = (d5 - d3 * d11) / d;
            this.xVel[n] = d11;
            this.pl += Math.abs((d11 - d4) * this.mass[n] / (this.twpos - this.bwpos));
        }
        this.bwColTimes[n] = this.calcColTimeBW(n);
        this.rwColTimes[n] = this.calcColTimeRW(n);
        this.twColTimes[n] = this.calcColTimeTW(n);
        this.towner.recalcRWColTimes();
        for (n2 = 0; n2 < this.lastpartnum + 1; ++n2) {
            if (this.empty[n2]) continue;
            this.lwColTimes[n2] = this.calcColTimeLW(n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.colTimes[n][n2] = this.calcColTime(n, n2);
        }
        for (n2 = n + 1; n2 < this.lastpartnum + 1; ++n2) {
            this.colTimes[n2][n] = this.calcColTime(n2, n);
        }
    }

    public synchronized void paintOSI() {
        int n = (int)((this.rwpos - this.lwpos) * (double)this.ppu);
        int n2 = (int)(this.lwpos * (double)this.ppu);
        int n3 = (int)((this.twpos - this.bwpos) * (double)this.ppu);
        if (this.towner.osi != null) {
            Graphics graphics = this.towner.osi.getGraphics();
            if (graphics == null) {
                return;
            }
            graphics.setColor(this.bgColor);
            graphics.fillRect(n2, 0, n, n3);
            for (int i = 0; i < this.lastpartnum + 1; ++i) {
                if (this.empty[i]) continue;
                graphics.setColor(this.colors[i]);
                double d = this.rad[i];
                int n4 = Math.max(2, (int)((double)2 * d * (double)this.ppu));
                graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n3 - (int)((double)this.ppu * (this.yPos[i] + d)), n4, n4);
                if (this.xPos[i] + d > this.rwpos) {
                    graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d - this.rwpos)), n3 - (int)((double)this.ppu * (this.yPos[i] + d)), n4, n4);
                }
                if (this.yPos[i] + d > this.twpos) {
                    graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n3 - (int)((double)this.ppu * (this.yPos[i] + d - this.twpos)), n4, n4);
                }
                if (this.yPos[i] - d < this.bwpos) {
                    graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d)), n3 - (int)((double)this.ppu * (this.yPos[i] + d + this.twpos)), n4, n4);
                }
                if (!(this.xPos[i] - d < this.lwpos)) continue;
                graphics.fillOval((int)((double)this.ppu * (this.xPos[i] - d + this.rwpos)), n3 - (int)((double)this.ppu * (this.yPos[i] + d)), n4, n4);
            }
            if (this.therms[0]) {
                // empty if block
            }
            if (this.therms[1]) {
                // empty if block
            }
            if (this.therms[2]) {
                // empty if block
            }
            if (this.therms[3]) {
                // empty if block
            }
            if (this.showMessage) {
                this.paintMessage(graphics);
            }
            graphics.dispose();
        }
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (bl) {
            boolean bl2 = false;
            if (this.applet.clock.isRunning()) {
                bl2 = true;
                this.pause();
            }
            this.recalculateColTimes();
            this.paintOSI();
            this.owner.repaint();
            if (bl2) {
                this.forward();
            }
        }
    }

    public void recalculateColTimes() {
        this.towner.recalculateColTimes();
    }
}

