/*
 * Decompiled with CFR 0.152.
 */
package molecular;

import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SStepable;
import java.awt.Color;
import java.awt.Graphics;
import molecular.EnsemblePanel;
import molecular.LEnsemble;
import molecular.REnsemble;

public class TPEnsemblePanel
extends EnsemblePanel
implements SStepable {
    WallDataSource wallDataSource = null;
    int nCollidingW = 0;
    int nCollidingE = 1;
    double time = 0.0;
    double mint = 10000.0;
    double temptime = 10000.0;
    double weight = 100.0;
    double wVel = 0.0;
    double ppos = 0.5;
    LEnsemble ensemble1 = null;
    REnsemble ensemble2 = null;
    double wwidth = 2.0;

    public TPEnsemblePanel(SApplet sApplet) {
        super(sApplet);
        this.ensemble1 = new LEnsemble(this);
        this.ensemble2 = new REnsemble(this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void step(double d, double d2) {
        double d3 = d;
        this.ensemble1.clearPressureCounters();
        this.ensemble2.clearPressureCounters();
        do {
            if (d3 < this.mint) {
                this.mint -= d3;
                d3 -= this.advanceDT(d3);
                continue;
            }
            d3 -= this.advanceDT(this.mint);
            this.updateTimes(this.temptime);
            switch (this.nCollidingW) {
                case 0: {
                    this.collideParticles();
                    break;
                }
                case 1: {
                    this.collideTW();
                    break;
                }
                case 2: {
                    this.collideRW();
                    break;
                }
                case 3: {
                    this.collideBW();
                    break;
                }
                case 4: {
                    this.collideLW();
                }
            }
            this.findMinColTime();
        } while (d3 > 0.0);
        Graphics graphics = this.getGraphics();
        this.paintOSI();
        this.paint(graphics);
        graphics.dispose();
        this.time = d2 + d;
        this.ensemble1.adjustPressureCounters(d);
        this.ensemble2.adjustPressureCounters(d);
        if (this.ensemble1.histogram != null) {
            this.owner.clearData(this.ensemble1.histogram.hashCode());
        }
        if (this.ensemble2.histogram != null) {
            this.owner.clearData(this.ensemble2.histogram.hashCode());
        }
        if (this.owner != null) {
            this.owner.updateDataConnections();
        }
    }

    public void collideParticles() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideParticles(this.ensemble1.nColliding1, this.ensemble1.nColliding2);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideParticles(this.ensemble2.nColliding1, this.ensemble2.nColliding2);
        }
    }

    public void collideTW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideTW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideTW(this.ensemble2.nColliding1);
        }
    }

    public void collideRW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideRW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideRW(this.ensemble2.nColliding1);
        }
    }

    public void collideBW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideBW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideBW(this.ensemble2.nColliding1);
        }
    }

    public void collideLW() {
        if (this.nCollidingE == 1) {
            this.ensemble1.collideLW(this.ensemble1.nColliding1);
        } else if (this.nCollidingE == 2) {
            this.ensemble2.collideLW(this.ensemble2.nColliding1);
        }
    }

    public double advanceDT(double d) {
        this.ensemble1.advanceDT(d);
        this.ensemble2.advanceDT(d);
        this.ensemble1.rwpos += this.wVel * d;
        this.ensemble2.lwpos += this.wVel * d;
        this.cwpos += this.wVel * d;
        return d;
    }

    public void recalcLWColTimes() {
        for (int i = 0; i < this.ensemble2.lastpartnum + 1; ++i) {
            if (this.ensemble2.empty[i]) continue;
            this.ensemble2.lwColTimes[i] = this.ensemble2.calcColTimeLW(i);
        }
    }

    public void recalcRWColTimes() {
        for (int i = 0; i < this.ensemble1.lastpartnum + 1; ++i) {
            if (this.ensemble1.empty[i]) continue;
            this.ensemble1.rwColTimes[i] = this.ensemble1.calcColTimeRW(i);
        }
    }

    public void updateTimes(double d) {
        int n;
        int n2 = 0;
        while (n2 < this.ensemble1.lastpartnum + 1) {
            int n3 = n2;
            this.ensemble1.rwColTimes[n3] = this.ensemble1.rwColTimes[n3] - d;
            int n4 = n2;
            this.ensemble1.lwColTimes[n4] = this.ensemble1.lwColTimes[n4] - d;
            int n5 = n2;
            this.ensemble1.twColTimes[n5] = this.ensemble1.twColTimes[n5] - d;
            int n6 = n2++;
            this.ensemble1.bwColTimes[n6] = this.ensemble1.bwColTimes[n6] - d;
        }
        for (n2 = 1; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
            n = 0;
            while (n < n2) {
                double[] dArray = this.ensemble1.colTimes[n2];
                int n7 = n++;
                dArray[n7] = dArray[n7] - d;
            }
        }
        n2 = 0;
        while (n2 < this.ensemble2.lastpartnum + 1) {
            int n8 = n2;
            this.ensemble2.rwColTimes[n8] = this.ensemble2.rwColTimes[n8] - d;
            int n9 = n2;
            this.ensemble2.lwColTimes[n9] = this.ensemble2.lwColTimes[n9] - d;
            int n10 = n2;
            this.ensemble2.twColTimes[n10] = this.ensemble2.twColTimes[n10] - d;
            int n11 = n2++;
            this.ensemble2.bwColTimes[n11] = this.ensemble2.bwColTimes[n11] - d;
        }
        for (n2 = 1; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
            n = 0;
            while (n < n2) {
                double[] dArray = this.ensemble2.colTimes[n2];
                int n12 = n++;
                dArray[n12] = dArray[n12] - d;
            }
        }
    }

    public double findMinColTime() {
        this.ensemble1.findMinColTime();
        this.ensemble2.findMinColTime();
        double d = this.ensemble1.mint;
        double d2 = this.ensemble2.mint;
        if (d < d2) {
            this.nCollidingE = 1;
            this.nCollidingW = this.ensemble1.nCollidingW;
            this.temptime = this.mint = d;
            return d;
        }
        this.nCollidingE = 2;
        this.nCollidingW = this.ensemble2.nCollidingW;
        this.temptime = this.mint = d2;
        return d2;
    }

    public void paintOSI() {
        this.ensemble1.paintOSI();
        this.ensemble2.paintOSI();
        if (this.osi == null) {
            return;
        }
        Graphics graphics = this.osi.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.fillRect((int)(this.ensemble1.rwpos * (double)this.ppu), 0, (int)(this.wwidth * (double)this.ppu), this.currenth * this.ppu);
        if (this.showTitle) {
            this.paintCaption(graphics);
        }
        graphics.dispose();
    }

    public void setDefault() {
        this.wVel = 0.0;
        this.ensemble1.setDefault();
        this.ensemble2.setDefault();
        this.wallDataSource = null;
    }

    public void setBounds() {
        this.currentw = this.getSize().width;
        this.currenth = this.getSize().height;
        this.ensemble1.setRWPos((this.ppos * (double)this.currentw - this.wwidth * (double)this.ppu / 2.0) / (double)this.ppu);
        this.ensemble1.setLWPos(0.0);
        this.ensemble1.setTWPos((double)this.currenth / (double)this.ppu);
        this.ensemble1.setBWPos(0.0);
        this.ensemble1.xOrigin = (this.ensemble1.rwpos + this.ensemble1.lwpos) / (double)2;
        this.ensemble1.yOrigin = this.ensemble1.twpos / (double)2;
        this.cwpos = this.ensemble1.rwpos + this.wwidth / (double)2;
        this.ensemble1.setPeriodicV(false);
        if (this.ensemble1.periodicv) {
            this.ensemble1.setNeighbor(1, this.ensemble1, 0.0, this.ensemble1.twpos);
            this.ensemble1.setNeighbor(5, this.ensemble1, 0.0, -this.ensemble1.twpos);
        }
        this.ensemble1.setPeriodicH(false);
        this.ensemble2.setLWPos(this.cwpos + this.wwidth / (double)2);
        this.ensemble2.setRWPos((double)this.currentw / (double)this.ppu);
        this.ensemble2.setTWPos((double)this.currenth / (double)this.ppu);
        this.ensemble2.setBWPos(0.0);
        this.ensemble2.xOrigin = (this.ensemble2.rwpos + this.ensemble2.lwpos) / (double)2;
        this.ensemble2.yOrigin = this.ensemble2.twpos / (double)2;
        this.ensemble2.setPeriodicV(false);
        if (this.ensemble2.periodicv) {
            this.ensemble2.setNeighbor(1, this.ensemble2, 0.0, this.ensemble2.twpos);
            this.ensemble2.setNeighbor(5, this.ensemble2, 0.0, -this.ensemble2.twpos);
        }
        this.ensemble2.setPeriodicH(false);
        this.makeImage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint(Graphics graphics) {
        if (this.osi == null || this.currentw != this.getSize().width || this.currenth != this.getSize().height) {
            if (this.getSize().width <= 2) return;
            boolean bl = this.owner.clock.isRunning();
            this.owner.clock.stopClock();
            this.setBounds();
            graphics.drawImage(this.osi, 0, 0, this.currentw, this.currenth, this);
            if (bl) {
                this.owner.clock.startClock();
            }
        } else {
            graphics.drawImage(this.osi, 0, 0, this.currentw, this.currenth, this);
        }
        if (this.ensemble1.mouseDown) {
            this.ensemble1.paintCoords(graphics);
        }
        if (!this.ensemble2.mouseDown) return;
        this.ensemble2.paintCoords(graphics);
    }

    public int getWallDataSource() {
        if (this.wallDataSource == null) {
            this.wallDataSource = new WallDataSource();
        }
        return this.wallDataSource.getID();
    }

    public LEnsemble getEnsemble1() {
        return this.ensemble1;
    }

    public REnsemble getEnsemble2() {
        return this.ensemble2;
    }

    public void setPistonWidth(double d) {
        if (d > 0.0) {
            this.wwidth = d;
        }
    }

    public void setPistonPosition(double d) {
        if (d > 0.0 && d < 1.0) {
            this.ppos = d;
        }
        this.osi = null;
        if (this.ensemble1.autoRefresh) {
            this.recalculateColTimes();
            this.owner.repaint();
        }
    }

    public void setPistonMass(double d) {
        if (d > 0.0) {
            this.weight = d;
        }
    }

    public TPEnsemblePanel() {
    }

    public void recalculateColTimes() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
            if (this.ensemble1.empty[n2]) continue;
            n = n2;
            this.ensemble1.rwColTimes[n2] = this.ensemble1.calcColTimeRW(n2);
            this.ensemble1.lwColTimes[n2] = this.ensemble1.calcColTimeLW(n2);
            this.ensemble1.twColTimes[n2] = this.ensemble1.calcColTimeTW(n2);
            this.ensemble1.bwColTimes[n2] = this.ensemble1.calcColTimeBW(n2);
        }
        for (n2 = 1; n2 < this.ensemble1.lastpartnum + 1; ++n2) {
            for (n = 0; n < n2; ++n) {
                if (this.ensemble1.empty[n] || this.ensemble1.empty[n2]) continue;
                this.ensemble1.colTimes[n2][n] = this.ensemble1.calcColTime(n2, n);
            }
        }
        for (n2 = 0; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
            if (this.ensemble2.empty[n2]) continue;
            n = n2;
            this.ensemble2.rwColTimes[n2] = this.ensemble2.calcColTimeRW(n2);
            this.ensemble2.lwColTimes[n2] = this.ensemble2.calcColTimeLW(n2);
            this.ensemble2.twColTimes[n2] = this.ensemble2.calcColTimeTW(n2);
            this.ensemble2.bwColTimes[n2] = this.ensemble2.calcColTimeBW(n2);
        }
        for (n2 = 1; n2 < this.ensemble2.lastpartnum + 1; ++n2) {
            for (n = 0; n < n2; ++n) {
                if (this.ensemble2.empty[n] || this.ensemble2.empty[n2]) continue;
                this.ensemble2.colTimes[n2][n] = this.ensemble2.calcColTime(n2, n);
            }
        }
        this.findMinColTime();
    }

    public class WallDataSource
    implements SDataSource {
        String[] varStrings = new String[]{"t", "x", "vx", "m"};
        double[][] ds = new double[1][4];

        WallDataSource() {
            try {
                SApplet.addDataSource((Object)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public double[][] getVariables() {
            this.ds[0][0] = TPEnsemblePanel.this.owner.getClockTime();
            this.ds[0][1] = TPEnsemblePanel.this.cwpos - (double)(TPEnsemblePanel.this.currentw / 2) / (double)TPEnsemblePanel.this.ppu;
            this.ds[0][2] = TPEnsemblePanel.this.wVel;
            this.ds[0][3] = TPEnsemblePanel.this.weight;
            return this.ds;
        }

        public String[] getVarStrings() {
            return this.varStrings;
        }

        public int getID() {
            return this.hashCode();
        }

        public void setOwner(SApplet sApplet) {
        }

        public SApplet getOwner() {
            return TPEnsemblePanel.this.owner;
        }
    }
}

