/*
 * Decompiled with CFR 0.152.
 */
package eField4;

import eField4.ArrowHead;
import eField4.Charge;
import eField4.CollisionThing;
import eField4.EField;
import eField4.ImageThing;
import eField4.LineAnchor;
import eField4.OdeCanvas_mouseAdapter;
import eField4.OdeCanvas_mouseMotionAdapter;
import eField4.Pole;
import eField4.ShapeThing;
import eField4.TestCharge;
import eField4.TextThing;
import eField4.Thing;
import eField4.TrailThing;
import eField4.VectorField;
import edu.davidson.display.Format;
import edu.davidson.display.SContour;
import edu.davidson.graph.DataSet;
import edu.davidson.graphics.Util;
import edu.davidson.numerics.Parser;
import edu.davidson.numerics.SDifferentiable;
import edu.davidson.numerics.SRK45;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class OdeCanvas
extends Canvas
implements SStepable,
Runnable {
    private CollisionThing collisionDataSource;
    private boolean newData = false;
    Object delayLock = new Object();
    private Thread delayThread = null;
    private Image sketchImage = null;
    Color darkBlue = new Color(0, 0, 128);
    Color lightBlue = new Color(128, 128, 255);
    String message = null;
    double time = 0.0;
    Vector arrowHeads = new Vector();
    Vector testCharges = new Vector();
    Vector poles = new Vector();
    Vector fieldSolvers = new Vector();
    Vector fieldPoles = new Vector(10);
    Vector drawThings = new Vector(20);
    Vector fieldLines = new Vector(20);
    Parser parser = null;
    String potStr = null;
    Font f = new Font("Helvetica", 1, 14);
    String caption = null;
    double bz = 0.0;
    double xmin = -1.0;
    double xmax = 1.0;
    double ymin = -1.0;
    double ymax = 1.0;
    double tolerance = 1.0E-5;
    double polemin = 0.0;
    double polemax = 0.0;
    boolean showContours = true;
    boolean showFieldLines = false;
    boolean showPoles = true;
    boolean showFieldVectors = true;
    boolean showCoordOnDrag = true;
    boolean showVOnDrag = false;
    boolean showEOnDrag = false;
    boolean showFieldLineOnClick = false;
    boolean showFieldLineOnDoubleClick = false;
    boolean showEquipotentialOnClick = false;
    boolean showEquipotentialOnDoubleClick = false;
    boolean autoRefresh = true;
    boolean showTime = true;
    boolean pointChargeMode = true;
    boolean collision = false;
    boolean dampOnMousePressed = false;
    boolean calculatingFieldLines = false;
    Thing dragShape = null;
    SContour contour = new SContour();
    VectorField field = new VectorField(4, 4);
    private Image osi = null;
    private Image osi2 = null;
    private boolean osiInvalid = true;
    private int iwidth = 0;
    private int iheight = 0;
    private int xOffset = 0;
    private int yOffset = 0;
    private int boxWidth = 0;
    private Format format = new Format("%-+8.4g");
    private boolean isDrag = false;
    private boolean dragV = false;
    private int groupIndex = 0;
    private EField parentSApplet = null;
    private double mouseX;
    private double mouseY;
    private int gridSize = 64;
    private int skip = 2;
    private boolean fieldLinesInvalid = false;
    private boolean sketchMode = false;
    private TrailThing trailThing = null;
    private Cursor sketchCursor = null;
    private boolean allPositive = true;
    private boolean allNegative = true;

    public OdeCanvas(EField eField) {
        this.parentSApplet = eField;
        this.contour.setShowAxis(false);
        this.contour.setDataBackground(Color.white);
        this.contour.setLabelColor(Color.green);
        this.addMouseMotionListener(new OdeCanvas_mouseMotionAdapter(this));
        this.addMouseListener(new OdeCanvas_mouseAdapter(this));
        this.contour.setOwner((SApplet)eField);
        this.delayThread = new Thread(this);
        this.delayThread.start();
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this.parentSApplet;
    }

    public void setDefault() {
        this.collisionDataSource = null;
        this.dragShape = null;
        this.sketchMode = false;
        this.stopFieldThreads();
        this.parentSApplet.lock.getBusyFlag();
        this.time = 0.0;
        this.tolerance = 1.0E-5;
        this.message = null;
        this.showFieldLineOnClick = false;
        this.showFieldLineOnDoubleClick = false;
        this.showEquipotentialOnClick = false;
        this.showEquipotentialOnDoubleClick = false;
        this.showTime = true;
        this.showCoordOnDrag = true;
        this.showVOnDrag = false;
        this.showEOnDrag = false;
        this.setXRange(this.xmin, this.xmax);
        this.message = null;
        this.allPositive = true;
        this.allNegative = true;
        this.clearPoles();
        this.clearTestCharges();
        this.clearDrawThings();
        this.contour.deleteAllSeries();
        this.parentSApplet.lock.freeBusyFlag();
    }

    public void setMessage(String string) {
        this.message = string == null || string.trim().equals("") ? null : string;
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
        if (this.autoRefresh) {
            this.setFields();
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public void setBz(double d) {
        this.bz = d;
    }

    public void setCaption(String string) {
        this.caption = string;
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    private void refreshContour() {
        if (this.osi == null) {
            return;
        }
        Graphics graphics = this.osi.getGraphics();
        if (this.contour != null && graphics != null) {
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            this.contour.paint(graphics, rectangle);
        }
    }

    public void setXRange(double d, double d2) {
        if (d2 == d) {
            this.xmin = d - 0.5;
            this.xmax = d2 + 0.5;
        } else if (d2 > d) {
            this.xmin = d;
            this.xmax = d2;
        } else {
            this.xmin = d2;
            this.xmax = d;
        }
        if (this.iwidth == 0) {
            return;
        }
        double d3 = (this.xmax - this.xmin) / (double)this.iwidth;
        this.ymin = (this.ymax + this.ymin) / (double)2 - d3 * (double)this.iheight / 2.0;
        this.ymax = this.ymin + d3 * (double)this.iheight;
        this.setFields();
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public void setYRange(double d, double d2) {
        if (d2 == d) {
            this.ymin = d - 0.5;
            this.ymax = d2 + 0.5;
        } else if (d2 > d) {
            this.ymin = d;
            this.ymax = d2;
        } else {
            this.ymin = d2;
            this.ymax = d;
        }
        if (this.iheight == 0) {
            return;
        }
        double d3 = (this.ymax - this.ymin) / (double)this.iheight;
        this.xmin = (this.xmax + this.xmin) / (double)2 - d3 * (double)this.iwidth / 2.0;
        this.xmax = this.xmin + d3 * (double)this.iwidth;
        this.setFields();
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public boolean setRange(String string) {
        boolean bl = false;
        double[] dArray = new double[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ", ; / \\ ( { [ ) } ] \t \n \r");
        if (stringTokenizer.countTokens() < 4) {
            bl = true;
        } else {
            for (int i = 0; i < 4; ++i) {
                try {
                    dArray[i] = Double.valueOf(stringTokenizer.nextToken().trim());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Error setting range:".concat(String.valueOf(String.valueOf(string))));
                    bl = true;
                }
            }
        }
        if (bl) {
            return false;
        }
        this.xmin = dArray[0];
        this.xmax = dArray[1];
        this.ymin = dArray[2];
        this.ymax = dArray[3];
        this.setXRange(this.xmin, this.xmax);
        return true;
    }

    public boolean setPotStr(String string, double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
        this.setXRange(this.xmin, this.xmax);
        return this.setPotStr(string);
    }

    public boolean setPotStr(String string, String string2) {
        this.setRange(string2);
        return this.setPotStr(string);
    }

    public void setShowContours(boolean bl) {
        this.showContours = bl;
        this.contour.setNoContours(!bl);
        this.setFields();
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public void setShowFieldLines(boolean bl) {
        this.showFieldLines = bl;
        if (!this.showFieldLines) {
            this.message = null;
        }
        this.setFields();
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public void setShowFieldVectors(boolean bl) {
        this.showFieldVectors = bl;
        this.setFields();
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public void setShowPoles(boolean bl) {
        this.showPoles = bl;
        this.setFields();
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public int setSketchMode(boolean bl) {
        Applet applet = Util.getApplet((Component)this);
        this.sketchImage = Util.getImage((String)"pencil.gif", (Applet)applet);
        boolean bl2 = false;
        int n = 29;
        this.sketchMode = bl;
        if (!bl) {
            this.trailThing = null;
            return 0;
        }
        this.trailThing = new TrailThing(this, 1);
        this.trailThing.trailSize = 2000;
        this.sketchCursor = null;
        return this.trailThing.hashCode();
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }

    public boolean setTrajectory(int n, String string, String string2) {
        Thing thing = null;
        Enumeration enumeration = this.drawThings.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            boolean bl = thing.setTrajectory(string, string2);
            if (thing instanceof Charge) {
                this.setFields();
            }
            return bl;
        }
        return false;
    }

    public boolean setShowFComponents(int n, boolean bl) {
        Charge charge = null;
        Enumeration enumeration = this.poles.elements();
        while (enumeration.hasMoreElements()) {
            charge = (Charge)enumeration.nextElement();
            if (charge.hashCode() != n) continue;
            charge.showFComponents = bl;
            if (this.autoRefresh) {
                Object object = this.delayLock;
                synchronized (object) {
                    this.newData = true;
                    this.delayLock.notify();
                }
            }
            return true;
        }
        enumeration = this.testCharges.elements();
        while (enumeration.hasMoreElements()) {
            charge = (Charge)enumeration.nextElement();
            if (charge.hashCode() != n) continue;
            charge.showFComponents = bl;
            if (this.autoRefresh) {
                Object object = this.delayLock;
                synchronized (object) {
                    this.newData = true;
                    this.delayLock.notify();
                }
            }
            return true;
        }
        return false;
    }

    public boolean setShowFOnDrag(int n, boolean bl) {
        Thing thing = null;
        Enumeration enumeration = this.drawThings.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            thing.showFOnDrag = bl;
            return true;
        }
        return false;
    }

    public boolean setShowFVector(int n, boolean bl) {
        Charge charge = null;
        Enumeration enumeration = this.poles.elements();
        while (enumeration.hasMoreElements()) {
            charge = (Charge)enumeration.nextElement();
            if (charge.hashCode() != n) continue;
            charge.setShowFVector(bl);
            if (this.autoRefresh) {
                Object object = this.delayLock;
                synchronized (object) {
                    this.newData = true;
                    this.delayLock.notify();
                }
            }
            return true;
        }
        enumeration = this.testCharges.elements();
        while (enumeration.hasMoreElements()) {
            charge = (Charge)enumeration.nextElement();
            if (charge.hashCode() != n) continue;
            charge.setShowFVector(bl);
            if (this.autoRefresh) {
                Object object = this.delayLock;
                synchronized (object) {
                    this.newData = true;
                    this.delayLock.notify();
                }
            }
            return true;
        }
        return false;
    }

    public boolean setShowVVector(int n, boolean bl) {
        Charge charge = null;
        Enumeration enumeration = this.poles.elements();
        while (enumeration.hasMoreElements()) {
            charge = (Charge)enumeration.nextElement();
            if (charge.hashCode() != n) continue;
            charge.setShowV(bl);
            if (this.autoRefresh) {
                Object object = this.delayLock;
                synchronized (object) {
                    this.newData = true;
                    this.delayLock.notify();
                }
            }
            return true;
        }
        enumeration = this.testCharges.elements();
        while (enumeration.hasMoreElements()) {
            charge = (Charge)enumeration.nextElement();
            if (charge.hashCode() != n) continue;
            charge.setShowV(bl);
            if (this.autoRefresh) {
                Object object = this.delayLock;
                synchronized (object) {
                    this.newData = true;
                    this.delayLock.notify();
                }
            }
            return true;
        }
        return false;
    }

    public boolean setSpeed(int n, double d) {
        Charge charge = null;
        Enumeration enumeration = this.testCharges.elements();
        while (enumeration.hasMoreElements()) {
            charge = (Charge)enumeration.nextElement();
            if (charge.hashCode() != n) continue;
            charge.setSpeed(d);
            if (this.autoRefresh) {
                Object object = this.delayLock;
                synchronized (object) {
                    this.newData = true;
                    this.delayLock.notify();
                }
            }
            return true;
        }
        return false;
    }

    public boolean setShowVComponents(int n, boolean bl) {
        Charge charge = null;
        Enumeration enumeration = this.poles.elements();
        while (enumeration.hasMoreElements()) {
            charge = (Charge)enumeration.nextElement();
            if (charge.hashCode() != n) continue;
            charge.showVComponents = bl;
            if (this.autoRefresh) {
                Object object = this.delayLock;
                synchronized (object) {
                    this.newData = true;
                    this.delayLock.notify();
                }
            }
            return true;
        }
        enumeration = this.testCharges.elements();
        while (enumeration.hasMoreElements()) {
            charge = (Charge)enumeration.nextElement();
            if (charge.hashCode() != n) continue;
            charge.showVComponents = bl;
            if (this.autoRefresh) {
                Object object = this.delayLock;
                synchronized (object) {
                    this.newData = true;
                    this.delayLock.notify();
                }
            }
            return true;
        }
        return false;
    }

    public void setShowTime(boolean bl) {
        this.showTime = bl;
    }

    public void setShowCoordOnDrag(boolean bl) {
        this.showCoordOnDrag = bl;
    }

    public void setShowVOnDrag(boolean bl) {
        this.showVOnDrag = bl;
    }

    public void setShowEOnDrag(boolean bl) {
        this.showEOnDrag = bl;
    }

    public void setShowFieldLineOnClick(boolean bl) {
        if (this.showFieldLineOnClick == bl) {
            return;
        }
        this.showFieldLineOnClick = bl;
        this.showFieldLineOnDoubleClick = false;
        this.showEquipotentialOnClick = false;
        this.showEquipotentialOnDoubleClick = false;
    }

    public void setShowFieldLineOnDoubleClick(boolean bl) {
        if (this.showFieldLineOnDoubleClick == bl) {
            return;
        }
        this.showFieldLineOnDoubleClick = bl;
        this.showFieldLineOnClick = false;
        this.showEquipotentialOnClick = false;
        this.showEquipotentialOnDoubleClick = false;
    }

    public void setShowEquipotentialOnClick(boolean bl) {
        if (this.showEquipotentialOnClick == bl) {
            return;
        }
        this.showEquipotentialOnClick = bl;
        this.showEquipotentialOnDoubleClick = false;
        this.showFieldLineOnClick = false;
        this.showFieldLineOnDoubleClick = false;
    }

    public void setShowEquipotentialOnDoubleClick(boolean bl) {
        if (this.showEquipotentialOnDoubleClick == bl) {
            return;
        }
        this.showEquipotentialOnDoubleClick = bl;
        this.showEquipotentialOnClick = false;
        this.showFieldLineOnClick = false;
        this.showFieldLineOnDoubleClick = false;
    }

    public void setShowLabels(boolean bl) {
        this.contour.setDrawLabels(bl);
        this.setFields();
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public boolean setPotStr(String string) {
        this.potStr = string.trim();
        if (this.potStr.equals("") || this.potStr.equals("0")) {
            this.parser = null;
            this.setFields();
            if (this.autoRefresh) {
                Object object = this.delayLock;
                synchronized (object) {
                    this.newData = true;
                    this.delayLock.notify();
                }
            }
            return true;
        }
        this.parser = new Parser(2);
        this.parser.defineVariable(1, "x");
        this.parser.defineVariable(2, "y");
        this.parser.define(this.potStr);
        this.parser.parse();
        if (this.parser.getErrorCode() != 0) {
            System.out.println("Failed to parse U(x,y): ".concat(String.valueOf(String.valueOf(this.parser.getFunctionString()))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parser.getErrorString()).append(" at function 1, position ").append(this.parser.getErrorPosition()))));
            return false;
        }
        this.setFields();
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        return true;
    }

    public void resetTime() {
        Charge charge;
        this.time = 0.0;
        this.dragShape = null;
        int n = this.testCharges.size();
        for (int i = 0; i < n; ++i) {
            charge = (Charge)this.testCharges.elementAt(i);
            if (charge.hasTrajectory()) {
                charge.setTime(this.time, 0.001);
            } else {
                charge.resetTime();
            }
            charge.clearTrail();
            charge.updateMySlaves();
        }
        this.time = 0.0;
        Object object = this.poles.elements();
        while (object.hasMoreElements()) {
            charge = (Charge)object.nextElement();
            if (!charge.hasTrajectory()) continue;
            charge.setTime(this.time, 0.001);
            charge.clearTrail();
            charge.updateMySlaves();
        }
        this.setFields();
        this.message = null;
        if (this.autoRefresh) {
            object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        if (this.parentSApplet != null) {
            this.parentSApplet.clearAllData();
        }
        this.parentSApplet.updateDataConnections();
    }

    public boolean deleteObject(int n) {
        Thing thing = null;
        thing = this.getThing(n);
        if (thing == null) {
            return false;
        }
        if (this.parentSApplet != null) {
            this.parentSApplet.stop();
        }
        this.stopFieldThreads();
        this.drawThings.removeElement(thing);
        this.testCharges.removeElement(thing);
        this.poles.removeElement(thing);
        if (this.parentSApplet != null) {
            this.parentSApplet.removeDataSource(thing.hashCode());
            this.parentSApplet.cleanupDataConnections();
        }
        this.polemin = 0.0;
        this.polemax = 0.0;
        this.setFields();
        this.clearAnchors();
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        return true;
    }

    void clearAnchors() {
        Enumeration enumeration = this.drawThings.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            if (!(thing instanceof LineAnchor) || !this.drawThings.contains(((LineAnchor)thing).thing)) continue;
            this.drawThings.removeElement(thing);
        }
    }

    public void clearDrawThings() {
        Vector vector;
        Vector vector2 = this.drawThings;
        synchronized (vector2) {
            vector = (Vector)this.drawThings.clone();
            this.drawThings.removeAllElements();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            this.parentSApplet.removeDataSource(thing.hashCode());
        }
        if (this.parentSApplet != null) {
            this.parentSApplet.cleanupDataConnections();
        }
    }

    public void clearTestCharges() {
        Vector vector;
        Vector vector2 = this.testCharges;
        synchronized (vector2) {
            vector = (Vector)this.testCharges.clone();
            this.testCharges.removeAllElements();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Charge charge = (Charge)enumeration.nextElement();
            if (this.drawThings.contains(charge)) {
                this.drawThings.removeElement(charge);
            }
            this.parentSApplet.removeDataSource(charge.hashCode());
        }
        if (this.parentSApplet != null) {
            this.parentSApplet.cleanupDataConnections();
        }
        this.clearAnchors();
    }

    public void clearPoles() {
        Vector vector;
        this.stopFieldThreads();
        Vector vector2 = this.poles;
        synchronized (vector2) {
            vector = (Vector)this.poles.clone();
            this.poles.removeAllElements();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Charge charge = (Charge)enumeration.nextElement();
            if (this.drawThings.contains(charge)) {
                this.drawThings.removeElement(charge);
            }
            this.parentSApplet.removeDataSource(charge.hashCode());
        }
        if (this.parentSApplet != null) {
            this.parentSApplet.cleanupDataConnections();
        }
        this.polemin = 0.0;
        this.polemax = 0.0;
        this.setFields();
        this.clearAnchors();
        this.newData = true;
        if (this.autoRefresh) {
            this.repaint();
        }
    }

    public void clearTrails() {
        int n = this.testCharges.size();
        for (int i = 0; i < n; ++i) {
            Charge charge = (Charge)this.testCharges.elementAt(i);
            charge.clearTrail();
        }
    }

    public int addImage(Image image, double d, double d2) {
        if (image == null) {
            return 0;
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0, 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageThing imageThing = new ImageThing(this, image, d, d2);
        this.drawThings.addElement(imageThing);
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        return imageThing.hashCode();
    }

    public int addPolyShape(int n, int[] nArray, int[] nArray2, double d, double d2) {
        ShapeThing shapeThing = new ShapeThing(this, n, nArray, nArray2, d, d2);
        this.drawThings.addElement(shapeThing);
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        return shapeThing.hashCode();
    }

    public Charge addTestCharge() {
        double d = this.xmin + (this.xmax - this.xmin) * Math.random();
        double d2 = this.ymin + (this.ymax - this.ymin) * Math.random();
        Charge charge = this.addTestCharge(d, d2, 0.0, 0.0);
        charge.setShowFVector(true);
        charge.setShowV(true);
        return charge;
    }

    public Charge addTestCharge(double d, double d2, double d3, double d4) {
        TestCharge testCharge = new TestCharge(this, d, d2, d3, d4);
        testCharge.setAcceleration();
        this.drawThings.addElement(testCharge);
        this.testCharges.addElement(testCharge);
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        return testCharge;
    }

    public Charge addPole(double d) {
        double d2 = this.xmin + (this.xmax - this.xmin) * Math.random();
        double d3 = this.ymin + (this.ymax - this.ymin) * Math.random();
        Charge charge = this.addPole(d2, d3, d);
        return charge;
    }

    public Charge addPole(double d, double d2, double d3) {
        Pole pole = new Pole(this, d, d2, d3);
        this.drawThings.addElement(pole);
        this.stopFieldThreads();
        this.poles.addElement(pole);
        this.setFields();
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        return pole;
    }

    public void update(Graphics graphics) {
        if (this.autoRefresh) {
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public Color getBackground() {
        if (this.contour != null) {
            return this.contour.getDataBackground();
        }
        return this.getBackground();
    }

    public void paintOSI() {
        if (this.parentSApplet.destroyed) {
            return;
        }
        boolean bl = false;
        if (this.osi == null || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
            this.iwidth = this.getSize().width;
            this.iheight = this.getSize().height;
            this.osi = null;
            this.setXRange(this.xmin, this.xmax);
            this.osi = this.createImage(this.iwidth, this.iheight);
            this.osi2 = this.createImage(this.iwidth, this.iheight);
            bl = true;
        }
        if (this.osi == null || this.parentSApplet.destroyed) {
            return;
        }
        Graphics graphics = this.osi.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iwidth, this.iheight);
        this.osiInvalid = false;
        if (this.contour != null) {
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            this.contour.noContours = !this.showContours;
            this.contour.paint(graphics, rectangle);
            this.paintArrowHeads(graphics, rectangle);
            if (this.showFieldVectors) {
                this.field.paint(graphics, rectangle, this.skip);
            }
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.iwidth, this.iheight);
            graphics.setColor(graphics.getColor());
            graphics.clipRect(0, 0, this.iwidth, this.iheight);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.iwidth - 1, this.iheight - 1);
        graphics.dispose();
        if (bl) {
            this.clearTrails();
        }
    }

    public void paint(Graphics graphics) {
        if (this.parentSApplet.destroyed) {
            return;
        }
        Object object = this.delayLock;
        synchronized (object) {
            this.newData = true;
            this.delayLock.notify();
        }
    }

    public void paint() {
        if (this.parentSApplet.destroyed) {
            return;
        }
        try {
            if (this.getSize().width == 0 || this.getSize().height == 0) {
                return;
            }
            if (this.osi == null || this.osiInvalid || this.iwidth != this.getSize().width || this.iheight != this.getSize().height) {
                if (this.getSize().width == 0) {
                    return;
                }
                this.paintOSI();
            }
            if (this.osi == null || this.osi2 == null) {
                return;
            }
            Graphics graphics = this.osi2.getGraphics();
            graphics.drawImage(this.osi, 0, 0, this);
            Font font = graphics.getFont();
            graphics.setFont(this.f);
            this.paintThings(graphics);
            graphics.setColor(Color.black);
            this.paintMessage(graphics, this.message);
            graphics.setColor(Color.black);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
            if (this.caption != null) {
                graphics.setColor(Color.black);
                graphics.drawString(this.caption, (this.iwidth - fontMetrics.stringWidth(this.caption)) / 2, 25);
            }
            if (this.showTime) {
                String string = new Format("%7.4g").form(this.time);
                graphics.setColor(Color.black);
                if (this.iwidth > 150) {
                    graphics.drawString(String.valueOf(String.valueOf(this.parentSApplet.label_time)).concat(String.valueOf(String.valueOf(string))), 10, 15);
                } else {
                    graphics.drawString(String.valueOf(String.valueOf(this.parentSApplet.label_time)).concat(String.valueOf(String.valueOf(string))), 10, this.iheight - 40);
                }
            }
            graphics.setFont(font);
            graphics.dispose();
            graphics = this.getGraphics();
            if (graphics == null || this.osi2 == null) {
                return;
            }
            graphics.drawImage(this.osi2, 0, 0, this);
            graphics.dispose();
            if (this.fieldLinesInvalid && this.dragShape == null) {
                this.paintFieldLines();
                this.fieldLinesInvalid = false;
            }
        }
        catch (Exception exception) {
            this.repaint();
        }
    }

    public void paintMessage(Graphics graphics, String string) {
        if (string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        graphics.setColor(Color.yellow);
        int n = 15 + fontMetrics.stringWidth(string);
        graphics.fillRect(this.iwidth - n - 5, this.iheight - 15, n, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, this.iwidth - n + 2, this.iheight - 3);
        graphics.drawRect(this.iwidth - n - 5, this.iheight - 15, n, 15);
    }

    public void paintForceOnCharge(Graphics graphics, Charge charge) {
        double d = charge.getX();
        double d2 = charge.getY();
        double d3 = charge.getMag();
        double d4 = d3 * (-this.dudx(d, d2) + this.getPoleFx(d, d2, charge) + this.bz * charge.getVY());
        double d5 = d3 * (-this.dudy(d, d2) + this.getPoleFy(d, d2, charge) - this.bz * charge.getVX());
        int n = this.pixFromX(d);
        int n2 = this.pixFromY(d2);
        int n3 = this.pixFromX(d + d4);
        int n4 = this.pixFromY(d2 + d5);
        Color color = graphics.getColor();
        if (charge.showFComponents) {
            graphics.setColor(this.lightBlue);
            SUtil.drawArrow((Graphics)graphics, (int)n, (int)n2, (int)n3, (int)n2);
            SUtil.drawArrow((Graphics)graphics, (int)n3, (int)n2, (int)n3, (int)n4);
        }
        graphics.setColor(this.darkBlue);
        SUtil.drawArrow((Graphics)graphics, (int)n, (int)n2, (int)n3, (int)n4);
        graphics.setColor(color);
    }

    public void paintTestCharges(Graphics graphics) {
        int n = this.testCharges.size();
        for (int i = 0; i < n; ++i) {
            Charge charge = (Charge)this.testCharges.elementAt(i);
            if (this.dragShape == charge) continue;
            charge.paint(graphics);
            if (!charge.isShowFVector()) continue;
            this.paintForceOnCharge(graphics, charge);
        }
    }

    public void paintPoles(Graphics graphics) {
        int n = this.poles.size();
        for (int i = 0; i < n; ++i) {
            Pole pole = (Pole)this.poles.elementAt(i);
            if (this.dragShape == pole) continue;
            pole.paint(graphics);
            if (!pole.isShowFVector()) continue;
            this.paintForceOnCharge(graphics, pole);
        }
    }

    public void paintThings(Graphics graphics) {
        Vector vector;
        Vector vector2 = this.drawThings;
        synchronized (vector2) {
            vector = (Vector)this.drawThings.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Thing thing = (Thing)enumeration.nextElement();
            thing.paint(graphics);
            if (!(thing instanceof Charge) || !((Charge)thing).isShowFVector()) continue;
            this.paintForceOnCharge(graphics, (Charge)thing);
        }
    }

    public void paintArrowHeads(Graphics graphics, Rectangle rectangle) {
        int n = this.arrowHeads.size();
        for (int i = 0; i < n; ++i) {
            ArrowHead arrowHead = (ArrowHead)this.arrowHeads.elementAt(i);
            arrowHead.paint(graphics, rectangle);
        }
    }

    final double getPotential(double d, double d2) {
        if (this.parser != null) {
            return this.parser.evaluate(d, d2) + this.getPoleU(d, d2);
        }
        return this.getPoleU(d, d2);
    }

    final double getPE(Charge charge) {
        if (charge == null) {
            return 0.0;
        }
        double d = charge.getX();
        double d2 = charge.getY();
        double d3 = charge.getMag();
        if (this.poles == null) {
            return 0.0;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n = this.poles.size();
        for (int i = 0; i < n; ++i) {
            Pole pole = (Pole)this.poles.elementAt(i);
            if (pole == charge) continue;
            d4 = pole.getX();
            d5 = pole.getY();
            d6 = pole.getMag();
            d8 = (d4 - d) * (d4 - d) + (d5 - d2) * (d5 - d2);
            if (d8 != 0.0) {
                if (this.pointChargeMode) {
                    d7 += d6 * d3 / Math.sqrt(d8);
                    continue;
                }
                d7 += (double)2 * d6 * d3 * Math.log(d8);
                continue;
            }
            d7 = Double.NaN;
        }
        if (this.parser != null) {
            d7 += d3 * this.parser.evaluate(d, d2);
        }
        return d7;
    }

    final double getPoleU(double d, double d2) {
        if (this.poles == null) {
            return 0.0;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n = this.poles.size();
        for (int i = 0; i < n; ++i) {
            Pole pole = (Pole)this.poles.elementAt(i);
            d3 = pole.getX();
            d4 = pole.getY();
            d5 = pole.getMag();
            d7 = (d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2);
            if (d7 == 0.0) continue;
            if (this.pointChargeMode) {
                d6 += d5 / Math.sqrt(d7);
                continue;
            }
            d6 += (double)2 * d5 * Math.log(d7);
        }
        return d6;
    }

    final double getFx(Charge charge) {
        double d = charge.getX();
        double d2 = charge.getY();
        double d3 = charge.getMag();
        return d3 * (-this.dudx(d, d2) + this.getPoleFx(d, d2, charge) + this.bz * charge.getVY());
    }

    final double getFy(Charge charge) {
        double d = charge.getX();
        double d2 = charge.getY();
        double d3 = charge.getMag();
        return d3 * (-this.dudy(d, d2) + this.getPoleFy(d, d2, charge) - this.bz * charge.getVX());
    }

    final double getPoleFx(double d, double d2, Charge charge) {
        if (this.poles == null) {
            return 0.0;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = this.poles.size();
        for (int i = 0; i < n; ++i) {
            Pole pole = (Pole)this.poles.elementAt(i);
            if (charge == pole) continue;
            d3 = pole.getX();
            d4 = pole.getY();
            d5 = pole.getMag();
            if (this.pointChargeMode) {
                d6 += d5 * (d - d3) / Math.pow((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2), 1.5);
                continue;
            }
            d6 += (double)2 * d5 * (d - d3) / ((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        }
        return d6;
    }

    final double getPoleFx_Cyl(double d, double d2, Charge charge) {
        if (this.poles == null) {
            return 0.0;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = this.poles.size();
        for (int i = 0; i < n; ++i) {
            Pole pole = (Pole)this.poles.elementAt(i);
            if (charge == pole) continue;
            d3 = pole.getX();
            d4 = pole.getY();
            d5 = pole.getMag();
            d6 += (double)2 * d5 * (d - d3) / ((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        }
        return d6;
    }

    final double getPoleFy(double d, double d2, Charge charge) {
        if (this.poles == null) {
            return 0.0;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = this.poles.size();
        for (int i = 0; i < n; ++i) {
            Pole pole = (Pole)this.poles.elementAt(i);
            if (charge == pole) continue;
            d3 = pole.getX();
            d4 = pole.getY();
            d5 = pole.getMag();
            if (this.pointChargeMode) {
                d6 += d5 * (d2 - d4) / Math.pow((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2), 1.5);
                continue;
            }
            d6 += (double)2 * d5 * (d2 - d4) / ((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        }
        return d6;
    }

    final double getPoleFy_Cyl(double d, double d2, Charge charge) {
        if (this.poles == null) {
            return 0.0;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = this.poles.size();
        for (int i = 0; i < n; ++i) {
            Pole pole = (Pole)this.poles.elementAt(i);
            if (charge == pole) continue;
            d3 = pole.getX();
            d4 = pole.getY();
            d5 = pole.getMag();
            d6 += (double)2 * d5 * (d2 - d4) / ((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        }
        return d6;
    }

    final double dudx(double d, double d2) {
        double d3 = 1.0E-7;
        if (this.parser == null) {
            return 0.0;
        }
        double d4 = this.parser.evaluate(d - (double)2 * d3, d2);
        double d5 = this.parser.evaluate(d - d3, d2);
        double d6 = this.parser.evaluate(d + d3, d2);
        double d7 = this.parser.evaluate(d + (double)2 * d3, d2);
        return (-d7 + (double)8 * d6 - (double)8 * d5 + d4) / ((double)12 * d3);
    }

    final double dudy(double d, double d2) {
        double d3 = 1.0E-7;
        if (this.parser == null) {
            return 0.0;
        }
        double d4 = this.parser.evaluate(d, d2 - (double)2 * d3);
        double d5 = this.parser.evaluate(d, d2 - d3);
        double d6 = this.parser.evaluate(d, d2 + d3);
        double d7 = this.parser.evaluate(d, d2 + (double)2 * d3);
        return (-d7 + (double)8 * d6 - (double)8 * d5 + d4) / ((double)12 * d3);
    }

    public double getTime() {
        return this.time;
    }

    public Thing getThing(int n) {
        Thing thing = null;
        Enumeration enumeration = this.drawThings.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.hashCode() != n) continue;
            return thing;
        }
        return null;
    }

    public CollisionThing getCollisionThing() {
        if (this.collisionDataSource != null) {
            return this.collisionDataSource;
        }
        this.collisionDataSource = new CollisionThing(this);
        this.drawThings.addElement(this.collisionDataSource);
        return this.collisionDataSource;
    }

    public double getParticleEnergy(Charge charge) {
        double d = charge.getX();
        double d2 = charge.getY();
        double d3 = charge.getVX();
        double d4 = charge.getVY();
        double d5 = this.parser != null ? this.parser.evaluate(d, d2) + this.getPoleU(d, d2) : this.getPoleU(d, d2);
        return d3 * d3 / (double)2 + d4 * d4 / (double)2 + d5;
    }

    public boolean testForCollision() {
        int n = this.testCharges.size();
        for (int i = 0; i < n; ++i) {
            Charge charge = (Charge)this.testCharges.elementAt(i);
            if (charge.disabled || !(charge instanceof TestCharge) || !this.isInsideStickyThing(this.pixFromX(charge.vars[1]), this.pixFromY(charge.vars[2]), charge)) continue;
            return true;
        }
        return false;
    }

    public void run() {
        while (this.delayThread != null) {
            Object object = this.delayLock;
            synchronized (object) {
                if (!this.newData && this.delayThread != null) {
                    try {
                        this.delayLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                this.newData = false;
                if (this.delayThread != null) {
                    this.paint();
                    if (this.isDrag) {
                        this.paintCoordinates(this.mouseX, this.mouseY);
                    }
                }
            }
            if (this.delayThread == null) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        this.delayThread = null;
    }

    public void step(double d, double d2) {
        Object object;
        Charge charge;
        this.time = d2 + d;
        double[] dArray = new double[5];
        int n = this.testCharges.size();
        for (int i = 0; i < n; ++i) {
            charge = (Charge)this.testCharges.elementAt(i);
            if (charge.disabled || charge.myMaster != null) continue;
            if (charge.hasTrajectory()) {
                charge.setTime(this.time, d);
            } else {
                ((TestCharge)charge).enforceConstraintOnXY();
                ((TestCharge)charge).odeSolver.step(d, charge.getVars());
            }
            charge.incTrail();
            if (!(charge instanceof TestCharge) || !this.isInsideStickyThing(this.pixFromX(charge.vars[1]), this.pixFromY(charge.vars[2]), charge)) continue;
            this.collision = true;
            charge.vars[3] = 0.0;
            charge.vars[4] = 0.0;
            if (this.collisionDataSource == null) continue;
            this.collisionDataSource.setXYT(charge.vars[1], charge.vars[1], this.time);
            this.collisionDataSource.setBlock(false);
            this.parentSApplet.updateDataConnection(this.collisionDataSource.hashCode());
            this.collisionDataSource.setBlock(true);
        }
        Enumeration enumeration = this.drawThings.elements();
        while (enumeration.hasMoreElements()) {
            object = (Thing)enumeration.nextElement();
            if (((Thing)object).myMaster == null) continue;
            ((Thing)object).setVarsFromMaster();
            ((Thing)object).incTrail();
        }
        boolean bl = false;
        object = this.poles.elements();
        while (object.hasMoreElements()) {
            charge = (Charge)object.nextElement();
            if (!charge.hasTrajectory()) continue;
            bl = true;
            charge.setTime(this.time, d);
            charge.incTrail();
        }
        object = this.drawThings.elements();
        while (object.hasMoreElements()) {
            Thing thing = (Thing)object.nextElement();
            if (thing instanceof Charge) continue;
            thing.setTime(this.time, d);
        }
        if (bl && this.showContours) {
            this.setFields();
        } else if (bl && this.showFieldVectors) {
            this.setDirectionVectors();
            this.osiInvalid = true;
        }
        if (this.parentSApplet != null) {
            this.parentSApplet.updateDataConnections();
        }
        if (this.autoRefresh) {
            object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
        if (this.collision) {
            this.setMessage("Collision");
            this.parentSApplet.stopClock();
        }
    }

    private void stopDrawingThread() {
        Object object = this.delayLock;
        synchronized (object) {
            this.delayLock.notify();
        }
        try {
            this.delayThread.interrupt();
            this.delayThread.join(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        Object object = this.delayLock;
        synchronized (object) {
            this.stopFieldThreads();
        }
        this.stopDrawingThread();
        this.contour.destroy();
    }

    void stopFieldThreads() {
        Vector vector;
        Vector vector2 = this.fieldSolvers;
        synchronized (vector2) {
            vector = (Vector)this.fieldSolvers.clone();
        }
        if (vector.size() == 0) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            FieldSolver fieldSolver = (FieldSolver)enumeration.nextElement();
            fieldSolver.interrupt();
            this.fieldSolvers.removeElement(fieldSolver);
        }
        this.parentSApplet.lock.getBusyFlag();
        this.arrowHeads.removeAllElements();
        this.contour.deleteAllNonSeriesData();
        vector = null;
        this.parentSApplet.lock.freeBusyFlag();
        this.calculatingFieldLines = false;
    }

    void setZRange() {
        this.polemin = 0.0;
        this.polemax = 0.0;
        int n = this.fieldPoles.size();
        for (int i = 0; i < n; ++i) {
            Pole pole = (Pole)this.fieldPoles.elementAt(i);
            if (this.polemin > pole.getMaxU()) {
                this.polemin = pole.getMaxU();
            }
            if (!(this.polemax < pole.getMaxU())) continue;
            this.polemax = pole.getMaxU();
        }
    }

    void setFieldResolution(int n) {
        if (this.skip == n) {
            return;
        }
        this.skip = n;
        if (this.autoRefresh) {
            this.setFields();
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    void setGridSize(int n) {
        if (this.gridSize == n) {
            return;
        }
        this.gridSize = n;
        if (this.autoRefresh) {
            this.setFields();
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    public final boolean setFormat(String string) {
        try {
            this.format = new Format(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private void deleteFieldLines() {
        Enumeration enumeration = this.fieldLines.elements();
        while (enumeration.hasMoreElements()) {
            DataSet dataSet = (DataSet)enumeration.nextElement();
            this.contour.detachDataSet(dataSet);
        }
        this.arrowHeads.removeAllElements();
        this.fieldLines.removeAllElements();
    }

    synchronized void setFields() {
        Thing thing;
        double d;
        int n;
        double d2;
        int n2;
        if (!this.autoRefresh) {
            return;
        }
        this.stopFieldThreads();
        this.clearTrails();
        this.parentSApplet.lock.getBusyFlag();
        int n3 = this.gridSize;
        int n4 = this.gridSize;
        this.deleteFieldLines();
        this.contour.deleteContours();
        double[][] dArray = new double[n3][n4];
        this.calcFieldPoles();
        this.setZRange();
        for (n2 = 0; n2 < n4; ++n2) {
            d2 = (this.ymax - this.ymin) * (double)n2 / (double)(n4 - 1) + this.ymin;
            for (n = 0; n < n3; ++n) {
                d = (this.xmax - this.xmin) * (double)n / (double)(n3 - 1) + this.xmin;
                double d3 = this.getPoleU(d, d2);
                if (d3 > this.polemax) {
                    d3 = this.polemax;
                }
                if (d3 < this.polemin) {
                    d3 = this.polemin;
                }
                dArray[n][n2] = this.parser != null ? this.parser.evaluate(d, d2) + d3 : d3;
            }
        }
        this.contour.setGrid(dArray, this.xmin, this.xmax, this.ymin, this.ymax);
        n3 = this.gridSize / this.skip;
        n4 = this.gridSize / this.skip;
        double[][][] dArray2 = this.field.resize(n4, n3);
        for (n2 = 0; n2 < n3; ++n2) {
            d = (this.xmax - this.xmin) * (double)n2 / (double)(n3 - 1) + this.xmin;
            for (n = 0; n < n4; ++n) {
                double d4;
                d2 = (this.ymax - this.ymin) * (double)n / (double)(n4 - 1) + this.ymin;
                double d5 = -this.dudx(d, d2) + this.getPoleFx(d, d2, null);
                double d6 = Math.sqrt(d5 * d5 + (d4 = -this.dudy(d, d2) + this.getPoleFy(d, d2, null)) * d4);
                if (d6 > 0.0) {
                    dArray2[n][n2][0] = d5 / d6;
                    dArray2[n][n2][1] = d4 / d6;
                    dArray2[n][n2][2] = d6;
                    continue;
                }
                dArray2[n][n2][0] = 0.0;
                dArray2[n][n2][1] = 0.0;
                dArray2[n][n2][2] = 0.0;
            }
        }
        Enumeration enumeration = this.drawThings.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.setAcceleration();
        }
        enumeration = this.drawThings.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            thing.setVarsFromMaster();
        }
        this.osiInvalid = true;
        this.parentSApplet.lock.freeBusyFlag();
        if (this.showFieldLines) {
            this.fieldLinesInvalid = true;
        }
    }

    void setDirectionVectors() {
        int n = this.gridSize / this.skip;
        int n2 = this.gridSize / this.skip;
        double[][][] dArray = this.field.resize(n2, n);
        for (int i = 0; i < n; ++i) {
            double d = (this.xmax - this.xmin) * (double)i / (double)(n - 1) + this.xmin;
            for (int j = 0; j < n2; ++j) {
                double d2;
                double d3 = (this.ymax - this.ymin) * (double)j / (double)(n2 - 1) + this.ymin;
                double d4 = -this.dudx(d, d3) + this.getPoleFx(d, d3, null);
                double d5 = Math.sqrt(d4 * d4 + (d2 = -this.dudy(d, d3) + this.getPoleFy(d, d3, null)) * d2);
                if (d5 > 0.0) {
                    dArray[j][i][0] = d4 / d5;
                    dArray[j][i][1] = d2 / d5;
                    dArray[j][i][2] = d5;
                    continue;
                }
                dArray[j][i][0] = 0.0;
                dArray[j][i][1] = 0.0;
                dArray[j][i][2] = 0.0;
            }
        }
    }

    public double xFromPix(int n) {
        if (this.contour != null) {
            return this.contour.xFromPix(n);
        }
        return n;
    }

    public int pixFromX(double d) {
        if (this.contour != null) {
            return this.contour.pixFromX(d);
        }
        return (int)Math.round(d);
    }

    public double yFromPix(int n) {
        if (this.contour != null) {
            return this.contour.yFromPix(n);
        }
        return n;
    }

    public int pixFromY(double d) {
        if (this.contour != null) {
            return this.contour.pixFromY(d);
        }
        return (int)Math.round(d);
    }

    void calcFieldPoles() {
        Vector vector = this.poles;
        synchronized (vector) {
            this.fieldPoles.removeAllElements();
            int n = this.poles.size();
            this.allPositive = true;
            this.allNegative = true;
            if (n <= 0) {
                return;
            }
            Pole pole = (Pole)((Pole)this.poles.elementAt(0)).clone();
            this.fieldPoles.addElement(pole);
            if (pole.mag < 0.0) {
                this.allPositive = false;
            }
            if (pole.mag > 0.0) {
                this.allNegative = false;
            }
            for (int i = 1; i < n; ++i) {
                pole = (Pole)((Pole)this.poles.elementAt(i)).clone();
                if (pole.mag < 0.0) {
                    this.allPositive = false;
                }
                if (pole.mag > 0.0) {
                    this.allNegative = false;
                }
                boolean bl = true;
                for (int j = 0; j < this.fieldPoles.size(); ++j) {
                    Pole pole2 = (Pole)this.fieldPoles.elementAt(j);
                    if (!pole2.doesOverlap(pole)) continue;
                    bl = false;
                    pole2.mag += pole.mag;
                    break;
                }
                if (!bl) continue;
                this.fieldPoles.addElement(pole);
            }
        }
    }

    void paintFieldLines() {
        Pole pole;
        int n;
        if (this.parentSApplet.destroyed) {
            return;
        }
        if (this.parser == null && this.fieldPoles.size() == 0) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 12;
        int n3 = this.fieldPoles.size();
        for (n = 0; n < n3; ++n) {
            pole = (Pole)this.fieldPoles.elementAt(n);
            d2 += pole.mag;
        }
        for (n = 0; n < n3; ++n) {
            pole = (Pole)this.fieldPoles.elementAt(n);
            if (Math.abs(pole.mag) < 4.94E-322) continue;
            n2 = (int)Math.round(Math.abs(12.0 * pole.mag));
            if (n2 > 48) {
                n2 = 32;
            }
            double d3 = pole.getX();
            double d4 = pole.getY();
            double d5 = pole.getRadius();
            for (int i = 0; i < n2; ++i) {
                d = Math.PI * 2 * (double)i / (double)n2;
                double d6 = d5 * Math.cos(d);
                double d7 = d5 * Math.sin(d);
                if (pole.mag > 0.0 && d2 >= 0.0) {
                    new FieldSolver(d3 + d6, d4 + d7, true, pole);
                }
                if (!(pole.mag < 0.0) || !(d2 < 0.0)) continue;
                new FieldSolver(d3 + d6, d4 + d7, false, pole);
            }
        }
        double d8 = (this.xmax - this.xmin) / 100.0;
        double d9 = 0.0;
        if (d8 <= 0.0) {
            d8 = 0.01;
        }
        if (this.parser != null) {
            boolean bl = d2 >= 0.0;
            d9 = this.paintLeftFieldLines(d9, d8, bl);
            d9 = this.paintTopFieldLines(d9, d8, bl);
            d9 = this.paintRightFieldLines(d9, d8, bl);
            d9 = this.paintBottomFieldLines(d9, d8, bl);
        }
    }

    double paintLeftFieldLines(double d, double d2, boolean bl) {
        double d3 = this.xmin;
        double d4 = this.ymin;
        while (d4 < this.ymax) {
            double d5 = -(-this.dudx(d3, d4 += d2) + this.getPoleFx_Cyl(d3, d4, null));
            if (bl && d5 < 0.0) {
                d += Math.abs(d5 * d2);
            }
            if (!bl && d5 > 0.0) {
                d += d5 * d2;
            }
            if (!(d > 0.52)) continue;
            d -= 0.52;
            new FieldSolver(d3, d4, bl);
        }
        return d;
    }

    double paintTopFieldLines(double d, double d2, boolean bl) {
        double d3 = this.xmin;
        double d4 = this.ymax;
        while (d3 < this.xmax) {
            double d5 = -this.dudy(d3 += d2, d4) + this.getPoleFy_Cyl(d3, d4, null);
            if (bl && d5 < 0.0) {
                d += Math.abs(d5 * d2);
            }
            if (!bl && d5 > 0.0) {
                d += d5 * d2;
            }
            if (!(d > 0.52)) continue;
            d -= 0.52;
            new FieldSolver(d3, d4, bl);
        }
        return d;
    }

    double paintRightFieldLines(double d, double d2, boolean bl) {
        double d3 = this.xmax;
        double d4 = this.ymax;
        while (d4 > this.ymin) {
            double d5 = -this.dudx(d3, d4 -= d2) + this.getPoleFx_Cyl(d3, d4, null);
            if (bl && d5 < 0.0) {
                d += Math.abs(d5 * d2);
            }
            if (!bl && d5 > 0.0) {
                d += d5 * d2;
            }
            if (!(d > 0.52)) continue;
            d -= 0.52;
            new FieldSolver(d3, d4, bl);
        }
        return d;
    }

    double paintBottomFieldLines(double d, double d2, boolean bl) {
        double d3 = this.xmax;
        double d4 = this.ymin;
        while (d3 > this.xmin) {
            double d5 = -(-this.dudy(d3 -= d2, d4) + this.getPoleFy_Cyl(d3, d4, null));
            if (bl && d5 < 0.0) {
                d += Math.abs(d5 * d2);
            }
            if (!bl && d5 > 0.0) {
                d += d5 * d2;
            }
            if (!(d > 0.52)) continue;
            d -= 0.52;
            new FieldSolver(d3, d4, bl);
        }
        return d;
    }

    boolean isInsideStickyThing(int n, int n2, Thing thing) {
        Thing thing2 = null;
        Enumeration enumeration = this.drawThings.elements();
        while (enumeration.hasMoreElements()) {
            thing2 = (Thing)enumeration.nextElement();
            if (thing2 == thing || !thing2.sticky || !thing2.isInsideThing(n, n2)) continue;
            return true;
        }
        return false;
    }

    boolean isInsideDragableThing(int n, int n2) {
        Thing thing = null;
        Enumeration enumeration = this.drawThings.elements();
        while (enumeration.hasMoreElements()) {
            thing = (Thing)enumeration.nextElement();
            if (thing.noDrag || !thing.isInsideThing(n, n2)) continue;
            return true;
        }
        return false;
    }

    boolean isInsidePole(double d, double d2) {
        int n = this.poles.size();
        for (int i = 0; i < n; ++i) {
            Pole pole = (Pole)this.poles.elementAt(i);
            if (!pole.isInsidePole(d, d2, this) || pole == this.dragShape) continue;
            return true;
        }
        return false;
    }

    void paintCoordinates(double d, double d2) {
        Graphics graphics = this.getGraphics();
        this.paintCoordinates(graphics, d, d2);
        graphics.dispose();
    }

    void paintCoordinates(Graphics graphics, double d, double d2) {
        double d3;
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        String string = "";
        if (this.showCoordOnDrag) {
            string = String.valueOf(String.valueOf(new StringBuffer("x=").append(this.format.form(d)).append(" y=").append(this.format.form(d2))));
        }
        boolean bl = this.isInsidePole(d, d2);
        if (this.showVOnDrag) {
            if (bl || this.dragShape != null && this.dragShape instanceof Pole) {
                string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.parentSApplet.label_volt_undefined)));
            } else {
                d3 = this.parser != null ? this.parser.evaluate(d, d2) + this.getPoleU(d, d2) : this.getPoleU(d, d2);
                string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.parentSApplet.label_volt).append(this.format.form(d3))));
            }
        }
        if (this.dragShape != null && this.dragShape.showFOnDrag && this.dragShape instanceof Charge) {
            d3 = this.dragShape.mag * (-this.dudx(d, d2) + this.getPoleFx(d, d2, (Charge)this.dragShape) + this.bz * this.dragShape.getVY());
            double d4 = this.dragShape.mag * (-this.dudy(d, d2) + this.getPoleFy(d, d2, (Charge)this.dragShape) - this.bz * this.dragShape.getVX());
            string = bl ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.parentSApplet.label_force_undefined))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.parentSApplet.label_force).append(this.format.form(Math.sqrt(d3 * d3 + d4 * d4)))));
        } else if (this.showEOnDrag) {
            if (bl || this.dragShape instanceof Pole) {
                bl = true;
                string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.parentSApplet.label_field_undefined)));
            } else {
                d3 = -this.dudx(d, d2) + this.getPoleFx(d, d2, null);
                double d5 = -this.dudy(d, d2) + this.getPoleFy(d, d2, null);
                string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.parentSApplet.label_field).append(this.format.form(Math.sqrt(d3 * d3 + d5 * d5)))));
            }
        }
        graphics.setColor(Color.yellow);
        if (!string.equals("")) {
            this.boxWidth = Math.max(this.boxWidth, 20 + fontMetrics.stringWidth(string));
        }
        if (this.boxWidth == 0) {
            return;
        }
        graphics.fillRect(0, this.getBounds().height - 15, this.boxWidth, 15);
        graphics.setColor(Color.black);
        graphics.drawString(string, 8, this.getBounds().height - 2);
        graphics.drawRect(0, this.getBounds().height - 15, this.boxWidth, 15);
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        this.boxWidth = 0;
        int n = mouseEvent.getX();
        if (n < 1) {
            n = 1;
        } else if (n > this.iwidth - 2) {
            n = this.iwidth - 2;
        }
        int n2 = mouseEvent.getY();
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.iheight - 2) {
            n2 = this.iheight - 2;
        }
        double d = this.xFromPix(n);
        double d2 = this.yFromPix(n2);
        if (this.dragShape != null) {
            if (this.dragV) {
                this.dragShape.setVX(d - this.dragShape.getX());
                this.dragShape.setVY(d2 - this.dragShape.getY());
            } else if (this.dampOnMousePressed) {
                this.dragShape.setVX(0.0);
                this.dragShape.setVY(0.0);
            }
            this.dragShape.updateMySlaves();
            if (this.dragShape instanceof Pole) {
                this.setFields();
            } else {
                this.dragShape.clearTrail();
                this.osiInvalid = true;
            }
            if (!this.testForCollision()) {
                this.collision = false;
                this.message = null;
            }
            this.repaint();
        }
        if (this.isDrag) {
            this.isDrag = false;
            if (this.fieldSolvers.size() == 0) {
                this.repaint();
            }
        }
        this.dragShape = null;
        this.this_mouseMoved(mouseEvent);
        if (this.sketchMode && this.trailThing != null) {
            this.contour.attachDataSet(this.trailThing.dataset);
            this.contour.xaxis.attachDataSet(this.trailThing.dataset);
            this.contour.yaxis.attachDataSet(this.trailThing.dataset);
            Object object = this.delayLock;
            synchronized (object) {
                this.newData = true;
                this.delayLock.notify();
            }
        }
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        double d = this.xFromPix(mouseEvent.getX());
        double d2 = this.yFromPix(mouseEvent.getY());
        if (mouseEvent.isShiftDown() && this.showFieldLines || this.showFieldLineOnClick || mouseEvent.getClickCount() == 2 && this.showFieldLineOnDoubleClick) {
            new FieldSolver(d, d2, true);
            new FieldSolver(d, d2, false);
            return;
        }
        if (this.showEquipotentialOnClick || mouseEvent.getClickCount() == 2 && this.showEquipotentialOnDoubleClick) {
            this.contour.calculateCurve(this.getPotential(d, d2));
            this.osiInvalid = true;
            this.repaint();
            return;
        }
        this.isDrag = true;
        this.dragShape = null;
        this.dragV = mouseEvent.isControlDown();
        Graphics graphics = this.getGraphics();
        int n = this.drawThings.size();
        for (int i = 0; i < n; ++i) {
            Thing thing = (Thing)this.drawThings.elementAt(i);
            if (thing.noDrag || !thing.isInsideThing(mouseEvent.getX(), mouseEvent.getY())) continue;
            this.dragShape = thing;
        }
        this.osiInvalid = true;
        if (this.dragShape != null) {
            if (this.dragShape instanceof Pole) {
                this.stopFieldThreads();
            }
            graphics.setXORMode(this.getBackground());
            this.dragShape.paintHighlight(graphics);
            if (this.dragV) {
                this.dragShape.setVX(d - this.dragShape.getX());
                this.dragShape.setVY(d2 - this.dragShape.getY());
            } else if (this.dampOnMousePressed) {
                this.dragShape.setVX(0.0);
                this.dragShape.setVY(0.0);
            }
            this.dragShape.paint(graphics);
            if (this.dragShape instanceof Charge && this.dragShape.isShowFVector()) {
                this.paintForceOnCharge(graphics, (Charge)this.dragShape);
            }
            graphics.setPaintMode();
        }
        this.mouseX = d;
        this.mouseY = d2;
        graphics.dispose();
        this.paintCoordinates(d, d2);
        if (this.sketchMode && this.trailThing != null) {
            this.trailThing.clearTrail();
            this.parentSApplet.clearData(this.trailThing.hashCode());
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.this_mouseDragged(mouseEvent);
        }
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (this.isInsideDragableThing(n2, n = mouseEvent.getY())) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (this.sketchMode) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    void charge_Dragged(MouseEvent mouseEvent, boolean bl) {
        int n = mouseEvent.getX();
        if (n < 1) {
            n = 1;
        } else if (n > this.iwidth - 2) {
            n = this.iwidth - 2;
        }
        double d = this.xFromPix(n);
        int n2 = mouseEvent.getY();
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.iheight - 2) {
            n2 = this.iheight - 2;
        }
        double d2 = this.yFromPix(n2);
        this.mouseX = d;
        this.mouseY = d2;
        if (this.isDrag) {
            Graphics graphics = this.getGraphics();
            if (this.dragShape != null) {
                Object object;
                if (this.dragV) {
                    this.dragShape.setVX(d - this.dragShape.getX());
                    this.dragShape.setVY(d2 - this.dragShape.getY());
                } else {
                    this.dragShape.setXY(d, d2);
                    if (this.dampOnMousePressed) {
                        this.dragShape.setVX(0.0);
                        this.dragShape.setVY(0.0);
                    }
                    this.dragShape.setAcceleration();
                }
                if (this.parentSApplet.isClockRunning()) {
                    this.paintCoordinates(d, d2);
                    return;
                }
                this.parentSApplet.updateDataConnections();
                if (this.osi == null) {
                    this.osi = this.createImage(this.iwidth, this.iheight);
                    this.osi2 = this.createImage(this.iwidth, this.iheight);
                }
                this.osiInvalid = false;
                Graphics graphics2 = this.osi.getGraphics();
                Rectangle rectangle = new Rectangle(this.iwidth, this.iheight);
                graphics2.setColor(Color.white);
                graphics2.fillRect(0, 0, this.iwidth, this.iheight);
                if (bl) {
                    this.setDirectionVectors();
                    this.field.paint(graphics2, rectangle, this.skip);
                } else {
                    boolean bl2 = this.contour.getDrawLabels();
                    this.contour.setDrawLabels(false);
                    this.contour.paint(graphics2, rectangle);
                    this.contour.setDrawLabels(bl2);
                    if (this.showFieldVectors) {
                        this.field.paint(graphics2, rectangle, this.skip);
                    }
                }
                Object object2 = this.drawThings.elements();
                while (object2.hasMoreElements()) {
                    object = (Thing)object2.nextElement();
                    if (!(object instanceof TextThing)) continue;
                    ((Thing)object).setVarsFromMaster();
                }
                this.dragShape.updateMySlaves();
                this.paintThings(graphics2);
                graphics2.dispose();
                graphics.drawImage(this.osi, 0, 0, this);
                if (this.showTime) {
                    object2 = graphics.getFont();
                    graphics.setFont(this.f);
                    object = new Format("%7.4g").form(this.time);
                    graphics.setColor(Color.black);
                    if (this.iwidth > 150) {
                        graphics.drawString(String.valueOf(String.valueOf(this.parentSApplet.label_time)).concat(String.valueOf(String.valueOf(object))), 10, 15);
                    } else {
                        graphics.drawString(String.valueOf(String.valueOf(this.parentSApplet.label_time)).concat(String.valueOf(String.valueOf(object))), 10, this.iheight - 40);
                    }
                    graphics.setFont((Font)object2);
                }
            }
            this.mouseX = d;
            this.mouseY = d2;
            this.paintCoordinates(graphics, d, d2);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.iwidth - 1, this.iheight - 1);
            graphics.dispose();
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        if (this.dragShape instanceof Pole) {
            this.stopFieldThreads();
        }
        if (this.dragShape instanceof Pole && this.showFieldVectors) {
            this.charge_Dragged(mouseEvent, true);
            return;
        }
        if (this.dragShape instanceof Charge) {
            this.charge_Dragged(mouseEvent, false);
            return;
        }
        int n = mouseEvent.getX();
        if (n < 1) {
            n = 1;
        } else if (n > this.iwidth - 2) {
            n = this.iwidth - 2;
        }
        double d = this.xFromPix(n);
        int n2 = mouseEvent.getY();
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this.iheight - 2) {
            n2 = this.iheight - 2;
        }
        double d2 = this.yFromPix(n2);
        this.mouseX = d;
        this.mouseY = d2;
        if (this.isDrag && this.dragShape != null) {
            if (this.dragV) {
                this.dragShape.setVX(d - this.dragShape.getX());
                this.dragShape.setVY(d2 - this.dragShape.getY());
            } else {
                this.dragShape.setXY(d, d2);
                if (this.dampOnMousePressed) {
                    this.dragShape.setVX(0.0);
                    this.dragShape.setVY(0.0);
                }
                this.dragShape.setAcceleration();
            }
            if (this.parentSApplet.isClockRunning()) {
                this.paintCoordinates(d, d2);
                return;
            }
            if (this.parentSApplet != null) {
                this.parentSApplet.updateDataConnections();
            }
            Enumeration enumeration = this.drawThings.elements();
            while (enumeration.hasMoreElements()) {
                Thing thing = (Thing)enumeration.nextElement();
                if (!(thing instanceof TextThing)) continue;
                thing.setVarsFromMaster();
            }
            this.dragShape.updateMySlaves();
            if (this.autoRefresh) {
                this.paint();
            }
        } else {
            this.paintCoordinates(d, d2);
            if (this.sketchMode && this.trailThing != null) {
                d = Math.min(d, this.contour.xaxis.maximum);
                d = Math.max(d, this.contour.xaxis.minimum);
                d2 = Math.min(d2, this.contour.yaxis.maximum);
                d2 = Math.max(d2, this.contour.yaxis.minimum);
                this.trailThing.incTrail(d, d2);
                Graphics graphics = this.getGraphics();
                graphics.drawImage(this.osi2, 0, 0, this);
                this.paintCoordinates(graphics, d, d2);
                if (this.sketchImage != null) {
                    graphics.drawImage(this.sketchImage, n, n2 - this.sketchImage.getHeight(this), this);
                }
                this.trailThing.paint(graphics);
                graphics.dispose();
                this.parentSApplet.updateDataConnection(this.trailThing.hashCode());
            }
        }
    }

    class FieldSolver
    implements Runnable,
    SDifferentiable {
        Color fieldColor = new Color(128, 128, 255);
        SRK45 odeSolver = new SRK45();
        Thread fieldThread = null;
        double[] fieldLine = new double[2];
        boolean plus = true;
        boolean keepRunning = true;
        boolean interrupted = false;
        DataSet data;
        int np = 0;
        int maxPts = 300;
        double[] points = new double[2 * this.maxPts];
        int scale = 1;
        Charge origin = null;
        private double[] dydx = new double[2];

        FieldSolver(double d, double d2, boolean bl, Charge charge) {
            this(d, d2, bl);
            this.origin = charge;
        }

        FieldSolver(double d, double d2, boolean bl) {
            OdeCanvas.this.calculatingFieldLines = true;
            if (((OdeCanvas)OdeCanvas.this).parentSApplet.clock.isRunning()) {
                ((OdeCanvas)OdeCanvas.this).parentSApplet.clock.stopClock();
            }
            this.plus = bl;
            this.fieldLine[0] = d;
            this.fieldLine[1] = d2;
            this.points[this.np] = d;
            this.points[this.np + 1] = d2;
            this.np += 2;
            this.odeSolver.setDifferentials((SDifferentiable)this);
            this.odeSolver.setTol(OdeCanvas.this.tolerance);
            if (this.fieldThread == null) {
                this.fieldThread = new Thread(this);
                this.fieldThread.start();
            }
            OdeCanvas.this.message = ((OdeCanvas)OdeCanvas.this).parentSApplet.label_calculating;
            Graphics graphics = OdeCanvas.this.getGraphics();
            OdeCanvas.this.paintMessage(graphics, OdeCanvas.this.message);
            graphics.dispose();
            OdeCanvas.this.fieldSolvers.addElement(this);
        }

        public int getNumEqu() {
            return 2;
        }

        public double[] rate(double[] dArray) {
            double d = -OdeCanvas.this.dudx(dArray[0], dArray[1]) + OdeCanvas.this.getPoleFx(dArray[0], dArray[1], null);
            double d2 = -OdeCanvas.this.dudy(dArray[0], dArray[1]) + OdeCanvas.this.getPoleFy(dArray[0], dArray[1], null);
            double d3 = Math.sqrt(d * d + d2 * d2);
            if (!this.plus) {
                d2 = -d2;
                d = -d;
            }
            if (d3 <= 0.0) {
                this.dydx[0] = 0.0;
                this.dydx[1] = 0.0;
                this.keepRunning = false;
            } else {
                this.dydx[0] = (double)this.scale * d / d3;
                this.dydx[1] = (double)this.scale * d2 / d3;
            }
            return this.dydx;
        }

        void stepField() {
            double d = (OdeCanvas.this.xmax - OdeCanvas.this.xmin) / 20.0;
            ((OdeCanvas)OdeCanvas.this).parentSApplet.lock.getBusyFlag();
            int n = OdeCanvas.this.pixFromX(this.fieldLine[0]);
            int n2 = OdeCanvas.this.pixFromY(this.fieldLine[1]);
            this.odeSolver.setH(d);
            this.odeSolver.stepRK45(this.fieldLine);
            int n3 = OdeCanvas.this.pixFromX(this.fieldLine[0]);
            int n4 = OdeCanvas.this.pixFromY(this.fieldLine[1]);
            ((OdeCanvas)OdeCanvas.this).parentSApplet.lock.freeBusyFlag();
            if (this.np < this.maxPts * 2) {
                this.points[this.np] = this.fieldLine[0];
                this.points[this.np + 1] = this.fieldLine[1];
                this.np += 2;
            }
            this.scale = (double)Math.abs(OdeCanvas.this.iwidth / 2 - n3) > (double)OdeCanvas.this.iwidth / 1.8 || (double)Math.abs(OdeCanvas.this.iheight / 2 - n4) > (double)OdeCanvas.this.iheight / 1.8 ? 20 : 1;
            ((OdeCanvas)OdeCanvas.this).parentSApplet.lock.getBusyFlag();
            Graphics graphics = OdeCanvas.this.getGraphics();
            graphics.setColor(Color.red);
            graphics.drawLine(n, n2, n3, n4);
            graphics.dispose();
            if (OdeCanvas.this.osi != null) {
                graphics = OdeCanvas.this.osi.getGraphics();
                graphics.setColor(Color.red);
                graphics.drawLine(n, n2, n3, n4);
                graphics.dispose();
            }
            if (OdeCanvas.this.osi2 != null) {
                graphics = OdeCanvas.this.osi2.getGraphics();
                graphics.setColor(Color.red);
                graphics.drawLine(n, n2, n3, n4);
                graphics.dispose();
            }
            ((OdeCanvas)OdeCanvas.this).parentSApplet.lock.freeBusyFlag();
            if ((OdeCanvas.this.allPositive || OdeCanvas.this.allNegative) && (n < -1 || n2 < -1 || n > OdeCanvas.this.iwidth || n2 > OdeCanvas.this.iheight)) {
                this.keepRunning = false;
            }
        }

        boolean endOfFieldLine() {
            int n = OdeCanvas.this.fieldPoles.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                Charge charge = (Charge)OdeCanvas.this.fieldPoles.elementAt(i);
                if (charge == this.origin) continue;
                int n3 = charge.getSize();
                int n4 = OdeCanvas.this.pixFromX(charge.getX());
                int n5 = OdeCanvas.this.pixFromY(charge.getY());
                int n6 = OdeCanvas.this.pixFromX(this.fieldLine[0]);
                int n7 = (n4 - n6) * (n4 - n6) + (n5 - (n2 = OdeCanvas.this.pixFromY(this.fieldLine[1]))) * (n5 - n2);
                if (n7 >= n3 * n3) continue;
                return true;
            }
            return false;
        }

        void interrupt() {
            ((OdeCanvas)OdeCanvas.this).parentSApplet.lock.getBusyFlag();
            this.interrupted = true;
            ((OdeCanvas)OdeCanvas.this).parentSApplet.lock.freeBusyFlag();
            Thread thread = this.fieldThread;
            if (thread != null) {
                thread.interrupt();
            }
        }

        public void run() {
            int n = 0;
            this.keepRunning = true;
            while (this.keepRunning) {
                try {
                    while (OdeCanvas.this.osi == null) {
                        Thread.sleep(50L);
                    }
                    this.stepField();
                    Thread.sleep(20L);
                    if (++n < this.maxPts && !this.endOfFieldLine() && !this.interrupted) continue;
                    this.keepRunning = false;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            this.fieldThread = null;
            OdeCanvas.this.fieldSolvers.removeElement(this);
            if (this.interrupted) {
                this.points = null;
                return;
            }
            ((OdeCanvas)OdeCanvas.this).parentSApplet.lock.getBusyFlag();
            this.data = OdeCanvas.this.contour.addDataSet(this.points, n);
            this.data.linecolor = this.fieldColor;
            OdeCanvas.this.fieldLines.addElement(this.data);
            ((OdeCanvas)OdeCanvas.this).parentSApplet.lock.freeBusyFlag();
            int n2 = 0;
            if (n > 150) {
                n2 = 10;
            } else if (n > 8) {
                n2 = n / 2;
            }
            if (n2 > 0) {
                double d = this.points[n2 * 2];
                double d2 = this.points[n2 * 2 + 1];
                double d3 = -OdeCanvas.this.dudx(d, d2) + OdeCanvas.this.getPoleFx(d, d2, null);
                double d4 = -OdeCanvas.this.dudy(d, d2) + OdeCanvas.this.getPoleFy(d, d2, null);
                double d5 = Math.sqrt(d3 * d3 + d4 * d4);
                if (d > OdeCanvas.this.xmin && d < OdeCanvas.this.xmax && d2 > OdeCanvas.this.ymin && d2 < OdeCanvas.this.ymax) {
                    OdeCanvas.this.arrowHeads.addElement(new ArrowHead(OdeCanvas.this, d, d2, d3 / d5, d4 / d5, this.fieldColor));
                }
            }
            if (OdeCanvas.this.fieldSolvers.size() == 0) {
                OdeCanvas.this.calculatingFieldLines = false;
                OdeCanvas.this.message = null;
                OdeCanvas.this.osiInvalid = true;
                OdeCanvas.this.repaint();
            }
        }
    }
}

