/*
 * Decompiled with CFR 0.152.
 */
package eField4;

import eField4.Charge;
import eField4.OdeCanvas;
import edu.davidson.numerics.SDifferentiable;
import edu.davidson.numerics.SRK45;

public class TestCharge
extends Charge
implements SDifferentiable {
    SRK45 odeSolver = new SRK45();
    private double[] dydx = new double[5];

    public TestCharge(OdeCanvas odeCanvas, double d, double d2, double d3, double d4) {
        super(odeCanvas, d, d2, d3, d4, 1.0);
        this.odeSolver.setDifferentials((SDifferentiable)this);
        this.sticky = false;
        this.dynamic = true;
        this.noDrag = false;
    }

    public TestCharge(OdeCanvas odeCanvas, double d, double d2, double d3, double d4, double d5) {
        super(odeCanvas, d, d2, d3, d4, d5);
        this.odeSolver.setDifferentials((SDifferentiable)this);
        this.sticky = false;
        this.dynamic = true;
        this.noDrag = false;
    }

    public int getNumEqu() {
        return 5;
    }

    public final double[] constrainedRate(double[] dArray) {
        this.dydx[0] = 1.0;
        double d = Math.sqrt(dArray[3] * dArray[3] + dArray[4] * dArray[4]);
        double d2 = this.getConstraintSlope(dArray[1], Math.abs(dArray[1]) * 0.01 + 1.0E-6);
        double d3 = (double)-1 / Math.sqrt(1.0 + d2 * d2);
        double d4 = -d2 * d3;
        double d5 = this.getConstraintSecondDeriv(dArray[1], Math.abs(dArray[1]) * 0.01 + 1.0E-6);
        double d6 = Math.abs(d5) / Math.pow(1.0 + d2 * d2, 1.5);
        this.dydx[1] = dArray[3];
        this.dydx[2] = dArray[4];
        double d7 = this.mag * (-this.p.dudx(dArray[1], dArray[2]) + this.p.getPoleFx(dArray[1], dArray[2], null) + this.p.bz * dArray[4]);
        double d8 = this.mag * (-this.p.dudy(dArray[1], dArray[2]) + this.p.getPoleFy(dArray[1], dArray[2], null) - this.p.bz * dArray[3]);
        double d9 = -d7 * d3 + d8 * d4;
        double d10 = -d * d * d6;
        this.dydx[3] = (d10 * d4 - d9 * d3 - this.damping * dArray[3]) / this.mass;
        this.dydx[4] = (d10 * d3 + d9 * d4 - this.damping * dArray[4]) / this.mass;
        this.vars[5] = this.dydx[3];
        this.vars[6] = this.dydx[4];
        return this.dydx;
    }

    public final double[] constrainedRRate(double[] dArray) {
        this.dydx[0] = 1.0;
        this.enforceConstraintOnR();
        double d = Math.sqrt(dArray[3] * dArray[3] + dArray[4] * dArray[4]);
        double d2 = (this.vars[1] - this.constantRx) / this.constantR;
        double d3 = (this.vars[2] - this.constantRy) / this.constantR;
        this.dydx[1] = dArray[3];
        this.dydx[2] = dArray[4];
        double d4 = this.mag * (-this.p.dudx(dArray[1], dArray[2]) + this.p.getPoleFx(dArray[1], dArray[2], null) + this.p.bz * dArray[4]);
        double d5 = this.mag * (-this.p.dudy(dArray[1], dArray[2]) + this.p.getPoleFy(dArray[1], dArray[2], null) - this.p.bz * dArray[3]);
        double d6 = -d4 * d3 + d5 * d2;
        double d7 = -d * d / this.constantR;
        this.dydx[3] = (d7 * d2 - d6 * d3 - this.damping * dArray[3]) / this.mass;
        this.dydx[4] = (d7 * d3 + d6 * d2 - this.damping * dArray[4]) / this.mass;
        this.vars[5] = this.dydx[3];
        this.vars[6] = this.dydx[4];
        if (this.p.dragShape == this) {
            this.dydx[3] = 0.0;
            this.dydx[4] = 0.0;
        }
        return this.dydx;
    }

    public final double[] constrainedXRate(double[] dArray) {
        dArray[1] = this.constantX;
        this.dydx[0] = 1.0;
        this.dydx[1] = 0.0;
        this.dydx[2] = dArray[4];
        this.dydx[3] = 0.0;
        this.dydx[4] = (this.mag * (-this.p.dudy(dArray[1], dArray[2]) + this.p.getPoleFy(dArray[1], dArray[2], null) - this.p.bz * dArray[3]) - this.damping * dArray[4]) / this.mass;
        this.vars[5] = 0.0;
        this.vars[6] = this.dydx[4];
        return this.dydx;
    }

    public final double[] constrainedYRate(double[] dArray) {
        dArray[2] = this.constantY;
        this.dydx[0] = 1.0;
        this.dydx[1] = dArray[3];
        this.dydx[2] = 0.0;
        this.dydx[3] = (this.mag * (-this.p.dudx(dArray[1], dArray[2]) + this.p.getPoleFx(dArray[1], dArray[2], null) + this.p.bz * dArray[4]) - this.damping * dArray[3]) / this.mass;
        this.dydx[4] = 0.0;
        this.vars[5] = this.dydx[3];
        this.vars[6] = 0.0;
        return this.dydx;
    }

    public final double[] rate(double[] dArray) {
        if (this.p.dragShape == this) {
            dArray[3] = 0.0;
            dArray[4] = 0.0;
        }
        if (this.constraint != null) {
            return this.constrainedRate(dArray);
        }
        if (this.constrainX) {
            return this.constrainedXRate(dArray);
        }
        if (this.constrainY) {
            return this.constrainedYRate(dArray);
        }
        if (this.constrainR) {
            return this.constrainedRRate(dArray);
        }
        this.dydx[0] = 1.0;
        this.dydx[1] = dArray[3];
        this.dydx[2] = dArray[4];
        this.dydx[3] = (this.mag * (-this.p.dudx(dArray[1], dArray[2]) + this.p.getPoleFx(dArray[1], dArray[2], null) + this.p.bz * dArray[4]) - this.damping * dArray[3]) / this.mass;
        this.dydx[4] = (this.mag * (-this.p.dudy(dArray[1], dArray[2]) + this.p.getPoleFy(dArray[1], dArray[2], null) - this.p.bz * dArray[3]) - this.damping * dArray[4]) / this.mass;
        this.vars[5] = this.dydx[3];
        this.vars[6] = this.dydx[4];
        if (this.p.dragShape == this) {
            this.dydx[3] = 0.0;
            this.dydx[4] = 0.0;
        }
        return this.dydx;
    }
}

