/*
 * Decompiled with CFR 0.152.
 */
package impedance;

public class Complex
implements Cloneable {
    private double r = 0.0;
    private double i = 0.0;

    public Complex() {
    }

    public Complex(double d) {
        this.r = d;
    }

    public Complex(double d, double d2) {
        this.r = d;
        this.i = d2;
    }

    public Complex(Complex complex) {
        this.r = complex.r;
        this.i = complex.i;
    }

    public boolean equals(Object object) {
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            return this.r == complex.r && this.i == complex.i;
        }
        return false;
    }

    public int hashCode() {
        return new Double(this.r).hashCode() + new Double(this.i).hashCode();
    }

    public Object clone() {
        try {
            Object object = super.clone();
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Complex add(Complex complex) {
        this.r += complex.r;
        this.i += complex.i;
        return this;
    }

    public Complex sub(Complex complex) {
        this.r -= complex.r;
        this.i += complex.i;
        return this;
    }

    public Complex mul(Complex complex) {
        double d = this.r * complex.r - this.i * complex.i;
        this.i = this.i * complex.r + this.r * complex.i;
        this.r = d;
        return this;
    }

    public Complex div(Complex complex) {
        double d = complex.r * complex.r + complex.i * complex.i;
        double d2 = (this.r * complex.r + this.i * complex.i) / d;
        this.i = (this.i * complex.r - this.r * complex.i) / d;
        this.r = d2;
        return this;
    }

    public double abs() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public String toString() {
        String string = new String();
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.r)));
        if (this.i < 0.0) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf("-j".concat(String.valueOf(String.valueOf(-this.i))))));
        } else if (this.i > 0.0) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf("+j".concat(String.valueOf(String.valueOf(this.i))))));
        }
        return string;
    }
}

