/*
 * Decompiled with CFR 0.152.
 */
package impedance;

import impedance.Netwerk;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

class Grafiek
extends Canvas {
    String label_frequency = "Frequency [Hz]";
    private int wlm = 80;
    private int w;
    private int wrm = 20;
    private int htm = 20;
    private int h;
    private int hbm = 45;
    private Netwerk netwerk;

    Grafiek(Netwerk netwerk) {
        this.netwerk = netwerk;
        this.setBackground(Color.white);
    }

    void setNetwerk(Netwerk netwerk) {
        this.netwerk = netwerk;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Double d;
        this.w = this.size().width - this.wlm - this.wrm;
        this.w = this.w < 100 ? 100 : this.w;
        this.h = this.size().height - this.htm - this.hbm;
        this.h = this.h < 100 ? 100 : this.h;
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, 0, this.size().height - 1);
        graphics.drawLine(this.size().width - 1, 0, this.size().width - 1, this.size().height - 1);
        graphics.setColor(Color.lightGray);
        int n3 = this.wlm;
        int n4 = this.htm;
        int n5 = this.w / 5;
        int n6 = this.h / 5;
        double d2 = 10.0;
        while (d2 < 1000000.0) {
            for (double d3 = d2; d3 < d2 * (double)10; d3 += d2) {
                Double d4 = new Double((Math.log(d3) / Math.log(10.0) - Math.log(d2) / Math.log(10.0)) * (double)n5);
                d = new Double((Math.log(d3) / Math.log(10.0) - Math.log(d2) / Math.log(10.0)) * (double)n6);
                n2 = d4.intValue();
                n = d.intValue();
                graphics.drawLine(n3 + n2, this.htm, n3 + n2, this.htm + this.h);
                graphics.drawLine(this.wlm, this.h + 2 * this.htm - (n4 + n), this.wlm + this.w, this.h + 2 * this.htm - (n4 + n));
            }
            d2 *= (double)10;
            n3 += n5;
            n4 += n6;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(this.wlm, this.htm, this.wlm, this.htm + this.h);
        graphics.drawLine(this.wlm, this.htm + this.h, this.wlm + this.w, this.htm + this.h);
        graphics.drawLine(this.wlm + this.w, this.htm + this.h, this.wlm + this.w, this.htm);
        graphics.drawLine(this.wlm + this.w, this.htm, this.wlm, this.htm);
        graphics.drawString("10", this.wlm - 5, this.htm + this.h + 15);
        graphics.drawString("100", this.wlm + n5 - 12, this.htm + this.h + 15);
        graphics.drawString("1K", this.wlm + 2 * n5 - 7, this.htm + this.h + 15);
        graphics.drawString("10K", this.wlm + 3 * n5 - 10, this.htm + this.h + 15);
        graphics.drawString("100K", this.wlm + 4 * n5 - 15, this.htm + this.h + 15);
        graphics.drawString("1M", this.wlm + 5 * n5 - 10, this.htm + this.h + 15);
        graphics.drawString("1M", this.wlm - 25, this.htm + 5);
        graphics.drawString("100K", this.wlm - 40, this.htm + 5 + n6);
        graphics.drawString("10K", this.wlm - 30, this.htm + 5 + 2 * n6);
        graphics.drawString("1K", this.wlm - 25, this.htm + 5 + 3 * n6);
        graphics.drawString("100", this.wlm - 30, this.htm + 5 + 4 * n6);
        graphics.drawString("10", this.wlm - 25, this.htm + 5 + 5 * n6);
        graphics.drawString(this.label_frequency, this.wlm + this.w - 100, this.htm + this.h + 35);
        graphics.drawString("|Z|", 20, this.htm + 5);
        graphics.drawString("[ohm]", 10, this.htm + 25);
        int n7 = 1;
        double d5 = Math.pow(10.0, (double)n7 / (double)(this.w / 5) + 1.0);
        double d6 = this.netwerk.Z(d5).abs();
        d = new Double((double)(this.h / 5) * (Math.log(d6) / Math.log(10.0) - 1.0));
        n2 = d.intValue();
        n2 = n2 > this.h ? this.h : n2;
        n2 = n2 < 0 ? 0 : n2;
        graphics.setColor(Color.blue);
        n = 2;
        while (n < this.w) {
            d5 = Math.pow(10.0, (double)n / (double)(this.w / 5) + 1.0);
            d6 = this.netwerk.Z(d5).abs();
            Double d7 = new Double((double)(this.h / 5) * (Math.log(d6) / Math.log(10.0) - 1.0));
            int n8 = d7.intValue();
            n8 = n8 > this.h ? this.h : n8;
            n8 = n8 < 0 ? 0 : n8;
            graphics.drawLine(n7 + this.wlm, this.h + this.htm - n2, n + this.wlm, this.h + this.htm - n8);
            n7 = n++;
            n2 = n8;
        }
    }
}

