/*
 * Decompiled with CFR 0.152.
 */
package impedance;

import impedance.Grafiek;
import impedance.Netwerk;
import impedance.Parser;
import impedance.Status;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.TextField;

public class ImpAppl
extends Applet {
    private Parser parser;
    private Netwerk netwerk;
    private TextField tf;
    private Status status;
    private Grafiek graf;
    private boolean noText = false;

    public void init() {
        String string = this.getParameter("noText");
        this.noText = string == null ? false : Boolean.valueOf(string);
        String string2 = this.getParameter("ShowControls");
        boolean bl = true;
        bl = string2 == null ? true : Boolean.valueOf(string2);
        this.setLayout(new BorderLayout());
        this.parser = new Parser();
        String string3 = this.getParameter("network");
        if (string3 == null) {
            string3 = new String("(R(1E2)+C(1E-6))//(R(1E2)+L(3E-2))");
        }
        this.parser.parseExpr(string3);
        this.netwerk = this.parser.getResult();
        this.tf = new TextField(string3);
        if (!this.noText) {
            this.add("North", this.tf);
        }
        this.graf = new Grafiek(this.netwerk);
        this.add("Center", this.graf);
        this.status = new Status(this.netwerk.toString());
        if (bl) {
            this.add("South", this.status);
        }
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof TextField) {
            String string = (String)object;
            this.setNetwork(string);
            return true;
        }
        return false;
    }

    public void setNetwork(String string) {
        if (this.parser.parseExpr(string)) {
            this.netwerk = this.parser.getResult();
            this.status.setText(this.netwerk.toString());
            this.graf.setNetwerk(this.netwerk);
        } else {
            this.tf.select(this.parser.getErrorPos() - 1, this.parser.getErrorPos());
            this.status.errorText(String.valueOf(String.valueOf(new StringBuffer("Error: ").append(this.parser.getErrorText()).append(" on position ").append(this.parser.getErrorPos()))));
        }
        this.tf.setText(string);
    }

    public String getAppletInfo() {
        return "Name: Impedance ver 0.9\r\nAuthor: Harry Broeders\r\ninfo: http://tlm.thrijswijk.nl/~bd\r\nModified by: Wolfgang Christian\r\n";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"noText", "boolean", "Show text strings."}, {"network", "String", "Initialize the network."}};
        return stringArray;
    }
}

