/*
 * Decompiled with CFR 0.152.
 */
package impedance;

import impedance.Grafiek;
import impedance.Netwerk;
import impedance.Parser;
import impedance.Status;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.TextField;

class ImpCalcFrame
extends Frame {
    private Parser parser = new Parser();
    private Netwerk netwerk;
    private TextField tf;
    private Status status;
    private Grafiek graf;

    public ImpCalcFrame() {
        super("Impedantie Calculator");
        String string = new String("(R(1E2)+C(1E-6))//(R(1E2)+L(3E-2))");
        this.parser.parseExpr(string);
        this.netwerk = this.parser.getResult();
        this.tf = new TextField(string);
        this.add("North", this.tf);
        this.graf = new Grafiek(this.netwerk);
        this.add("Center", this.graf);
        this.status = new Status(this.netwerk.toString());
        this.add("South", this.status);
        this.resize(600, 600 + this.tf.size().height + this.status.size().height);
        ((Component)this).setBackground(Color.white);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            System.exit(0);
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof TextField) {
            String string = (String)object;
            if (this.parser.parseExpr(string)) {
                this.netwerk = this.parser.getResult();
                this.status.setText(this.netwerk.toString());
                this.graf.setNetwerk(this.netwerk);
            } else {
                this.tf.select(this.parser.getErrorPos() - 1, this.parser.getErrorPos());
                this.status.errorText(String.valueOf(String.valueOf(new StringBuffer("Fout: ").append(this.parser.getErrorText()).append(" op positie ").append(this.parser.getErrorPos()))));
            }
            return true;
        }
        return false;
    }
}

