/*
 * Decompiled with CFR 0.152.
 */
package impedance;

import impedance.C;
import impedance.L;
import impedance.Netwerk;
import impedance.P;
import impedance.R;
import impedance.S;

public class Parser {
    private static final char EIND = '\ubdbd';
    private char[] a;
    private int nextToken;
    private String errorText;
    private int errorPos;
    private Netwerk netwerk;

    public boolean parseExpr(String string) {
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf('\ubdbd')));
        this.a = string.toCharArray();
        this.errorText = null;
        this.errorPos = 0;
        this.nextToken = 0;
        this.netwerk = this.expr();
        if (this.a[this.nextToken] != '\ubdbd') {
            this.error("Unknown token", this.nextToken);
        }
        return this.errorText == null;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public int getErrorPos() {
        return this.errorPos + 1;
    }

    public Netwerk getResult() {
        return this.netwerk;
    }

    private void error(String string, int n) {
        if (this.errorText == null) {
            this.errorPos = n;
            this.errorText = string;
        }
    }

    private Netwerk expr() {
        return this.restSerOperand(this.serOperand());
    }

    private Netwerk restSerOperand(Netwerk netwerk) {
        if (this.a[this.nextToken] == '+') {
            ++this.nextToken;
            return this.restSerOperand(new S(netwerk, this.serOperand()));
        }
        return netwerk;
    }

    private Netwerk serOperand() {
        return this.restParOperand(this.parOperand());
    }

    private Netwerk restParOperand(Netwerk netwerk) {
        if (this.a[this.nextToken] == '/') {
            ++this.nextToken;
            if (this.a[this.nextToken] == '/') {
                ++this.nextToken;
            }
            return this.restParOperand(new P(netwerk, this.parOperand()));
        }
        return netwerk;
    }

    private Netwerk parOperand() {
        switch (this.a[this.nextToken]) {
            case '(': {
                ++this.nextToken;
                Netwerk netwerk = this.expr();
                if (this.a[this.nextToken] != ')') {
                    this.error(") missing", this.nextToken);
                }
                if (this.a[this.nextToken] != '\ubdbd') {
                    ++this.nextToken;
                }
                return netwerk;
            }
            case 'R': 
            case 'r': {
                ++this.nextToken;
                return new R(this.doubleConst());
            }
            case 'C': 
            case 'c': {
                ++this.nextToken;
                return new C(this.doubleConst());
            }
            case 'L': 
            case 'l': {
                ++this.nextToken;
                return new L(this.doubleConst());
            }
        }
        this.error("R, C or L expected", this.nextToken);
        return null;
    }

    private double doubleConst() {
        if (this.a[this.nextToken] != '(') {
            this.error("( missing", this.nextToken);
        }
        if (this.a[this.nextToken] != '\ubdbd') {
            ++this.nextToken;
        }
        long l = this.getal();
        long l2 = this.exponent();
        if (this.a[this.nextToken] != ')') {
            this.error(") missing", this.nextToken);
        }
        if (this.a[this.nextToken] != '\ubdbd') {
            ++this.nextToken;
        }
        return (double)l * Math.pow(10.0, l2);
    }

    private long exponent() {
        if (this.a[this.nextToken] == 'E' || this.a[this.nextToken] == 'e') {
            ++this.nextToken;
            if (this.a[this.nextToken] == '-') {
                ++this.nextToken;
                return -this.getal();
            }
            return this.getal();
        }
        return 0L;
    }

    private long getal() {
        long l = 0L;
        if (Character.isDigit(this.a[this.nextToken])) {
            while (Character.isDigit(this.a[this.nextToken])) {
                l = l * (long)10 + (long)this.a[this.nextToken++] - (long)48;
            }
        } else {
            this.error("digit 0 .. 9 expected", this.nextToken);
        }
        return l;
    }

    static {
        EIND = (char)48573;
    }
}

